/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ConfigDocumentType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ListType
extends ConfigDocumentType
implements Serializable {
    private int _valueType;
    private boolean _has_valueType;
    private String _key;
    private ListValueRefType _defaultValue;
    private List _listEntryList = new ArrayList();
    private boolean _entriesFixed;
    private boolean _has_entriesFixed;
    private String _description;
    private int _listEntriesNumber;
    private boolean _has_listEntriesNumber;
    private boolean _default = true;
    private boolean _has_default;
    private static final long serialVersionUID = 15000L;

    public void addListEntry(ListValueType vListEntry) throws IndexOutOfBoundsException {
        this._listEntryList.add(vListEntry);
    }

    public void addListEntry(int index, ListValueType vListEntry) throws IndexOutOfBoundsException {
        this._listEntryList.add(index, vListEntry);
    }

    public void deleteDefault() {
        this._has_default = false;
    }

    public void deleteEntriesFixed() {
        this._has_entriesFixed = false;
    }

    public void deleteListEntriesNumber() {
        this._has_listEntriesNumber = false;
    }

    public void deleteValueType() {
        this._has_valueType = false;
    }

    public Enumeration enumerateListEntries() {
        return Collections.enumeration(this._listEntryList);
    }

    public boolean getDefault() {
        return this._default;
    }

    public ListValueRefType getDefaultValue() {
        return this._defaultValue;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean getEntriesFixed() {
        return this._entriesFixed;
    }

    public String getKey() {
        return this._key;
    }

    public ListValueType[] getListEntries() {
        ListValueType[] array = new ListValueType[]{};
        return this._listEntryList.toArray(array);
    }

    public List getListEntriesAsReference() {
        return this._listEntryList;
    }

    public int getListEntriesCount() {
        return this._listEntryList.size();
    }

    public int getListEntriesNumber() {
        return this._listEntriesNumber;
    }

    public ListValueType getListEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._listEntryList.size()) {
            throw new IndexOutOfBoundsException("getListEntry: Index value '" + index + "' not in range [0.." + (this._listEntryList.size() - 1) + "]");
        }
        return (ListValueType)this._listEntryList.get(index);
    }

    public int getValueType() {
        return this._valueType;
    }

    public boolean hasDefault() {
        return this._has_default;
    }

    public boolean hasEntriesFixed() {
        return this._has_entriesFixed;
    }

    public boolean hasListEntriesNumber() {
        return this._has_listEntriesNumber;
    }

    public boolean hasValueType() {
        return this._has_valueType;
    }

    public boolean isDefault() {
        return this._default;
    }

    public boolean isEntriesFixed() {
        return this._entriesFixed;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateListEntries() {
        return this._listEntryList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllListEntries() {
        this._listEntryList.clear();
    }

    public boolean removeListEntry(ListValueType vListEntry) {
        boolean removed = this._listEntryList.remove(vListEntry);
        return removed;
    }

    public ListValueType removeListEntryAt(int index) {
        Object obj = this._listEntryList.remove(index);
        return (ListValueType)obj;
    }

    public void setDefault(boolean _default) {
        this._default = _default;
        this._has_default = true;
    }

    public void setDefaultValue(ListValueRefType defaultValue) {
        this._defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setEntriesFixed(boolean entriesFixed) {
        this._entriesFixed = entriesFixed;
        this._has_entriesFixed = true;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setListEntries(ListValueType[] vListEntryArray) {
        this._listEntryList.clear();
        for (int i = 0; i < vListEntryArray.length; ++i) {
            this._listEntryList.add(vListEntryArray[i]);
        }
    }

    public void setListEntries(List vListEntryList) {
        this._listEntryList.clear();
        this._listEntryList.addAll(vListEntryList);
    }

    public void setListEntriesAsReference(List listEntryList) {
        this._listEntryList = listEntryList;
    }

    public void setListEntriesNumber(int listEntriesNumber) {
        this._listEntriesNumber = listEntriesNumber;
        this._has_listEntriesNumber = true;
    }

    public void setListEntry(int index, ListValueType vListEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._listEntryList.size()) {
            throw new IndexOutOfBoundsException("setListEntry: Index value '" + index + "' not in range [0.." + (this._listEntryList.size() - 1) + "]");
        }
        this._listEntryList.set(index, vListEntry);
    }

    public void setValueType(int valueType) {
        this._valueType = valueType;
        this._has_valueType = true;
    }

    public static ReferenceableObjectType unmarshalListType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(ListType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

