/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class FlexibleDataRowType
extends ObjectBaseType
implements Serializable {
    private String _ID;
    private String _parentID;
    private int _documentType;
    private boolean _has_documentType;
    private List _columnValueList;
    private BigDecimal _searchScore = new BigDecimal("0.0");
    private List _attributeList;
    private static final long serialVersionUID = 15000L;

    public FlexibleDataRowType() {
        this._columnValueList = new ArrayList();
        this.setSearchScore(new BigDecimal("0.0"));
        this._attributeList = new ArrayList();
    }

    public void addAttribute(String vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(vAttribute);
    }

    public void addAttribute(int index, String vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(index, vAttribute);
    }

    public void addColumnValue(String vColumnValue) throws IndexOutOfBoundsException {
        this._columnValueList.add(vColumnValue);
    }

    public void addColumnValue(int index, String vColumnValue) throws IndexOutOfBoundsException {
        this._columnValueList.add(index, vColumnValue);
    }

    public void deleteDocumentType() {
        this._has_documentType = false;
    }

    public Enumeration enumerateAttributes() {
        return Collections.enumeration(this._attributeList);
    }

    public Enumeration enumerateColumnValues() {
        return Collections.enumeration(this._columnValueList);
    }

    public String getAttribute(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attributeList.size()) {
            throw new IndexOutOfBoundsException("getAttribute: Index value '" + index + "' not in range [0.." + (this._attributeList.size() - 1) + "]");
        }
        return (String)this._attributeList.get(index);
    }

    public String[] getAttributes() {
        String[] array = new String[]{};
        return this._attributeList.toArray(array);
    }

    public List getAttributesAsReference() {
        return this._attributeList;
    }

    public int getAttributesCount() {
        return this._attributeList.size();
    }

    public String getColumnValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnValueList.size()) {
            throw new IndexOutOfBoundsException("getColumnValue: Index value '" + index + "' not in range [0.." + (this._columnValueList.size() - 1) + "]");
        }
        return (String)this._columnValueList.get(index);
    }

    public String[] getColumnValues() {
        String[] array = new String[]{};
        return this._columnValueList.toArray(array);
    }

    public List getColumnValuesAsReference() {
        return this._columnValueList;
    }

    public int getColumnValuesCount() {
        return this._columnValueList.size();
    }

    public int getDocumentType() {
        return this._documentType;
    }

    public String getID() {
        return this._ID;
    }

    public String getParentID() {
        return this._parentID;
    }

    public BigDecimal getSearchScore() {
        return this._searchScore;
    }

    public boolean hasDocumentType() {
        return this._has_documentType;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAttributes() {
        return this._attributeList.iterator();
    }

    public Iterator iterateColumnValues() {
        return this._columnValueList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllAttributes() {
        this._attributeList.clear();
    }

    public void removeAllColumnValues() {
        this._columnValueList.clear();
    }

    public boolean removeAttribute(String vAttribute) {
        boolean removed = this._attributeList.remove(vAttribute);
        return removed;
    }

    public String removeAttributeAt(int index) {
        Object obj = this._attributeList.remove(index);
        return (String)obj;
    }

    public boolean removeColumnValue(String vColumnValue) {
        boolean removed = this._columnValueList.remove(vColumnValue);
        return removed;
    }

    public String removeColumnValueAt(int index) {
        Object obj = this._columnValueList.remove(index);
        return (String)obj;
    }

    public void setAttribute(int index, String vAttribute) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attributeList.size()) {
            throw new IndexOutOfBoundsException("setAttribute: Index value '" + index + "' not in range [0.." + (this._attributeList.size() - 1) + "]");
        }
        this._attributeList.set(index, vAttribute);
    }

    public void setAttributes(String[] vAttributeArray) {
        this._attributeList.clear();
        for (int i = 0; i < vAttributeArray.length; ++i) {
            this._attributeList.add(vAttributeArray[i]);
        }
    }

    public void setAttributes(List vAttributeList) {
        this._attributeList.clear();
        this._attributeList.addAll(vAttributeList);
    }

    public void setAttributesAsReference(List attributeList) {
        this._attributeList = attributeList;
    }

    public void setColumnValue(int index, String vColumnValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnValueList.size()) {
            throw new IndexOutOfBoundsException("setColumnValue: Index value '" + index + "' not in range [0.." + (this._columnValueList.size() - 1) + "]");
        }
        this._columnValueList.set(index, vColumnValue);
    }

    public void setColumnValues(String[] vColumnValueArray) {
        this._columnValueList.clear();
        for (int i = 0; i < vColumnValueArray.length; ++i) {
            this._columnValueList.add(vColumnValueArray[i]);
        }
    }

    public void setColumnValues(List vColumnValueList) {
        this._columnValueList.clear();
        this._columnValueList.addAll(vColumnValueList);
    }

    public void setColumnValuesAsReference(List columnValueList) {
        this._columnValueList = columnValueList;
    }

    public void setDocumentType(int documentType) {
        this._documentType = documentType;
        this._has_documentType = true;
    }

    public void setID(String ID) {
        this._ID = ID;
    }

    public void setParentID(String parentID) {
        this._parentID = parentID;
    }

    public void setSearchScore(BigDecimal searchScore) {
        this._searchScore = searchScore;
    }

    public static FlexibleDataRowType unmarshalFlexibleDataRowType(Reader reader) throws MarshalException, ValidationException {
        return (FlexibleDataRowType)Unmarshaller.unmarshal(FlexibleDataRowType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

