/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.util.Arrays;
import net.gopro.gdf.data.ObjectBaseType;
import net.gopro.util.AttachmentStoreUtil;

public class FileAttachmentBaseType
extends ObjectBaseType {
    String registeredFileName = null;
    private static final long serialVersionUID = 1L;

    protected byte[] getStream() {
        return null;
    }

    protected void setStream(byte[] stream) {
        String oldFileName = AttachmentStoreUtil.decodeStorageFileName(this.getStream());
        String newFileName = AttachmentStoreUtil.decodeStorageFileName(stream);
        if (oldFileName != null) {
            if (newFileName != null) {
                if (!oldFileName.equals(newFileName)) {
                    AttachmentStoreUtil.unregisterFileReference(oldFileName);
                    AttachmentStoreUtil.registerFileReference(newFileName);
                    this.registeredFileName = newFileName;
                }
            } else if (stream == null || stream != null && (Arrays.equals(AttachmentStoreUtil.PSEUDO_ATTACHMENT_CONTENT, stream) || Arrays.equals(AttachmentStoreUtil.DELETED_ATTACHMENT, stream))) {
                AttachmentStoreUtil.unregisterFileReference(oldFileName);
            }
        } else if (newFileName != null) {
            AttachmentStoreUtil.registerFileReference(newFileName);
            this.registeredFileName = newFileName;
        }
    }

    protected void finalize() throws Throwable {
        String fileName = AttachmentStoreUtil.decodeStorageFileName(this.getStream());
        if (fileName != null) {
            AttachmentStoreUtil.unregisterFileReference(fileName);
        } else if (this.registeredFileName != null) {
            AttachmentStoreUtil.unregisterFileReference(this.registeredFileName);
        }
        super.finalize();
    }
}

