/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.CommunicationType;
import net.gopro.gdf.data.ExternalDocumentTemplateRefType;
import net.gopro.gdf.data.ExternalDocumentVersionRefType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.IVersionable;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ExternalDocumentType
extends CommunicationType
implements Serializable,
IVersionable {
    private ExternalDocumentTemplateRefType _template;
    private boolean _versioned;
    private boolean _has_versioned;
    private List _versionList = new ArrayList();
    private ExternalDocumentVersionType _currentVersion;
    private int _numberOfVersions = 0;
    private boolean _has_numberOfVersions;
    private ListValueRefType _language;
    private String _sharedEditingUrl;
    private static final long serialVersionUID = 15000L;

    public void addVersion(ExternalDocumentVersionRefType vVersion) throws IndexOutOfBoundsException {
        this._versionList.add(vVersion);
    }

    public void addVersion(int index, ExternalDocumentVersionRefType vVersion) throws IndexOutOfBoundsException {
        this._versionList.add(index, vVersion);
    }

    public void deleteNumberOfVersions() {
        this._has_numberOfVersions = false;
    }

    public void deleteVersioned() {
        this._has_versioned = false;
    }

    public Enumeration enumerateVersions() {
        return Collections.enumeration(this._versionList);
    }

    @Override
    public ExternalDocumentVersionType getCurrentVersion() {
        return this._currentVersion;
    }

    public ListValueRefType getLanguage() {
        return this._language;
    }

    public int getNumberOfVersions() {
        return this._numberOfVersions;
    }

    public String getSharedEditingUrl() {
        return this._sharedEditingUrl;
    }

    public ExternalDocumentTemplateRefType getTemplate() {
        return this._template;
    }

    public ExternalDocumentVersionRefType getVersion(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._versionList.size()) {
            throw new IndexOutOfBoundsException("getVersion: Index value '" + index + "' not in range [0.." + (this._versionList.size() - 1) + "]");
        }
        return (ExternalDocumentVersionRefType)this._versionList.get(index);
    }

    @Override
    public boolean getVersioned() {
        return this._versioned;
    }

    public ExternalDocumentVersionRefType[] getVersions() {
        ExternalDocumentVersionRefType[] array = new ExternalDocumentVersionRefType[]{};
        return this._versionList.toArray(array);
    }

    public List getVersionsAsReference() {
        return this._versionList;
    }

    public int getVersionsCount() {
        return this._versionList.size();
    }

    public boolean hasNumberOfVersions() {
        return this._has_numberOfVersions;
    }

    public boolean hasVersioned() {
        return this._has_versioned;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public boolean isVersioned() {
        return this._versioned;
    }

    public Iterator iterateVersions() {
        return this._versionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllVersions() {
        this._versionList.clear();
    }

    public boolean removeVersion(ExternalDocumentVersionRefType vVersion) {
        boolean removed = this._versionList.remove(vVersion);
        return removed;
    }

    public ExternalDocumentVersionRefType removeVersionAt(int index) {
        Object obj = this._versionList.remove(index);
        return (ExternalDocumentVersionRefType)obj;
    }

    @Override
    public void setCurrentVersion(ExternalDocumentVersionType currentVersion) {
        this._currentVersion = currentVersion;
    }

    public void setLanguage(ListValueRefType language) {
        this._language = language;
    }

    public void setNumberOfVersions(int numberOfVersions) {
        this._numberOfVersions = numberOfVersions;
        this._has_numberOfVersions = true;
    }

    public void setSharedEditingUrl(String sharedEditingUrl) {
        this._sharedEditingUrl = sharedEditingUrl;
    }

    public void setTemplate(ExternalDocumentTemplateRefType template) {
        this._template = template;
    }

    public void setVersion(int index, ExternalDocumentVersionRefType vVersion) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._versionList.size()) {
            throw new IndexOutOfBoundsException("setVersion: Index value '" + index + "' not in range [0.." + (this._versionList.size() - 1) + "]");
        }
        this._versionList.set(index, vVersion);
    }

    @Override
    public void setVersioned(boolean versioned) {
        this._versioned = versioned;
        this._has_versioned = true;
    }

    public void setVersions(ExternalDocumentVersionRefType[] vVersionArray) {
        this._versionList.clear();
        for (int i = 0; i < vVersionArray.length; ++i) {
            this._versionList.add(vVersionArray[i]);
        }
    }

    public void setVersions(List vVersionList) {
        this._versionList.clear();
        this._versionList.addAll(vVersionList);
    }

    public void setVersionsAsReference(List versionList) {
        this._versionList = versionList;
    }

    public static ReferenceableObjectType unmarshalExternalDocumentType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(ExternalDocumentType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

