/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.CommunicationType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.RecipientType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.types.EmailFormatType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class EMailType
extends CommunicationType
implements Serializable {
    private String _fromName;
    private String _fromEmail;
    private List _recipientList = new ArrayList();
    private List _attachmentList = new ArrayList();
    private EmailFormatType _format;
    private int _priority;
    private boolean _has_priority;
    private Date _sentDate;
    private static final long serialVersionUID = 15000L;

    public void addAttachment(FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        this._attachmentList.add(vAttachment);
    }

    public void addAttachment(int index, FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        this._attachmentList.add(index, vAttachment);
    }

    public void addRecipient(RecipientType vRecipient) throws IndexOutOfBoundsException {
        this._recipientList.add(vRecipient);
    }

    public void addRecipient(int index, RecipientType vRecipient) throws IndexOutOfBoundsException {
        this._recipientList.add(index, vRecipient);
    }

    public void deletePriority() {
        this._has_priority = false;
    }

    public Enumeration enumerateAttachments() {
        return Collections.enumeration(this._attachmentList);
    }

    public Enumeration enumerateRecipients() {
        return Collections.enumeration(this._recipientList);
    }

    public FileAttachmentType getAttachment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentList.size()) {
            throw new IndexOutOfBoundsException("getAttachment: Index value '" + index + "' not in range [0.." + (this._attachmentList.size() - 1) + "]");
        }
        return (FileAttachmentType)this._attachmentList.get(index);
    }

    public FileAttachmentType[] getAttachments() {
        FileAttachmentType[] array = new FileAttachmentType[]{};
        return this._attachmentList.toArray(array);
    }

    public List getAttachmentsAsReference() {
        return this._attachmentList;
    }

    public int getAttachmentsCount() {
        return this._attachmentList.size();
    }

    public EmailFormatType getFormat() {
        return this._format;
    }

    public String getFromEmail() {
        return this._fromEmail;
    }

    public String getFromName() {
        return this._fromName;
    }

    public int getPriority() {
        return this._priority;
    }

    public RecipientType getRecipient(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._recipientList.size()) {
            throw new IndexOutOfBoundsException("getRecipient: Index value '" + index + "' not in range [0.." + (this._recipientList.size() - 1) + "]");
        }
        return (RecipientType)this._recipientList.get(index);
    }

    public RecipientType[] getRecipients() {
        RecipientType[] array = new RecipientType[]{};
        return this._recipientList.toArray(array);
    }

    public List getRecipientsAsReference() {
        return this._recipientList;
    }

    public int getRecipientsCount() {
        return this._recipientList.size();
    }

    public Date getSentDate() {
        return this._sentDate;
    }

    public boolean hasPriority() {
        return this._has_priority;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAttachments() {
        return this._attachmentList.iterator();
    }

    public Iterator iterateRecipients() {
        return this._recipientList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllAttachments() {
        this._attachmentList.clear();
    }

    public void removeAllRecipients() {
        this._recipientList.clear();
    }

    public boolean removeAttachment(FileAttachmentType vAttachment) {
        boolean removed = this._attachmentList.remove(vAttachment);
        return removed;
    }

    public FileAttachmentType removeAttachmentAt(int index) {
        Object obj = this._attachmentList.remove(index);
        return (FileAttachmentType)obj;
    }

    public boolean removeRecipient(RecipientType vRecipient) {
        boolean removed = this._recipientList.remove(vRecipient);
        return removed;
    }

    public RecipientType removeRecipientAt(int index) {
        Object obj = this._recipientList.remove(index);
        return (RecipientType)obj;
    }

    public void setAttachment(int index, FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentList.size()) {
            throw new IndexOutOfBoundsException("setAttachment: Index value '" + index + "' not in range [0.." + (this._attachmentList.size() - 1) + "]");
        }
        this._attachmentList.set(index, vAttachment);
    }

    public void setAttachments(FileAttachmentType[] vAttachmentArray) {
        this._attachmentList.clear();
        for (int i = 0; i < vAttachmentArray.length; ++i) {
            this._attachmentList.add(vAttachmentArray[i]);
        }
    }

    public void setAttachments(List vAttachmentList) {
        this._attachmentList.clear();
        this._attachmentList.addAll(vAttachmentList);
    }

    public void setAttachmentsAsReference(List attachmentList) {
        this._attachmentList = attachmentList;
    }

    public void setFormat(EmailFormatType format) {
        this._format = format;
    }

    public void setFromEmail(String fromEmail) {
        this._fromEmail = fromEmail;
    }

    public void setFromName(String fromName) {
        this._fromName = fromName;
    }

    public void setPriority(int priority) {
        this._priority = priority;
        this._has_priority = true;
    }

    public void setRecipient(int index, RecipientType vRecipient) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._recipientList.size()) {
            throw new IndexOutOfBoundsException("setRecipient: Index value '" + index + "' not in range [0.." + (this._recipientList.size() - 1) + "]");
        }
        this._recipientList.set(index, vRecipient);
    }

    public void setRecipients(RecipientType[] vRecipientArray) {
        this._recipientList.clear();
        for (int i = 0; i < vRecipientArray.length; ++i) {
            this._recipientList.add(vRecipientArray[i]);
        }
    }

    public void setRecipients(List vRecipientList) {
        this._recipientList.clear();
        this._recipientList.addAll(vRecipientList);
    }

    public void setRecipientsAsReference(List recipientList) {
        this._recipientList = recipientList;
    }

    public void setSentDate(Date sentDate) {
        this._sentDate = sentDate;
    }

    public static ReferenceableObjectType unmarshalEMailType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(EMailType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

