/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentVersionFilterType;
import net.gopro.gdf.data.types.FilterScopeType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.data.types.ResponsibleFilterType;
import net.gopro.gdf.data.types.StatusFilterType;
import net.gopro.gdf.data.types.TagType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DocumentFilterType
extends DocumentBaseType
implements Serializable {
    private int _dataLoadingOptions;
    private boolean _has_dataLoadingOptions;
    private String _alias;
    private int _startRow;
    private boolean _has_startRow;
    private int _rowsCount;
    private boolean _has_rowsCount;
    private int _documentFormType = 0;
    private boolean _has_documentFormType;
    private List _filterDocumentIDList;
    private List _filterParentIDList;
    private DeleteStatusType _deleteStatus = DeleteStatusType.valueOf("NotDeleted");
    private TagType _documentUserTag;
    private HiddenStatusType _hiddenStatus = HiddenStatusType.valueOf("NotHidden");
    private String _sortColumn;
    private boolean _sortDescending = false;
    private boolean _has_sortDescending;
    private FilterExpressionType _customFilter;
    private String _fullTextSearch;
    private List _loadColumnList;
    private boolean _loadDefaultColumns;
    private boolean _has_loadDefaultColumns;
    private ResponsibleFilterType _responsibility = ResponsibleFilterType.valueOf("None");
    private StatusFilterType _statusFilter = StatusFilterType.valueOf("None");
    private boolean _loadBinaryData = false;
    private boolean _has_loadBinaryData;
    private List _excludedDocumentTypeList;
    private DocumentVersionFilterType _documentVersionFilter;
    private String _filterInvolvedPartyID;
    private FilterScopeType _filterScope;
    private static final long serialVersionUID = 15000L;

    public DocumentFilterType() {
        this._filterDocumentIDList = new ArrayList();
        this._filterParentIDList = new ArrayList();
        this.setDeleteStatus(DeleteStatusType.valueOf("NotDeleted"));
        this.setHiddenStatus(HiddenStatusType.valueOf("NotHidden"));
        this._loadColumnList = new ArrayList();
        this.setResponsibility(ResponsibleFilterType.valueOf("None"));
        this.setStatusFilter(StatusFilterType.valueOf("None"));
        this._excludedDocumentTypeList = new ArrayList();
    }

    public void addExcludedDocumentType(int vExcludedDocumentType) throws IndexOutOfBoundsException {
        this._excludedDocumentTypeList.add(new Integer(vExcludedDocumentType));
    }

    public void addExcludedDocumentType(int index, int vExcludedDocumentType) throws IndexOutOfBoundsException {
        this._excludedDocumentTypeList.add(index, new Integer(vExcludedDocumentType));
    }

    public void addFilterDocumentID(String vFilterDocumentID) throws IndexOutOfBoundsException {
        this._filterDocumentIDList.add(vFilterDocumentID);
    }

    public void addFilterDocumentID(int index, String vFilterDocumentID) throws IndexOutOfBoundsException {
        this._filterDocumentIDList.add(index, vFilterDocumentID);
    }

    public void addFilterParentID(String vFilterParentID) throws IndexOutOfBoundsException {
        this._filterParentIDList.add(vFilterParentID);
    }

    public void addFilterParentID(int index, String vFilterParentID) throws IndexOutOfBoundsException {
        this._filterParentIDList.add(index, vFilterParentID);
    }

    public void addLoadColumn(String vLoadColumn) throws IndexOutOfBoundsException {
        this._loadColumnList.add(vLoadColumn);
    }

    public void addLoadColumn(int index, String vLoadColumn) throws IndexOutOfBoundsException {
        this._loadColumnList.add(index, vLoadColumn);
    }

    public void deleteDataLoadingOptions() {
        this._has_dataLoadingOptions = false;
    }

    public void deleteDocumentFormType() {
        this._has_documentFormType = false;
    }

    public void deleteLoadBinaryData() {
        this._has_loadBinaryData = false;
    }

    public void deleteLoadDefaultColumns() {
        this._has_loadDefaultColumns = false;
    }

    public void deleteRowsCount() {
        this._has_rowsCount = false;
    }

    public void deleteSortDescending() {
        this._has_sortDescending = false;
    }

    public void deleteStartRow() {
        this._has_startRow = false;
    }

    public Enumeration enumerateExcludedDocumentTypes() {
        return Collections.enumeration(this._excludedDocumentTypeList);
    }

    public Enumeration enumerateFilterDocumentIDs() {
        return Collections.enumeration(this._filterDocumentIDList);
    }

    public Enumeration enumerateFilterParentIDs() {
        return Collections.enumeration(this._filterParentIDList);
    }

    public Enumeration enumerateLoadColumns() {
        return Collections.enumeration(this._loadColumnList);
    }

    public String getAlias() {
        return this._alias;
    }

    public FilterExpressionType getCustomFilter() {
        return this._customFilter;
    }

    public int getDataLoadingOptions() {
        return this._dataLoadingOptions;
    }

    public DeleteStatusType getDeleteStatus() {
        return this._deleteStatus;
    }

    public int getDocumentFormType() {
        return this._documentFormType;
    }

    public TagType getDocumentUserTag() {
        return this._documentUserTag;
    }

    public DocumentVersionFilterType getDocumentVersionFilter() {
        return this._documentVersionFilter;
    }

    public int getExcludedDocumentType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._excludedDocumentTypeList.size()) {
            throw new IndexOutOfBoundsException("getExcludedDocumentType: Index value '" + index + "' not in range [0.." + (this._excludedDocumentTypeList.size() - 1) + "]");
        }
        return (Integer)this._excludedDocumentTypeList.get(index);
    }

    public int[] getExcludedDocumentTypes() {
        int size = this._excludedDocumentTypeList.size();
        int[] array = new int[size];
        Iterator iter = this._excludedDocumentTypeList.iterator();
        for (int index = 0; index < size; ++index) {
            array[index] = (Integer)iter.next();
        }
        return array;
    }

    public List getExcludedDocumentTypesAsReference() {
        return this._excludedDocumentTypeList;
    }

    public int getExcludedDocumentTypesCount() {
        return this._excludedDocumentTypeList.size();
    }

    public String getFilterDocumentID(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterDocumentIDList.size()) {
            throw new IndexOutOfBoundsException("getFilterDocumentID: Index value '" + index + "' not in range [0.." + (this._filterDocumentIDList.size() - 1) + "]");
        }
        return (String)this._filterDocumentIDList.get(index);
    }

    public String[] getFilterDocumentIDs() {
        String[] array = new String[]{};
        return this._filterDocumentIDList.toArray(array);
    }

    public List getFilterDocumentIDsAsReference() {
        return this._filterDocumentIDList;
    }

    public int getFilterDocumentIDsCount() {
        return this._filterDocumentIDList.size();
    }

    public String getFilterInvolvedPartyID() {
        return this._filterInvolvedPartyID;
    }

    public String getFilterParentID(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterParentIDList.size()) {
            throw new IndexOutOfBoundsException("getFilterParentID: Index value '" + index + "' not in range [0.." + (this._filterParentIDList.size() - 1) + "]");
        }
        return (String)this._filterParentIDList.get(index);
    }

    public String[] getFilterParentIDs() {
        String[] array = new String[]{};
        return this._filterParentIDList.toArray(array);
    }

    public List getFilterParentIDsAsReference() {
        return this._filterParentIDList;
    }

    public int getFilterParentIDsCount() {
        return this._filterParentIDList.size();
    }

    public FilterScopeType getFilterScope() {
        return this._filterScope;
    }

    public String getFullTextSearch() {
        return this._fullTextSearch;
    }

    public HiddenStatusType getHiddenStatus() {
        return this._hiddenStatus;
    }

    public boolean getLoadBinaryData() {
        return this._loadBinaryData;
    }

    public String getLoadColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._loadColumnList.size()) {
            throw new IndexOutOfBoundsException("getLoadColumn: Index value '" + index + "' not in range [0.." + (this._loadColumnList.size() - 1) + "]");
        }
        return (String)this._loadColumnList.get(index);
    }

    public String[] getLoadColumns() {
        String[] array = new String[]{};
        return this._loadColumnList.toArray(array);
    }

    public List getLoadColumnsAsReference() {
        return this._loadColumnList;
    }

    public int getLoadColumnsCount() {
        return this._loadColumnList.size();
    }

    public boolean getLoadDefaultColumns() {
        return this._loadDefaultColumns;
    }

    public ResponsibleFilterType getResponsibility() {
        return this._responsibility;
    }

    public int getRowsCount() {
        return this._rowsCount;
    }

    public String getSortColumn() {
        return this._sortColumn;
    }

    public boolean getSortDescending() {
        return this._sortDescending;
    }

    public int getStartRow() {
        return this._startRow;
    }

    public StatusFilterType getStatusFilter() {
        return this._statusFilter;
    }

    public boolean hasDataLoadingOptions() {
        return this._has_dataLoadingOptions;
    }

    public boolean hasDocumentFormType() {
        return this._has_documentFormType;
    }

    public boolean hasLoadBinaryData() {
        return this._has_loadBinaryData;
    }

    public boolean hasLoadDefaultColumns() {
        return this._has_loadDefaultColumns;
    }

    public boolean hasRowsCount() {
        return this._has_rowsCount;
    }

    public boolean hasSortDescending() {
        return this._has_sortDescending;
    }

    public boolean hasStartRow() {
        return this._has_startRow;
    }

    public boolean isLoadBinaryData() {
        return this._loadBinaryData;
    }

    public boolean isLoadDefaultColumns() {
        return this._loadDefaultColumns;
    }

    public boolean isSortDescending() {
        return this._sortDescending;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateExcludedDocumentTypes() {
        return this._excludedDocumentTypeList.iterator();
    }

    public Iterator iterateFilterDocumentIDs() {
        return this._filterDocumentIDList.iterator();
    }

    public Iterator iterateFilterParentIDs() {
        return this._filterParentIDList.iterator();
    }

    public Iterator iterateLoadColumns() {
        return this._loadColumnList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllExcludedDocumentTypes() {
        this._excludedDocumentTypeList.clear();
    }

    public void removeAllFilterDocumentIDs() {
        this._filterDocumentIDList.clear();
    }

    public void removeAllFilterParentIDs() {
        this._filterParentIDList.clear();
    }

    public void removeAllLoadColumns() {
        this._loadColumnList.clear();
    }

    public boolean removeExcludedDocumentType(int vExcludedDocumentType) {
        boolean removed = this._excludedDocumentTypeList.remove(new Integer(vExcludedDocumentType));
        return removed;
    }

    public int removeExcludedDocumentTypeAt(int index) {
        Object obj = this._excludedDocumentTypeList.remove(index);
        return (Integer)obj;
    }

    public boolean removeFilterDocumentID(String vFilterDocumentID) {
        boolean removed = this._filterDocumentIDList.remove(vFilterDocumentID);
        return removed;
    }

    public String removeFilterDocumentIDAt(int index) {
        Object obj = this._filterDocumentIDList.remove(index);
        return (String)obj;
    }

    public boolean removeFilterParentID(String vFilterParentID) {
        boolean removed = this._filterParentIDList.remove(vFilterParentID);
        return removed;
    }

    public String removeFilterParentIDAt(int index) {
        Object obj = this._filterParentIDList.remove(index);
        return (String)obj;
    }

    public boolean removeLoadColumn(String vLoadColumn) {
        boolean removed = this._loadColumnList.remove(vLoadColumn);
        return removed;
    }

    public String removeLoadColumnAt(int index) {
        Object obj = this._loadColumnList.remove(index);
        return (String)obj;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setCustomFilter(FilterExpressionType customFilter) {
        this._customFilter = customFilter;
    }

    public void setDataLoadingOptions(int dataLoadingOptions) {
        this._dataLoadingOptions = dataLoadingOptions;
        this._has_dataLoadingOptions = true;
    }

    public void setDeleteStatus(DeleteStatusType deleteStatus) {
        this._deleteStatus = deleteStatus;
    }

    public void setDocumentFormType(int documentFormType) {
        this._documentFormType = documentFormType;
        this._has_documentFormType = true;
    }

    public void setDocumentUserTag(TagType documentUserTag) {
        this._documentUserTag = documentUserTag;
    }

    public void setDocumentVersionFilter(DocumentVersionFilterType documentVersionFilter) {
        this._documentVersionFilter = documentVersionFilter;
    }

    public void setExcludedDocumentType(int index, int vExcludedDocumentType) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._excludedDocumentTypeList.size()) {
            throw new IndexOutOfBoundsException("setExcludedDocumentType: Index value '" + index + "' not in range [0.." + (this._excludedDocumentTypeList.size() - 1) + "]");
        }
        this._excludedDocumentTypeList.set(index, new Integer(vExcludedDocumentType));
    }

    public void setExcludedDocumentTypes(int[] vExcludedDocumentTypeArray) {
        this._excludedDocumentTypeList.clear();
        for (int i = 0; i < vExcludedDocumentTypeArray.length; ++i) {
            this._excludedDocumentTypeList.add(new Integer(vExcludedDocumentTypeArray[i]));
        }
    }

    public void setExcludedDocumentTypes(List vExcludedDocumentTypeList) {
        this._excludedDocumentTypeList.clear();
        this._excludedDocumentTypeList.addAll(vExcludedDocumentTypeList);
    }

    public void setExcludedDocumentTypesAsReference(List excludedDocumentTypeList) {
        this._excludedDocumentTypeList = excludedDocumentTypeList;
    }

    public void setFilterDocumentID(int index, String vFilterDocumentID) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterDocumentIDList.size()) {
            throw new IndexOutOfBoundsException("setFilterDocumentID: Index value '" + index + "' not in range [0.." + (this._filterDocumentIDList.size() - 1) + "]");
        }
        this._filterDocumentIDList.set(index, vFilterDocumentID);
    }

    public void setFilterDocumentIDs(String[] vFilterDocumentIDArray) {
        this._filterDocumentIDList.clear();
        for (int i = 0; i < vFilterDocumentIDArray.length; ++i) {
            this._filterDocumentIDList.add(vFilterDocumentIDArray[i]);
        }
    }

    public void setFilterDocumentIDs(List vFilterDocumentIDList) {
        this._filterDocumentIDList.clear();
        this._filterDocumentIDList.addAll(vFilterDocumentIDList);
    }

    public void setFilterDocumentIDsAsReference(List filterDocumentIDList) {
        this._filterDocumentIDList = filterDocumentIDList;
    }

    public void setFilterInvolvedPartyID(String filterInvolvedPartyID) {
        this._filterInvolvedPartyID = filterInvolvedPartyID;
    }

    public void setFilterParentID(int index, String vFilterParentID) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterParentIDList.size()) {
            throw new IndexOutOfBoundsException("setFilterParentID: Index value '" + index + "' not in range [0.." + (this._filterParentIDList.size() - 1) + "]");
        }
        this._filterParentIDList.set(index, vFilterParentID);
    }

    public void setFilterParentIDs(String[] vFilterParentIDArray) {
        this._filterParentIDList.clear();
        for (int i = 0; i < vFilterParentIDArray.length; ++i) {
            this._filterParentIDList.add(vFilterParentIDArray[i]);
        }
    }

    public void setFilterParentIDs(List vFilterParentIDList) {
        this._filterParentIDList.clear();
        this._filterParentIDList.addAll(vFilterParentIDList);
    }

    public void setFilterParentIDsAsReference(List filterParentIDList) {
        this._filterParentIDList = filterParentIDList;
    }

    public void setFilterScope(FilterScopeType filterScope) {
        this._filterScope = filterScope;
    }

    public void setFullTextSearch(String fullTextSearch) {
        this._fullTextSearch = fullTextSearch;
    }

    public void setHiddenStatus(HiddenStatusType hiddenStatus) {
        this._hiddenStatus = hiddenStatus;
    }

    public void setLoadBinaryData(boolean loadBinaryData) {
        this._loadBinaryData = loadBinaryData;
        this._has_loadBinaryData = true;
    }

    public void setLoadColumn(int index, String vLoadColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._loadColumnList.size()) {
            throw new IndexOutOfBoundsException("setLoadColumn: Index value '" + index + "' not in range [0.." + (this._loadColumnList.size() - 1) + "]");
        }
        this._loadColumnList.set(index, vLoadColumn);
    }

    public void setLoadColumns(String[] vLoadColumnArray) {
        this._loadColumnList.clear();
        for (int i = 0; i < vLoadColumnArray.length; ++i) {
            this._loadColumnList.add(vLoadColumnArray[i]);
        }
    }

    public void setLoadColumns(List vLoadColumnList) {
        this._loadColumnList.clear();
        this._loadColumnList.addAll(vLoadColumnList);
    }

    public void setLoadColumnsAsReference(List loadColumnList) {
        this._loadColumnList = loadColumnList;
    }

    public void setLoadDefaultColumns(boolean loadDefaultColumns) {
        this._loadDefaultColumns = loadDefaultColumns;
        this._has_loadDefaultColumns = true;
    }

    public void setResponsibility(ResponsibleFilterType responsibility) {
        this._responsibility = responsibility;
    }

    public void setRowsCount(int rowsCount) {
        this._rowsCount = rowsCount;
        this._has_rowsCount = true;
    }

    public void setSortColumn(String sortColumn) {
        this._sortColumn = sortColumn;
    }

    public void setSortDescending(boolean sortDescending) {
        this._sortDescending = sortDescending;
        this._has_sortDescending = true;
    }

    public void setStartRow(int startRow) {
        this._startRow = startRow;
        this._has_startRow = true;
    }

    public void setStatusFilter(StatusFilterType statusFilter) {
        this._statusFilter = statusFilter;
    }

    public static ReferenceableObjectType unmarshalDocumentFilterType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(DocumentFilterType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

