/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLType;
import net.gopro.gdf.data.ContextPropertiesType;
import net.gopro.gdf.data.HistoryType;
import net.gopro.gdf.data.IBusinessObjectType;
import net.gopro.gdf.data.IDeleteable;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.types.CheckedOutStatusType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DocumentBaseType
extends ReferenceableObjectType
implements Serializable,
IBusinessObjectType,
IDeleteable {
    private UserRefType _createdBy;
    private Date _creationDate;
    private UserRefType _modifiedBy;
    private Date _modifiedDate;
    private UserRefType _deletedBy;
    private Date _deletedDate;
    private String _subject;
    private List _metaDataEntryList = new ArrayList();
    private List _ACLEntryList = new ArrayList();
    private List _historyEntryList = new ArrayList();
    private boolean _markedForDelete;
    private boolean _has_markedForDelete;
    private boolean _hidden;
    private boolean _has_hidden;
    private ContextPropertiesType _contextProperties;
    private CheckedOutStatusType _checkedOutStatus;
    private UserRefType _checkedOutBy;
    private Date _checkedOutDate;
    private String _checkedOutComment;
    private List _attachmentNameList = new ArrayList();
    private ListValueRefType _documentType;
    private int _responseCount = -1;
    private boolean _has_responseCount;
    private byte[] _thumbprint;
    private String _originalSubject;
    private String _tenantID;
    private boolean _multiTenant;
    private boolean _has_multiTenant;
    private static final long serialVersionUID = 15000L;

    public void addACLEntry(ACLType vACLEntry) throws IndexOutOfBoundsException {
        this._ACLEntryList.add(vACLEntry);
    }

    public void addACLEntry(int index, ACLType vACLEntry) throws IndexOutOfBoundsException {
        this._ACLEntryList.add(index, vACLEntry);
    }

    public void addAttachmentName(String vAttachmentName) throws IndexOutOfBoundsException {
        this._attachmentNameList.add(vAttachmentName);
    }

    public void addAttachmentName(int index, String vAttachmentName) throws IndexOutOfBoundsException {
        this._attachmentNameList.add(index, vAttachmentName);
    }

    public void addHistoryEntry(HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        this._historyEntryList.add(vHistoryEntry);
    }

    public void addHistoryEntry(int index, HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        this._historyEntryList.add(index, vHistoryEntry);
    }

    public void addMetaDataEntry(MetaDataType vMetaDataEntry) throws IndexOutOfBoundsException {
        this._metaDataEntryList.add(vMetaDataEntry);
    }

    public void addMetaDataEntry(int index, MetaDataType vMetaDataEntry) throws IndexOutOfBoundsException {
        this._metaDataEntryList.add(index, vMetaDataEntry);
    }

    public void deleteHidden() {
        this._has_hidden = false;
    }

    public void deleteMarkedForDelete() {
        this._has_markedForDelete = false;
    }

    public void deleteMultiTenant() {
        this._has_multiTenant = false;
    }

    public void deleteResponseCount() {
        this._has_responseCount = false;
    }

    public Enumeration enumerateACLEntries() {
        return Collections.enumeration(this._ACLEntryList);
    }

    public Enumeration enumerateAttachmentNames() {
        return Collections.enumeration(this._attachmentNameList);
    }

    public Enumeration enumerateHistoryEntries() {
        return Collections.enumeration(this._historyEntryList);
    }

    public Enumeration enumerateMetaDataEntries() {
        return Collections.enumeration(this._metaDataEntryList);
    }

    public ACLType[] getACLEntries() {
        ACLType[] array = new ACLType[]{};
        return this._ACLEntryList.toArray(array);
    }

    public List getACLEntriesAsReference() {
        return this._ACLEntryList;
    }

    public int getACLEntriesCount() {
        return this._ACLEntryList.size();
    }

    public ACLType getACLEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ACLEntryList.size()) {
            throw new IndexOutOfBoundsException("getACLEntry: Index value '" + index + "' not in range [0.." + (this._ACLEntryList.size() - 1) + "]");
        }
        return (ACLType)this._ACLEntryList.get(index);
    }

    public String getAttachmentName(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentNameList.size()) {
            throw new IndexOutOfBoundsException("getAttachmentName: Index value '" + index + "' not in range [0.." + (this._attachmentNameList.size() - 1) + "]");
        }
        return (String)this._attachmentNameList.get(index);
    }

    public String[] getAttachmentNames() {
        String[] array = new String[]{};
        return this._attachmentNameList.toArray(array);
    }

    public List getAttachmentNamesAsReference() {
        return this._attachmentNameList;
    }

    public int getAttachmentNamesCount() {
        return this._attachmentNameList.size();
    }

    public UserRefType getCheckedOutBy() {
        return this._checkedOutBy;
    }

    public String getCheckedOutComment() {
        return this._checkedOutComment;
    }

    public Date getCheckedOutDate() {
        return this._checkedOutDate;
    }

    public CheckedOutStatusType getCheckedOutStatus() {
        return this._checkedOutStatus;
    }

    public ContextPropertiesType getContextProperties() {
        return this._contextProperties;
    }

    public UserRefType getCreatedBy() {
        return this._createdBy;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    @Override
    public UserRefType getDeletedBy() {
        return this._deletedBy;
    }

    @Override
    public Date getDeletedDate() {
        return this._deletedDate;
    }

    public ListValueRefType getDocumentType() {
        return this._documentType;
    }

    public boolean getHidden() {
        return this._hidden;
    }

    public HistoryType[] getHistoryEntries() {
        HistoryType[] array = new HistoryType[]{};
        return this._historyEntryList.toArray(array);
    }

    public List getHistoryEntriesAsReference() {
        return this._historyEntryList;
    }

    public int getHistoryEntriesCount() {
        return this._historyEntryList.size();
    }

    public HistoryType getHistoryEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._historyEntryList.size()) {
            throw new IndexOutOfBoundsException("getHistoryEntry: Index value '" + index + "' not in range [0.." + (this._historyEntryList.size() - 1) + "]");
        }
        return (HistoryType)this._historyEntryList.get(index);
    }

    @Override
    public boolean getMarkedForDelete() {
        return this._markedForDelete;
    }

    public MetaDataType[] getMetaDataEntries() {
        MetaDataType[] array = new MetaDataType[]{};
        return this._metaDataEntryList.toArray(array);
    }

    public List getMetaDataEntriesAsReference() {
        return this._metaDataEntryList;
    }

    public int getMetaDataEntriesCount() {
        return this._metaDataEntryList.size();
    }

    public MetaDataType getMetaDataEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._metaDataEntryList.size()) {
            throw new IndexOutOfBoundsException("getMetaDataEntry: Index value '" + index + "' not in range [0.." + (this._metaDataEntryList.size() - 1) + "]");
        }
        return (MetaDataType)this._metaDataEntryList.get(index);
    }

    public UserRefType getModifiedBy() {
        return this._modifiedBy;
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean getMultiTenant() {
        return this._multiTenant;
    }

    public String getOriginalSubject() {
        return this._originalSubject;
    }

    public int getResponseCount() {
        return this._responseCount;
    }

    public String getSubject() {
        return this._subject;
    }

    public String getTenantID() {
        return this._tenantID;
    }

    public byte[] getThumbprint() {
        return this._thumbprint;
    }

    public boolean hasHidden() {
        return this._has_hidden;
    }

    public boolean hasMarkedForDelete() {
        return this._has_markedForDelete;
    }

    public boolean hasMultiTenant() {
        return this._has_multiTenant;
    }

    public boolean hasResponseCount() {
        return this._has_responseCount;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public boolean isMarkedForDelete() {
        return this._markedForDelete;
    }

    public boolean isMultiTenant() {
        return this._multiTenant;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateACLEntries() {
        return this._ACLEntryList.iterator();
    }

    public Iterator iterateAttachmentNames() {
        return this._attachmentNameList.iterator();
    }

    public Iterator iterateHistoryEntries() {
        return this._historyEntryList.iterator();
    }

    public Iterator iterateMetaDataEntries() {
        return this._metaDataEntryList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeACLEntry(ACLType vACLEntry) {
        boolean removed = this._ACLEntryList.remove(vACLEntry);
        return removed;
    }

    public ACLType removeACLEntryAt(int index) {
        Object obj = this._ACLEntryList.remove(index);
        return (ACLType)obj;
    }

    public void removeAllACLEntries() {
        this._ACLEntryList.clear();
    }

    public void removeAllAttachmentNames() {
        this._attachmentNameList.clear();
    }

    public void removeAllHistoryEntries() {
        this._historyEntryList.clear();
    }

    public void removeAllMetaDataEntries() {
        this._metaDataEntryList.clear();
    }

    public boolean removeAttachmentName(String vAttachmentName) {
        boolean removed = this._attachmentNameList.remove(vAttachmentName);
        return removed;
    }

    public String removeAttachmentNameAt(int index) {
        Object obj = this._attachmentNameList.remove(index);
        return (String)obj;
    }

    public boolean removeHistoryEntry(HistoryType vHistoryEntry) {
        boolean removed = this._historyEntryList.remove(vHistoryEntry);
        return removed;
    }

    public HistoryType removeHistoryEntryAt(int index) {
        Object obj = this._historyEntryList.remove(index);
        return (HistoryType)obj;
    }

    public boolean removeMetaDataEntry(MetaDataType vMetaDataEntry) {
        boolean removed = this._metaDataEntryList.remove(vMetaDataEntry);
        return removed;
    }

    public MetaDataType removeMetaDataEntryAt(int index) {
        Object obj = this._metaDataEntryList.remove(index);
        return (MetaDataType)obj;
    }

    public void setACLEntries(ACLType[] vACLEntryArray) {
        this._ACLEntryList.clear();
        for (int i = 0; i < vACLEntryArray.length; ++i) {
            this._ACLEntryList.add(vACLEntryArray[i]);
        }
    }

    public void setACLEntries(List vACLEntryList) {
        this._ACLEntryList.clear();
        this._ACLEntryList.addAll(vACLEntryList);
    }

    public void setACLEntriesAsReference(List ACLEntryList) {
        this._ACLEntryList = ACLEntryList;
    }

    public void setACLEntry(int index, ACLType vACLEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ACLEntryList.size()) {
            throw new IndexOutOfBoundsException("setACLEntry: Index value '" + index + "' not in range [0.." + (this._ACLEntryList.size() - 1) + "]");
        }
        this._ACLEntryList.set(index, vACLEntry);
    }

    public void setAttachmentName(int index, String vAttachmentName) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentNameList.size()) {
            throw new IndexOutOfBoundsException("setAttachmentName: Index value '" + index + "' not in range [0.." + (this._attachmentNameList.size() - 1) + "]");
        }
        this._attachmentNameList.set(index, vAttachmentName);
    }

    public void setAttachmentNames(String[] vAttachmentNameArray) {
        this._attachmentNameList.clear();
        for (int i = 0; i < vAttachmentNameArray.length; ++i) {
            this._attachmentNameList.add(vAttachmentNameArray[i]);
        }
    }

    public void setAttachmentNames(List vAttachmentNameList) {
        this._attachmentNameList.clear();
        this._attachmentNameList.addAll(vAttachmentNameList);
    }

    public void setAttachmentNamesAsReference(List attachmentNameList) {
        this._attachmentNameList = attachmentNameList;
    }

    public void setCheckedOutBy(UserRefType checkedOutBy) {
        this._checkedOutBy = checkedOutBy;
    }

    public void setCheckedOutComment(String checkedOutComment) {
        this._checkedOutComment = checkedOutComment;
    }

    public void setCheckedOutDate(Date checkedOutDate) {
        this._checkedOutDate = checkedOutDate;
    }

    public void setCheckedOutStatus(CheckedOutStatusType checkedOutStatus) {
        this._checkedOutStatus = checkedOutStatus;
    }

    public void setContextProperties(ContextPropertiesType contextProperties) {
        this._contextProperties = contextProperties;
    }

    public void setCreatedBy(UserRefType createdBy) {
        this._createdBy = createdBy;
    }

    public void setCreationDate(Date creationDate) {
        this._creationDate = creationDate;
    }

    @Override
    public void setDeletedBy(UserRefType deletedBy) {
        this._deletedBy = deletedBy;
    }

    @Override
    public void setDeletedDate(Date deletedDate) {
        this._deletedDate = deletedDate;
    }

    public void setDocumentType(ListValueRefType documentType) {
        this._documentType = documentType;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
        this._has_hidden = true;
    }

    public void setHistoryEntries(HistoryType[] vHistoryEntryArray) {
        this._historyEntryList.clear();
        for (int i = 0; i < vHistoryEntryArray.length; ++i) {
            this._historyEntryList.add(vHistoryEntryArray[i]);
        }
    }

    public void setHistoryEntries(List vHistoryEntryList) {
        this._historyEntryList.clear();
        this._historyEntryList.addAll(vHistoryEntryList);
    }

    public void setHistoryEntriesAsReference(List historyEntryList) {
        this._historyEntryList = historyEntryList;
    }

    public void setHistoryEntry(int index, HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._historyEntryList.size()) {
            throw new IndexOutOfBoundsException("setHistoryEntry: Index value '" + index + "' not in range [0.." + (this._historyEntryList.size() - 1) + "]");
        }
        this._historyEntryList.set(index, vHistoryEntry);
    }

    @Override
    public void setMarkedForDelete(boolean markedForDelete) {
        this._markedForDelete = markedForDelete;
        this._has_markedForDelete = true;
    }

    public void setMetaDataEntries(MetaDataType[] vMetaDataEntryArray) {
        this._metaDataEntryList.clear();
        for (int i = 0; i < vMetaDataEntryArray.length; ++i) {
            this._metaDataEntryList.add(vMetaDataEntryArray[i]);
        }
    }

    public void setMetaDataEntries(List vMetaDataEntryList) {
        this._metaDataEntryList.clear();
        this._metaDataEntryList.addAll(vMetaDataEntryList);
    }

    public void setMetaDataEntriesAsReference(List metaDataEntryList) {
        this._metaDataEntryList = metaDataEntryList;
    }

    public void setMetaDataEntry(int index, MetaDataType vMetaDataEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._metaDataEntryList.size()) {
            throw new IndexOutOfBoundsException("setMetaDataEntry: Index value '" + index + "' not in range [0.." + (this._metaDataEntryList.size() - 1) + "]");
        }
        this._metaDataEntryList.set(index, vMetaDataEntry);
    }

    public void setModifiedBy(UserRefType modifiedBy) {
        this._modifiedBy = modifiedBy;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public void setMultiTenant(boolean multiTenant) {
        this._multiTenant = multiTenant;
        this._has_multiTenant = true;
    }

    public void setOriginalSubject(String originalSubject) {
        this._originalSubject = originalSubject;
    }

    public void setResponseCount(int responseCount) {
        this._responseCount = responseCount;
        this._has_responseCount = true;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public void setTenantID(String tenantID) {
        this._tenantID = tenantID;
    }

    public void setThumbprint(byte[] thumbprint) {
        this._thumbprint = thumbprint;
    }

    public static ReferenceableObjectType unmarshalDocumentBaseType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(DocumentBaseType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

