/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.CategoryRefType;
import net.gopro.gdf.data.ClientBaseType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ClientUnitBaseType
extends ClientBaseType
implements Serializable {
    private List _addressList = new ArrayList();
    private String _webPage;
    private List _NACEList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addAddress(AddressType vAddress) throws IndexOutOfBoundsException {
        this._addressList.add(vAddress);
    }

    public void addAddress(int index, AddressType vAddress) throws IndexOutOfBoundsException {
        this._addressList.add(index, vAddress);
    }

    public void addNACE(CategoryRefType vNACE) throws IndexOutOfBoundsException {
        this._NACEList.add(vNACE);
    }

    public void addNACE(int index, CategoryRefType vNACE) throws IndexOutOfBoundsException {
        this._NACEList.add(index, vNACE);
    }

    public Enumeration enumerateAddresses() {
        return Collections.enumeration(this._addressList);
    }

    public Enumeration enumerateNACEs() {
        return Collections.enumeration(this._NACEList);
    }

    public AddressType getAddress(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._addressList.size()) {
            throw new IndexOutOfBoundsException("getAddress: Index value '" + index + "' not in range [0.." + (this._addressList.size() - 1) + "]");
        }
        return (AddressType)this._addressList.get(index);
    }

    public AddressType[] getAddresses() {
        AddressType[] array = new AddressType[]{};
        return this._addressList.toArray(array);
    }

    public List getAddressesAsReference() {
        return this._addressList;
    }

    public int getAddressesCount() {
        return this._addressList.size();
    }

    public CategoryRefType getNACE(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._NACEList.size()) {
            throw new IndexOutOfBoundsException("getNACE: Index value '" + index + "' not in range [0.." + (this._NACEList.size() - 1) + "]");
        }
        return (CategoryRefType)this._NACEList.get(index);
    }

    public CategoryRefType[] getNACEs() {
        CategoryRefType[] array = new CategoryRefType[]{};
        return this._NACEList.toArray(array);
    }

    public List getNACEsAsReference() {
        return this._NACEList;
    }

    public int getNACEsCount() {
        return this._NACEList.size();
    }

    public String getWebPage() {
        return this._webPage;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAddresses() {
        return this._addressList.iterator();
    }

    public Iterator iterateNACEs() {
        return this._NACEList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeAddress(AddressType vAddress) {
        boolean removed = this._addressList.remove(vAddress);
        return removed;
    }

    public AddressType removeAddressAt(int index) {
        Object obj = this._addressList.remove(index);
        return (AddressType)obj;
    }

    public void removeAllAddresses() {
        this._addressList.clear();
    }

    public void removeAllNACEs() {
        this._NACEList.clear();
    }

    public boolean removeNACE(CategoryRefType vNACE) {
        boolean removed = this._NACEList.remove(vNACE);
        return removed;
    }

    public CategoryRefType removeNACEAt(int index) {
        Object obj = this._NACEList.remove(index);
        return (CategoryRefType)obj;
    }

    public void setAddress(int index, AddressType vAddress) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._addressList.size()) {
            throw new IndexOutOfBoundsException("setAddress: Index value '" + index + "' not in range [0.." + (this._addressList.size() - 1) + "]");
        }
        this._addressList.set(index, vAddress);
    }

    public void setAddresses(AddressType[] vAddressArray) {
        this._addressList.clear();
        for (int i = 0; i < vAddressArray.length; ++i) {
            this._addressList.add(vAddressArray[i]);
        }
    }

    public void setAddresses(List vAddressList) {
        this._addressList.clear();
        this._addressList.addAll(vAddressList);
    }

    public void setAddressesAsReference(List addressList) {
        this._addressList = addressList;
    }

    public void setNACE(int index, CategoryRefType vNACE) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._NACEList.size()) {
            throw new IndexOutOfBoundsException("setNACE: Index value '" + index + "' not in range [0.." + (this._NACEList.size() - 1) + "]");
        }
        this._NACEList.set(index, vNACE);
    }

    public void setNACEs(CategoryRefType[] vNACEArray) {
        this._NACEList.clear();
        for (int i = 0; i < vNACEArray.length; ++i) {
            this._NACEList.add(vNACEArray[i]);
        }
    }

    public void setNACEs(List vNACEList) {
        this._NACEList.clear();
        this._NACEList.addAll(vNACEList);
    }

    public void setNACEsAsReference(List NACEList) {
        this._NACEList = NACEList;
    }

    public void setWebPage(String webPage) {
        this._webPage = webPage;
    }

    public static ReferenceableObjectType unmarshalClientUnitBaseType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(ClientUnitBaseType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

