/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.types.FilterOperatorType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class BinaryFilterExpressionType
extends FilterExpressionType
implements Serializable {
    private String _propertyName;
    private FilterOperatorType _operator;
    private boolean _negative;
    private boolean _has_negative;
    private Object _value;
    private List _inValueList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addInValue(Object vInValue) throws IndexOutOfBoundsException {
        this._inValueList.add(vInValue);
    }

    public void addInValue(int index, Object vInValue) throws IndexOutOfBoundsException {
        this._inValueList.add(index, vInValue);
    }

    public void deleteNegative() {
        this._has_negative = false;
    }

    public Enumeration enumerateInValues() {
        return Collections.enumeration(this._inValueList);
    }

    public Object getInValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._inValueList.size()) {
            throw new IndexOutOfBoundsException("getInValue: Index value '" + index + "' not in range [0.." + (this._inValueList.size() - 1) + "]");
        }
        return this._inValueList.get(index);
    }

    public Object[] getInValues() {
        Object[] array = new Object[]{};
        return this._inValueList.toArray(array);
    }

    public List getInValuesAsReference() {
        return this._inValueList;
    }

    public int getInValuesCount() {
        return this._inValueList.size();
    }

    public boolean getNegative() {
        return this._negative;
    }

    public FilterOperatorType getOperator() {
        return this._operator;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Object getValue() {
        return this._value;
    }

    public boolean hasNegative() {
        return this._has_negative;
    }

    public boolean isNegative() {
        return this._negative;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateInValues() {
        return this._inValueList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllInValues() {
        this._inValueList.clear();
    }

    public boolean removeInValue(Object vInValue) {
        boolean removed = this._inValueList.remove(vInValue);
        return removed;
    }

    public Object removeInValueAt(int index) {
        Object obj = this._inValueList.remove(index);
        return obj;
    }

    public void setInValue(int index, Object vInValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._inValueList.size()) {
            throw new IndexOutOfBoundsException("setInValue: Index value '" + index + "' not in range [0.." + (this._inValueList.size() - 1) + "]");
        }
        this._inValueList.set(index, vInValue);
    }

    public void setInValues(Object[] vInValueArray) {
        this._inValueList.clear();
        for (int i = 0; i < vInValueArray.length; ++i) {
            this._inValueList.add(vInValueArray[i]);
        }
    }

    public void setInValues(List vInValueList) {
        this._inValueList.clear();
        this._inValueList.addAll(vInValueList);
    }

    public void setInValuesAsReference(List inValueList) {
        this._inValueList = inValueList;
    }

    public void setNegative(boolean negative) {
        this._negative = negative;
        this._has_negative = true;
    }

    public void setOperator(FilterOperatorType operator) {
        this._operator = operator;
    }

    public void setPropertyName(String propertyName) {
        this._propertyName = propertyName;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public static FilterExpressionType unmarshalBinaryFilterExpressionType(Reader reader) throws MarshalException, ValidationException {
        return (FilterExpressionType)Unmarshaller.unmarshal(BinaryFilterExpressionType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

