/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.constants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.gopro.gdf.exceptions.GdfServiceRuntimeException;

public class DataLoadingOptions {
    private int value = 0;
    public static final DataLoadingOptions DEFAULT = new DataLoadingOptions(0);
    public static final List<DataLoadingOptions> DEFAULT_AS_LIST = Collections.unmodifiableList(DataLoadingOptions.getListFromOption(DEFAULT));
    public static final DataLoadingOptions COMPREHENSIVE_MULTIVALUE_LOAD = new DataLoadingOptions(1);
    public static final DataLoadingOptions DISABLE_CONTAINMENT_LOADING = new DataLoadingOptions(2);
    public static final DataLoadingOptions OLD_VERSIONS_LOADING = new DataLoadingOptions(4);
    public static final DataLoadingOptions ENABLE_FTSEARCH = new DataLoadingOptions(8);
    public static final DataLoadingOptions ENABLE_RESULT_INDEX_CACHE = new DataLoadingOptions(16);
    public static final DataLoadingOptions FORCE_RESULT_INDEX_CACHE_INVALIDATION = new DataLoadingOptions(32);
    public static final DataLoadingOptions NEWER_VERSIONS_LOADING = new DataLoadingOptions(64);
    public static final DataLoadingOptions DISABLE_ATTACHMENT_LOADING = new DataLoadingOptions(128);
    public static final DataLoadingOptions DISABLE_HISTORY_LOADING = new DataLoadingOptions(256);
    public static final DataLoadingOptions DISABLE_ACL_LOADING = new DataLoadingOptions(512);
    public static final DataLoadingOptions DISABLE_METADATA_LOADING = new DataLoadingOptions(1024);
    public static final DataLoadingOptions DISABLE_RESULTS_COUNTING = new DataLoadingOptions(2048);
    public static final DataLoadingOptions LOAD_ONLY_REQUESTED_COLUMNS = new DataLoadingOptions(4096);
    public static final DataLoadingOptions DISABLE_TASK_LOADING = new DataLoadingOptions(8192);
    public static final List<DataLoadingOptions> LOAD_ONLY_REQUESTED_COLUMNS_AS_LIST = Collections.unmodifiableList(DataLoadingOptions.getDataLoadingOptionsFromBitMask(LOAD_ONLY_REQUESTED_COLUMNS.getValue()));
    public static final DataLoadingOptions PERFORM_DELAYED_COUNTING = new DataLoadingOptions(8192);
    public static final DataLoadingOptions PERFORM_LIMITED_COUNTING = new DataLoadingOptions(16384);
    public static final DataLoadingOptions LOAD_MULTI_REFS_WITHOUT_JOIN = new DataLoadingOptions(32768);
    public static final DataLoadingOptions USER_CURRENT_ACCESS_TO_DOCUMENTS_AND_CHILDREN = new DataLoadingOptions(131072);
    public static final DataLoadingOptions ANNOUNCE_BASE_FILTER_ALTERED = new DataLoadingOptions(16);
    public static final DataLoadingOptions LOAD_ONLY_RECENT_DESTINATIONS = new DataLoadingOptions(17);
    public static final DataLoadingOptions DISABLE_FULL_DOCUMENT_LOADING = new DataLoadingOptions(DISABLE_ATTACHMENT_LOADING.getValue() | DISABLE_HISTORY_LOADING.getValue() | DISABLE_ACL_LOADING.getValue() | DISABLE_METADATA_LOADING.getValue());
    public static final List<DataLoadingOptions> DISABLE_FULL_DOCUMENT_LOADING_AS_LIST = Collections.unmodifiableList(DataLoadingOptions.getDataLoadingOptionsFromBitMask(DISABLE_FULL_DOCUMENT_LOADING.getValue()));
    public static final DataLoadingOptions LOAD_ONLY_METADATA = new DataLoadingOptions(DISABLE_ATTACHMENT_LOADING.getValue() | DISABLE_HISTORY_LOADING.getValue() | DISABLE_ACL_LOADING.getValue());
    public static final DataLoadingOptions LOAD_ONLY_ACL = new DataLoadingOptions(DISABLE_ATTACHMENT_LOADING.getValue() | DISABLE_HISTORY_LOADING.getValue() | DISABLE_METADATA_LOADING.getValue());
    public static final List<DataLoadingOptions> LOAD_ONLY_METADATA_AS_LIST = Collections.unmodifiableList(DataLoadingOptions.getDataLoadingOptionsFromBitMask(LOAD_ONLY_METADATA.getValue()));
    public static final DataLoadingOptions LOAD_ACL_AND_METADATA = new DataLoadingOptions(DISABLE_ATTACHMENT_LOADING.getValue() | DISABLE_HISTORY_LOADING.getValue());
    public static final List<DataLoadingOptions> LOAD_ACL_AND_METADATA_AS_LIST = Collections.unmodifiableList(DataLoadingOptions.getDataLoadingOptionsFromBitMask(LOAD_ACL_AND_METADATA.getValue()));

    protected DataLoadingOptions(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public List<DataLoadingOptions> toOptionsList() {
        return DataLoadingOptions.getDataLoadingOptionsFromBitMask(this.getValue());
    }

    public static List<DataLoadingOptions> getDataLoadingOptionsFromBitMask(int mask) {
        ArrayList<DataLoadingOptions> result = new ArrayList<DataLoadingOptions>();
        int tmp = mask;
        if (mask == 0) {
            return new ArrayList<DataLoadingOptions>(DEFAULT_AS_LIST);
        }
        if (mask % 2 == 1) {
            result.add(new DataLoadingOptions(1));
            --tmp;
        }
        int i = 0;
        do {
            int power;
            int twoPowerX;
            if ((twoPowerX = (int)Math.pow(2.0, power = ++i)) > tmp) {
                int foundInt = (int)Math.pow(2.0, power - 1);
                tmp -= foundInt;
                result.add(new DataLoadingOptions(foundInt));
                i = 0;
            }
            if (tmp != twoPowerX) continue;
            tmp -= twoPowerX;
            result.add(new DataLoadingOptions(twoPowerX));
        } while (tmp > 0);
        return result;
    }

    public static int getBitMaskFromDataLoadingOptions(List<DataLoadingOptions> dataLoadingOptions) {
        if (dataLoadingOptions == null || dataLoadingOptions.size() < 1) {
            throw new GdfServiceRuntimeException("No Data Loading Options set!");
        }
        int result = 0;
        for (DataLoadingOptions o : dataLoadingOptions) {
            if (!(o instanceof DataLoadingOptions)) {
                throw new GdfServiceRuntimeException("Object is not instance of DataLoadinOptions!");
            }
            result |= o.getValue();
        }
        return result;
    }

    private static List<DataLoadingOptions> getListFromOption(DataLoadingOptions option) {
        ArrayList<DataLoadingOptions> list = new ArrayList<DataLoadingOptions>();
        list.add(option);
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataLoadingOptions other = (DataLoadingOptions)obj;
        return this.value == other.value;
    }
}

