/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.codegenerators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.gopro.codegenerators.BaseGenerator;
import net.gopro.util.annotations.GoProAnnotationHelper;
import net.gopro.util.annotations.GoProAnnotationInfo;
import net.gopro.util.annotations.GoProTypeIndexAnnotation;

public class DocumentTypeMappingsGenerator
extends BaseGenerator {
    private static final String DOC_TYPE_PREFIX = "DOC_TYPE_";
    private static final String ENTITY_TYPE_PREFIX = "ENTITY_TYPE_";
    private String dataObjectsPack;
    private String baseEntityClass;
    private String baseDocClass;
    private String outputDir;
    private String listClassTemplate;
    private String listOutputClass;
    private String mapClassTemplate;
    private String mapOutputClass;
    private String unzippedGDFProject;
    private String typesListClassName;
    private StringBuffer generatedListCode = new StringBuffer();
    private StringBuffer generatedMapCode = new StringBuffer();
    private int docTypeIndex = 1;

    public static void main(String[] args) {
        try {
            DocumentTypeMappingsGenerator generator = new DocumentTypeMappingsGenerator(args);
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DocumentTypeMappingsGenerator(String[] args) throws Exception {
        super(args);
    }

    public void generate() throws Exception {
        this.dataObjectsPack = this.getParameter("dataObjectsPack", null);
        this.baseEntityClass = this.getParameter("baseEntityClass", null);
        this.baseDocClass = this.getParameter("baseDocClass", null);
        this.outputDir = this.getParameter("outputDir", null);
        this.listClassTemplate = this.getParameter("listClassTemplate", null);
        this.listOutputClass = this.getParameter("listOutputClass", null);
        this.mapClassTemplate = this.getParameter("mapClassTemplate", null);
        this.mapOutputClass = this.getParameter("mapOutputClass", null);
        this.unzippedGDFProject = this.getParameter("unzippedGDFProject", null);
        this.typesListClassName = this.getClassBaseName(this.listOutputClass);
        this.generateTypesCode();
        this.generateTypesListFile();
        this.generateTypesMapFile();
    }

    private void generateTypesListFile() throws Exception {
        HashMap<String, String> subParams = new HashMap<String, String>();
        String outputFilePath = this.outputDir + "/" + this.convertClassNameToPath(this.listOutputClass) + ".java";
        String packageName = this.getPackageByClassName(this.listOutputClass);
        String classBaseName = this.getClassBaseName(this.listOutputClass);
        this.ensureDirCreated(outputFilePath);
        StringBuffer outputBuffer = this.readFile(new File(this.listClassTemplate));
        subParams.putAll(this.generatorParams);
        subParams.put("package", packageName);
        subParams.put("classBaseName", classBaseName);
        this.substituteContentParams(outputBuffer, subParams);
        this.replaceInContent(outputBuffer, this.generatedListCode, "/*--BEGIN:GOPRO_GENERATED--*/", "/*--END:GOPRO_GENERATED--*/");
        this.writeCode(new File(outputFilePath), outputBuffer);
    }

    private void generateTypesMapFile() throws Exception {
        HashMap<String, String> subParams = new HashMap<String, String>();
        String outputFilePath = this.outputDir + "/" + this.convertClassNameToPath(this.mapOutputClass) + ".java";
        String packageName = this.getPackageByClassName(this.mapOutputClass);
        String classBaseName = this.getClassBaseName(this.mapOutputClass);
        this.ensureDirCreated(outputFilePath);
        StringBuffer outputBuffer = this.readFile(new File(this.mapClassTemplate));
        subParams.putAll(this.generatorParams);
        subParams.put("package", packageName);
        subParams.put("classBaseName", classBaseName);
        this.substituteContentParams(outputBuffer, subParams);
        this.replaceInContent(outputBuffer, this.generatedMapCode, "/*--BEGIN:GOPRO_GENERATED--*/", "/*--END:GOPRO_GENERATED--*/");
        this.writeCode(new File(outputFilePath), outputBuffer);
    }

    private void generateTypesCode() throws Exception {
        Class<?> baseDocumentClass = Class.forName(this.baseDocClass);
        Class<?> baseEntityClass = Class.forName(this.baseEntityClass);
        File classesDir = new File(this.unzippedGDFProject);
        boolean located = false;
        int maxTypeIndex = 0;
        if (classesDir.exists()) {
            located = true;
            ArrayList<File> resultFiles = new ArrayList<File>();
            String fullPath = this.dataObjectsPack.replace(".", "/");
            this.getFiles(resultFiles, classesDir.listFiles(), fullPath);
            if (resultFiles.size() > 0) {
                File[] files = ((File)resultFiles.get(0)).listFiles();
                for (int ac = 0; ac < files.length; ++ac) {
                    String fileName = files[ac].getName();
                    int typeIndex = -1;
                    if (!fileName.endsWith("Type.class")) continue;
                    try {
                        Class<?> dataClass = Class.forName(this.dataObjectsPack + '.' + fileName.substring(0, fileName.length() - 6));
                        if (baseDocumentClass.isAssignableFrom(dataClass)) {
                            typeIndex = this.generateTypeEntry(dataClass, false);
                        } else if (baseEntityClass.isAssignableFrom(dataClass)) {
                            this.generateTypeEntry(dataClass, true);
                        }
                        if (typeIndex <= maxTypeIndex) continue;
                        maxTypeIndex = typeIndex;
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println(this.getClass().getSimpleName() + ": Cannot find class: " + this.dataObjectsPack + '.' + fileName.substring(0, fileName.length() - 6));
                    }
                }
            }
            System.out.println("--- NEXT AVAILABLE TYPE INDEX IS: " + (maxTypeIndex + 1));
        }
        if (!located) {
            throw new ClassNotFoundException(this.dataObjectsPack + " (" + classesDir.getPath() + ") is not a valid package");
        }
    }

    private int generateTypeEntry(Class docClass, boolean entity) {
        String[] classMappings;
        String typePrefix = entity ? ENTITY_TYPE_PREFIX : DOC_TYPE_PREFIX;
        String strippedName = docClass.getName();
        strippedName = strippedName.substring(strippedName.lastIndexOf(46) + 1);
        strippedName = strippedName.substring(0, strippedName.length() - 4);
        String strippedNameLower = strippedName.toLowerCase();
        String genName = "";
        boolean lastUpCase = true;
        for (int ac = 0; ac < strippedName.length(); ++ac) {
            boolean upCase;
            char src = strippedName.charAt(ac);
            char low = strippedNameLower.charAt(ac);
            boolean nextChar = false;
            boolean bl = upCase = src < low;
            if (upCase != lastUpCase && upCase) {
                genName = genName + "_";
            }
            lastUpCase = upCase;
            genName = genName + src;
        }
        GoProAnnotationInfo goProAnotationInfo = GoProAnnotationHelper.getAnnotationInfo(docClass);
        GoProTypeIndexAnnotation gpTypeIndexAnnotation = (GoProTypeIndexAnnotation)goProAnotationInfo.getClassAnnotations(GoProTypeIndexAnnotation.class);
        int typeIndex = this.docTypeIndex++;
        if (gpTypeIndexAnnotation != null) {
            typeIndex = gpTypeIndexAnnotation.getTypeIndex();
        } else if (!entity) {
            throw new RuntimeException("The typeindex missing in " + strippedName + "Type");
        }
        genName = (typePrefix + genName).toUpperCase();
        String genListSrc = "  public static final int " + genName + " = ";
        genListSrc = genListSrc + (entity && gpTypeIndexAnnotation == null ? " ENTITY_TYPE_BASE + " : "");
        genListSrc = genListSrc + typeIndex + ";\n\n";
        this.generatedListCode.append(genListSrc);
        for (String classMapping : classMappings = new String[]{docClass.getName(), docClass.getSimpleName(), docClass.getName().toLowerCase(), docClass.getSimpleName().toLowerCase()}) {
            this.generatedMapCode.append("       addMapping(" + this.quote(classMapping) + ",String.valueOf(" + this.typesListClassName + "." + genName + "), true, true);\n");
        }
        this.generatedMapCode.append("\r\n");
        return typeIndex;
    }
}

