/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.codegenerators;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.gopro.util.Utils;

public class BaseGenerator {
    protected HashMap generatorParams;
    protected static final String GoProGenMark = "/* Auto-generated by GoPro */\n";
    protected static final String GenSrcBegin = "/*--BEGIN:GOPRO_GENERATED--*/";
    protected static final String GenSrcEnd = "/*--END:GOPRO_GENERATED--*/";

    protected BaseGenerator() {
        this.generatorParams = new HashMap();
        this.generatorParams.put("generatorName", this.getClassBaseName(this.getClass().getName()));
    }

    protected BaseGenerator(String[] args) throws Exception {
        this.generatorParams = this.parseArgs(args);
        this.generatorParams.put("generatorName", this.getClassBaseName(this.getClass().getName()));
    }

    protected HashMap parseArgs(String[] args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String paramName = null;
        for (int ac = 0; ac < args.length; ++ac) {
            String arg = args[ac];
            if (arg.startsWith("-")) {
                paramName = arg.substring(1);
                continue;
            }
            if (paramName == null) {
                throw new Exception("Cannot accept param value without param name...\n format: app -paramName paramValue ParamValue...");
            }
            Object paramValue = map.get(paramName);
            if (paramValue == null) {
                map.put(paramName, arg);
                continue;
            }
            if (paramValue instanceof List) {
                ((List)paramValue).add(arg);
                continue;
            }
            ArrayList<Object> listParamValue = new ArrayList<Object>();
            listParamValue.add(paramValue);
            listParamValue.add(arg);
            map.put(paramName, listParamValue);
        }
        return map;
    }

    protected String getParameter(String paramName, String fallback) throws Exception {
        Object paramValueObj = this.generatorParams.get(paramName);
        String paramValue = null;
        if (paramValueObj instanceof ArrayList) {
            ArrayList paramValueList = (ArrayList)paramValueObj;
            paramValue = Utils.join(paramValueList.toArray(new String[paramValueList.size()]), " ");
            System.out.println("List param [" + paramName + "]: " + paramValue);
        } else if (paramValueObj instanceof String) {
            paramValue = (String)paramValueObj;
        } else {
            throw new Exception("Unrecognized param value [" + paramName + "]: " + paramValueObj.getClass().getName());
        }
        if (paramValue == null) {
            if (fallback == null) {
                throw new Exception("Parameter '" + paramName + "' is needed");
            }
            paramValue = fallback;
        }
        System.out.println("Parameter " + paramName + ": " + paramValue);
        return paramValue;
    }

    protected String getPackageByClassName(String className) {
        return className.substring(0, className.lastIndexOf(46));
    }

    protected String getClassBaseName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    protected String convertClassNameToPath(String className) {
        return className.replace('.', '/');
    }

    protected void ensureDirCreated(String filePath) throws Exception {
        String dirPath = filePath.substring(0, filePath.lastIndexOf(47) + 1);
        File file = new File(dirPath);
        if (file.exists()) {
            return;
        }
        file.mkdirs();
    }

    public static final void writeStream(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[8192];
        int count = in.read(b);
        while (count > 0) {
            out.write(b, 0, count);
            count = in.read(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCode(File javaFile, StringBuffer genCode) throws Exception {
        javaFile.createNewFile();
        try (FileWriter fileWriter = new FileWriter(javaFile);){
            StringReader fileContentReader = new StringReader(genCode.toString());
            BaseGenerator.writeStream(fileContentReader, fileWriter);
        }
    }

    public static final void writeStream(Reader in, Writer out) throws IOException {
        char[] c = new char[8192];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    public static final void writeString(String s, Writer out) throws IOException {
        StringReader in = new StringReader(s);
        char[] c = new char[8192];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer readFile(File javaFile) throws Exception {
        StringWriter srcContentWriter = new StringWriter();
        try (FileReader fileReader = new FileReader(javaFile);){
            StringBuffer contentBuffer;
            BaseGenerator.writeStream(fileReader, srcContentWriter);
            StringBuffer stringBuffer = contentBuffer = srcContentWriter.getBuffer();
            return stringBuffer;
        }
    }

    protected void substituteContentParams(StringBuffer content, HashMap params) throws Exception {
        int paramStart;
        int paramEnd = 0;
        do {
            if ((paramStart = content.indexOf("${", paramEnd)) < 0) continue;
            paramEnd = content.indexOf("}", paramStart);
            if (paramEnd < 0) {
                String contentCut = content.substring(paramStart, paramStart + 10 < content.length() ? paramStart + 10 : content.length());
                throw new Exception("Cannot found closing bracket '}' after " + contentCut);
            }
            String paramName = content.substring(paramStart + 2, paramEnd);
            String paramValue = (String)params.get(paramName);
            if (paramValue == null) {
                throw new Exception("Cannot found defined value  for '" + paramName + "'");
            }
            content.replace(paramStart, paramEnd + 1, paramValue);
            paramEnd = paramStart + paramValue.length();
        } while (paramStart >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceInFile(File file, StringBuffer genCode, String beginMark, String endMark) throws Exception {
        StringWriter srcContentWriter = new StringWriter();
        try (FileReader fileReader = new FileReader(file);){
            BaseGenerator.writeStream(fileReader, srcContentWriter);
            StringBuffer contentBuffer = srcContentWriter.getBuffer();
            fileReader.close();
            this.replaceInContent(contentBuffer, genCode, beginMark, endMark);
            try (FileWriter fileWriter = new FileWriter(file);){
                StringReader fileContentReader = new StringReader(contentBuffer.toString());
                BaseGenerator.writeStream(fileContentReader, fileWriter);
            }
        }
    }

    protected void replaceInContent(StringBuffer contentBuffer, StringBuffer genCode, String beginMark, String endMark) throws Exception {
        int begin = contentBuffer.indexOf(beginMark);
        int end = contentBuffer.indexOf(endMark);
        if (begin < 0 || end <= 0) {
            throw new Exception("Failed to find begin,end marks (" + beginMark + "," + endMark + ") ");
        }
        contentBuffer.replace(begin, end += endMark.length(), genCode.toString());
    }

    protected List collectClassesForPack(String basePath, String packageName, String fileExt, Class limitByRootClass) throws Exception {
        File classesDir = new File(basePath + "/" + this.convertClassNameToPath(packageName));
        ArrayList classes = new ArrayList();
        if (classesDir.exists()) {
            String[] files = classesDir.list();
            for (int ac = 0; ac < files.length; ++ac) {
                Class<?> dataClass;
                String fileName = files[ac];
                if (!fileName.endsWith("Type." + fileExt) || !limitByRootClass.isAssignableFrom(dataClass = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - fileExt.length() - 1)))) continue;
                classes.add(dataClass);
            }
        } else {
            throw new ClassNotFoundException(packageName + " (" + classesDir.getPath() + ") is not a valid package");
        }
        return classes;
    }

    protected String quote(String value) {
        return "\"" + value + "\"";
    }

    protected void getFiles(List<File> resultFiles, File[] classesDir, String fullPath) {
        if (resultFiles.size() == 0) {
            for (File currentFile : classesDir) {
                String currentPaht = currentFile.getAbsolutePath().replace('\\', '/');
                if (currentFile.isDirectory() && currentPaht.contains(fullPath)) {
                    resultFiles.add(currentFile);
                    continue;
                }
                if (!currentFile.isDirectory()) continue;
                this.getFiles(resultFiles, currentFile.listFiles(), fullPath);
            }
        }
    }
}

