/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.api.parser.WSDLExtensionHandler;
import org.jvnet.wom.impl.WSDLBoundOperationImpl;
import org.jvnet.wom.impl.WSDLBoundPortTypeImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.BoundOperation;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BoundPortType
extends AbstractHandler {
    private WSDLBoundPortTypeImpl boundPortType;
    private WSDLContentHandlerEx runtime;
    private String expectedNamespace;
    List<WSDLExtensionHandler> handlers = new ArrayList<WSDLExtensionHandler>();

    public BoundPortType(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNamespace = expectedNamespace;
    }

    protected BoundPortType(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
        if (cookie == 71) {
            WSDLBoundOperationImpl operation = (WSDLBoundOperationImpl)result;
            operation.setOwner(this.boundPortType);
            this.boundPortType.addBoundOperation(operation);
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("binding")) {
            this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
            Attributes test = this.runtime.getCurrentAttributes();
            this.processAttributes(test);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("operation")) {
            BoundOperation boundOperation = new BoundOperation(this, this._source, this.runtime, 71, this.expectedNamespace);
            this.spawnChildFromEnterElement(boundOperation, uri, localName, qname, atts);
        } else {
            super.enterElement(uri, localName, qname, atts);
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("binding")) {
            this.endProcessingExtentionElement(this.boundPortType);
            this.revertToParentFromLeaveElement(this.boundPortType, this._cookie, uri, localName, qname);
            this.boundPortType.setDocumentation(this.getWSDLDocumentation());
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int index;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:binding", name), this.runtime.getLocator()));
        }
        if ((index = test.getIndex("name")) >= 0) {
            validattrs[index] = 1;
        }
        this.boundPortType = new WSDLBoundPortTypeImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        index = test.getIndex("type");
        if (index >= 0) {
            validattrs[index] = 1;
            String qname = test.getValue(index);
            String uri = this.runtime.resolveNamespacePrefix(XmlUtil.getPrefix(qname));
            String localname = XmlUtil.getLocalPart(qname);
            QName portTypeName = new QName(uri, localname);
            if (uri == null || localname == null) {
                this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.invalidPortTypeDescriptor", qname, name), this.runtime.getLocator()));
            }
            this.boundPortType.setPortType(portTypeName);
        }
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }
}

