/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.parser.WSDLExtensionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWSDLExtensionHandler
implements WSDLExtensionHandler {
    protected final ErrorHandler errorHandler;
    protected final EntityResolver entityResolver;
    private final Set<WSDLExtension> EMPTY_SET = new HashSet<WSDLExtension>();

    protected AbstractWSDLExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        this.errorHandler = errorHandler;
        this.entityResolver = entityResolver;
    }

    @Override
    public Collection<WSDLExtension> parseAttribute(Attributes atts) {
        return this.EMPTY_SET;
    }

    protected abstract QName[] getExtensionNames();

    protected boolean canHandle(String uri, String localName) {
        for (QName name : this.getExtensionNames()) {
            if (!name.getNamespaceURI().equals(uri) || !name.getLocalPart().equals(localName)) continue;
            return true;
        }
        return false;
    }

    protected abstract class WSDLExtensibilityContentHandler
    implements ContentHandler {
        protected Locator locator;
        List<String> namespaces = new ArrayList<String>();

        protected WSDLExtensibilityContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.namespaces.add(prefix);
            this.namespaces.add(uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.namespaces.remove(this.namespaces.size() - 1);
            this.namespaces.remove(this.namespaces.size() - 1);
        }

        public String resolveNamespacePrefix(String prefix) {
            for (int i = this.namespaces.size() - 2; i >= 0; i -= 2) {
                if (!this.namespaces.get(i).equals(prefix)) continue;
                return this.namespaces.get(i + 1);
            }
            if (prefix.equals("")) {
                return "";
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

