/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultNonceManager;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URL;

public abstract class NonceManager {
    public static final String nonceManager = "com.sun.xml.xwss.NonceManager";
    private static NonceManager nonceMgr = null;
    private long maxNonceAge;

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public abstract boolean validateNonce(String var1, String var2) throws NonceException;

    public static synchronized NonceManager getInstance(long maxNonceAge) {
        if (nonceMgr != null) {
            return nonceMgr;
        }
        URL url = SecurityUtil.loadFromClasspath("/META-INF/services/com.sun.xml.xwss.NonceManager");
        if (url != null) {
            Object obj = SecurityUtil.loadSPIClass(url, nonceManager);
            if (obj != null && !(obj instanceof NonceManager)) {
                throw new XWSSecurityRuntimeException("Class :" + obj.getClass().getName() + " is not a valid NonceManager");
            }
            nonceMgr = (NonceManager)obj;
        }
        if (nonceMgr != null) {
            nonceMgr.setMaxNonceAge(maxNonceAge);
            return nonceMgr;
        }
        nonceMgr = new DefaultNonceManager();
        nonceMgr.setMaxNonceAge(maxNonceAge);
        return nonceMgr;
    }

    public static class NonceException
    extends XWSSecurityException {
        public NonceException(String message) {
            super(message);
        }

        public NonceException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonceException(Throwable cause) {
            super(cause);
        }
    }
}

