/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.FiberResumeTask;
import com.sun.xml.ws.rx.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rx.rm.runtime.RequestResendTask;
import com.sun.xml.ws.rx.rm.runtime.Rm10ClientSession;
import com.sun.xml.ws.rx.rm.runtime.Rm11ClientSession;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.ScheduledTaskManager;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

abstract class ClientSession {
    private static final Logger LOGGER = Logger.getLogger(ClientSession.class);
    private static final int MAX_INITIATE_SESSION_ATTEMPTS = 3;
    String inboundSequenceId = null;
    String outboundSequenceId = null;
    final RxConfiguration configuration;
    final SequenceManager sequenceManager;
    final Communicator communicator;
    final WSEndpointReference rmSourceReference;
    private final Lock initLock;
    private final ScheduledTaskManager scheduledTaskManager;
    private final AtomicLong lastAckRequestedTime = new AtomicLong(0L);
    private final FiberResumeTask fiberResumeTask;
    private final RequestResendTask requestResendTask;

    static ClientSession create(RxConfiguration configuration, WSEndpointReference rmSourceReference, Communicator communicator) {
        switch (configuration.getRmVersion()) {
            case WSRM200502: {
                return new Rm10ClientSession(configuration, rmSourceReference, communicator);
            }
            case WSRM200702: {
                return new Rm11ClientSession(configuration, rmSourceReference, communicator);
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(configuration.getRmVersion().namespaceUri));
    }

    ClientSession(RxConfiguration configuration, WSEndpointReference rmsEndpointReference, Communicator communicator) {
        this.initLock = new ReentrantLock();
        this.configuration = configuration;
        this.rmSourceReference = rmsEndpointReference;
        this.sequenceManager = SequenceManagerFactory.INSTANCE.getClientSequenceManager(this.configuration.getManagedObjectManager());
        this.communicator = communicator;
        this.scheduledTaskManager = new ScheduledTaskManager();
        this.fiberResumeTask = new FiberResumeTask(this);
        this.requestResendTask = new RequestResendTask(communicator, this);
    }

    abstract void openRmSession(String var1, SecurityTokenReferenceType var2) throws RxRuntimeException;

    abstract void closeOutboundSequence() throws RxException;

    abstract void terminateOutboundSequence() throws RxException;

    final void processInboundMessageHeaders(PacketAdapter responseAdapter, boolean expectSequenceHeader) throws RxRuntimeException {
        String ackRequestedSequenceId;
        if (expectSequenceHeader) {
            String sequenceId = responseAdapter.getSequenceId();
            if (sequenceId != null) {
                Utilities.assertSequenceId(this.inboundSequenceId, sequenceId);
                this.sequenceManager.getSequence(sequenceId).acknowledgeMessageId(responseAdapter.getMessageNumber());
            } else {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1118_MANDATORY_HEADER_NOT_PRESENT("wsrm:Sequence"));
            }
        }
        if ((ackRequestedSequenceId = responseAdapter.getAckRequestedHeaderSequenceId()) != null) {
            Utilities.assertSequenceId(this.inboundSequenceId, ackRequestedSequenceId);
            this.sequenceManager.getSequence(ackRequestedSequenceId).setAckRequestedFlag();
        }
        responseAdapter.processAcknowledgements(this.sequenceManager, this.outboundSequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void requestAcknowledgement() throws RxException {
        PacketAdapter responseAdapter = null;
        try {
            PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket(false));
            requestAdapter.setEmptyRequestMessage(this.configuration.getRmVersion().ackRequestedAction).appendAckRequestedHeader(this.outboundSequenceId);
            responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()));
            if (!responseAdapter.containsMessage()) {
                throw new RxException(LocalizationMessages.WSRM_1108_NULL_RESPONSE_FOR_ACK_REQUEST());
            }
            this.processInboundMessageHeaders(responseAdapter, false);
            if (responseAdapter.isFault()) {
                throw new RxException(LocalizationMessages.WSRM_1109_SOAP_FAULT_RESPONSE_FOR_ACK_REQUEST());
            }
        }
        finally {
            if (responseAdapter != null) {
                responseAdapter.consume();
            }
        }
    }

    final Packet registerOutgoingRequest(Packet requestPacket) {
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, requestPacket);
        this.initializeIfNecessary(requestAdapter);
        requestAdapter.appendSequenceHeader(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).generateNextMessageId());
        return requestAdapter.getPacket();
    }

    final Packet appendOutgoingAcknowledgementHeaders(Packet requestPacket) throws RxRuntimeException {
        Sequence inboundSequence;
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, requestPacket);
        if (this.sequenceManager.getSequence(this.outboundSequenceId).hasPendingAcknowledgements()) {
            requestAdapter.appendAckRequestedHeader(this.outboundSequenceId);
            requestAdapter.setAckRequestdFlag();
            this.lastAckRequestedTime.set(System.currentTimeMillis());
        }
        if (this.inboundSequenceId != null && (inboundSequence = this.sequenceManager.getSequence(this.inboundSequenceId)).getLastMessageId() > 0L) {
            requestAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(this.inboundSequenceId));
        }
        return requestAdapter.getPacket();
    }

    final ProtocolMessageHandler getRmProtocolResponseHandler() {
        return new ProtocolMessageHandler(){
            Collection<String> SUPPORTED_WSA_ACTIONS;
            {
                this.SUPPORTED_WSA_ACTIONS = Collections.unmodifiableCollection(Arrays.asList(ClientSession.this.configuration.getRmVersion().ackRequestedAction, ClientSession.this.configuration.getRmVersion().sequenceAcknowledgementAction));
            }

            @Override
            public Collection<String> getSuportedWsaActions() {
                return this.SUPPORTED_WSA_ACTIONS;
            }

            @Override
            public void processProtocolMessage(Packet protocolMessagePacket) {
                PacketAdapter responseAdapter = PacketAdapter.getInstance(ClientSession.this.configuration, protocolMessagePacket);
                if (responseAdapter.isProtocolMessage()) {
                    LOGGER.finer("Processing RM protocol message.");
                    ClientSession.this.processInboundMessageHeaders(responseAdapter, false);
                } else {
                    LOGGER.severe("Unable to process packet - the packet was not identified as an RM protocol message");
                }
            }
        };
    }

    final Packet processIncommingPacket(Packet responsePacket, boolean responseToOneWayRequest) throws RxRuntimeException {
        PacketAdapter responseAdapter = PacketAdapter.getInstance(this.configuration, responsePacket);
        if (responseAdapter.containsMessage()) {
            this.processInboundMessageHeaders(responseAdapter, !responseToOneWayRequest && !responseAdapter.isProtocolMessage());
        }
        return responseAdapter.getPacket();
    }

    final boolean registerForResend(Fiber fiber, Packet request, int resendCounter) {
        return this.fiberResumeTask.register(fiber, request, this.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(resendCounter, this.configuration.getMessageRetransmissionInterval()));
    }

    final boolean registerForResend(Packet packet, int resendCounter) {
        return this.requestResendTask.register(packet, resendCounter, this.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(resendCounter, this.configuration.getMessageRetransmissionInterval()));
    }

    final boolean isRequestAcknowledged(Packet request) {
        return this.isRequestAcknowledged(PacketAdapter.getInstance(this.configuration, request));
    }

    final boolean isRequestAcknowledged(PacketAdapter request) {
        return this.sequenceManager.getSequence(this.outboundSequenceId).isAcknowledged(request.getMessageNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        try {
            if (this.outboundSequenceId != null && this.sequenceManager.isValid(this.outboundSequenceId)) {
                try {
                    this.closeOutboundSequence();
                }
                catch (RxException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
                finally {
                    try {
                        this.sequenceManager.closeSequence(this.outboundSequenceId);
                    }
                    catch (UnknownSequenceException ex) {
                        LOGGER.logException(ex, Level.WARNING);
                    }
                }
                try {
                    this.waitUntilAllRequestsAckedOrCloseOperationTimeout();
                    this.terminateOutboundSequence();
                }
                catch (RxException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
                finally {
                    try {
                        this.sequenceManager.terminateSequence(this.outboundSequenceId);
                    }
                    catch (UnknownSequenceException ex) {
                        LOGGER.logException(ex, Level.WARNING);
                    }
                }
            }
            if (this.inboundSequenceId != null && this.sequenceManager.isValid(this.inboundSequenceId)) {
                try {
                    if (!this.sequenceManager.getSequence(this.inboundSequenceId).isClosed()) {
                        this.sequenceManager.closeSequence(this.inboundSequenceId);
                    }
                    this.sequenceManager.terminateSequence(this.inboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
        }
        finally {
            this.scheduledTaskManager.stopAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(PacketAdapter request) throws RxRuntimeException {
        this.initLock.lock();
        try {
            if (!this.isInitialized()) {
                int numberOfInitiateSessionAttempts = 0;
                while (true) {
                    try {
                        this.openRmSession(this.configuration.requestResponseOperationsDetected() ? this.sequenceManager.generateSequenceUID() : null, this.communicator.tryStartSecureConversation());
                    }
                    catch (Exception ex) {
                        LOGGER.warning(LocalizationMessages.WSRM_1106_RM_SESSION_INIT_ATTEMPT_FAILED(), ex);
                    }
                    finally {
                        if (++numberOfInitiateSessionAttempts <= 3) continue;
                        throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1107_MAX_RM_SESSION_INIT_ATTEMPTS_REACHED()));
                    }
                    break;
                }
                this.scheduledTaskManager.startTask(this.fiberResumeTask, this.configuration.getMessageRetransmissionInterval(), this.configuration.getMessageRetransmissionInterval());
                this.scheduledTaskManager.startTask(this.requestResendTask, this.configuration.getMessageRetransmissionInterval(), this.configuration.getMessageRetransmissionInterval());
                this.scheduledTaskManager.startTask(this.createAckRequesterTask(), this.configuration.getAcknowledgementRequestInterval(), this.configuration.getAcknowledgementRequestInterval());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private boolean isInitialized() {
        return this.outboundSequenceId != null;
    }

    private Runnable createAckRequesterTask() {
        return new Runnable(){

            public void run() {
                try {
                    if (ClientSession.this.isAutomaticAckRequestPending()) {
                        ClientSession.this.requestAcknowledgement();
                        ClientSession.this.lastAckRequestedTime.set(System.currentTimeMillis());
                    }
                }
                catch (RxException ex) {
                    LOGGER.warning(LocalizationMessages.WSRM_1110_ACK_REQUEST_FAILED(), ex);
                }
            }
        };
    }

    private boolean isAutomaticAckRequestPending() throws RxRuntimeException {
        return this.lastAckRequestedTime.get() - System.currentTimeMillis() > this.configuration.getAcknowledgementRequestInterval() && this.sequenceManager.getSequence(this.outboundSequenceId).hasPendingAcknowledgements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilAllRequestsAckedOrCloseOperationTimeout() {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (!ClientSession.this.sequenceManager.getSequence(ClientSession.this.outboundSequenceId).hasPendingAcknowledgements()) {
                        doneSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.severe(LocalizationMessages.WSRM_1111_UNEXPECTED_EXCEPTION_WHILE_WAITING_FOR_SEQ_ACKS(), (Throwable)((Object)ex));
                    doneSignal.countDown();
                }
            }
        });
        try {
            if (this.configuration.getCloseSequenceOperationTimeout() > 0L) {
                boolean waitResult = doneSignal.await(this.configuration.getCloseSequenceOperationTimeout(), TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info(LocalizationMessages.WSRM_1112_CLOSE_OUTBOUND_SEQUENCE_TIMED_OUT(this.outboundSequenceId));
                }
            } else {
                doneSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine(LocalizationMessages.WSRM_1113_CLOSE_OUTBOUND_SEQUENCE_INTERRUPTED(this.outboundSequenceId), ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }
}

