/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.signature.ObjectContainer;
import com.sun.org.apache.xml.internal.security.signature.SignedInfo;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignerOutputStream;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    static Logger log = Logger.getLogger(XMLSignature.class.getName());
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA1 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    private SignedInfo _signedInfo = null;
    private KeyInfo _keyInfo = null;
    private boolean _followManifestsDuringValidation = false;
    private Element signatureValueElement;

    public XMLSignature(Document document, String string2, String string3) throws XMLSecurityException {
        this(document, string2, string3, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string2, String string3, int n) throws XMLSecurityException {
        this(document, string2, string3, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string2, String string3, String string4) throws XMLSecurityException {
        this(document, string2, string3, 0, string4);
    }

    public XMLSignature(Document document, String string2, String string3, int n, String string4) throws XMLSecurityException {
        super(document);
        String string5 = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (string5 == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string5, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string2;
        this._signedInfo = new SignedInfo(this._doc, string3, n, string4);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Document document, String string2, Element element, Element element2) throws XMLSecurityException {
        super(document);
        String string3 = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (string3 == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string2;
        this._signedInfo = new SignedInfo(this._doc, element, element2);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Element element, String string2) throws XMLSignatureException, XMLSecurityException {
        super(element, string2);
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if (element2 == null) {
            Object[] objectArray = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this._signedInfo = new SignedInfo(element2, string2);
        this.signatureValueElement = XMLUtils.getNextElement(element2.getNextSibling());
        if (this.signatureValueElement == null) {
            Object[] objectArray = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        Element element3 = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling());
        if (element3 != null && element3.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element3.getLocalName().equals("KeyInfo")) {
            this._keyInfo = new KeyInfo(element3, string2);
        }
    }

    public void setId(String string2) {
        if (string2 != null) {
            this._constructionElement.setAttributeNS(null, "Id", string2);
            IdResolver.registerElementById(this._constructionElement, string2);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this._signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            byte[] byArray = Base64.decode(this.signatureValueElement);
            return byArray;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    private void setSignatureValueElement(byte[] byArray) {
        while (this.signatureValueElement.hasChildNodes()) {
            this.signatureValueElement.removeChild(this.signatureValueElement.getFirstChild());
        }
        String string2 = Base64.encode(byArray);
        if (string2.length() > 76 && !XMLUtils.ignoreLineBreaks()) {
            string2 = "\n" + string2 + "\n";
        }
        Text text = this._doc.createTextNode(string2);
        this.signatureValueElement.appendChild(text);
    }

    public KeyInfo getKeyInfo() {
        if (this._keyInfo == null) {
            this._keyInfo = new KeyInfo(this._doc);
            Element element = this._keyInfo.getElement();
            Element element2 = null;
            Node node = this._constructionElement.getFirstChild();
            element2 = XMLUtils.selectDsNode(node, "Object", 0);
            if (element2 != null) {
                this._constructionElement.insertBefore(element, element2);
                XMLUtils.addReturnBeforeChild(this._constructionElement, element2);
            } else {
                this._constructionElement.appendChild(element);
                XMLUtils.addReturnToElement(this._constructionElement);
            }
        }
        return this._keyInfo;
    }

    public void appendObject(ObjectContainer objectContainer) throws XMLSignatureException {
        this._constructionElement.appendChild(objectContainer.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public ObjectContainer getObjectItem(int n) {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Object", n);
        try {
            return new ObjectContainer(element, this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key key) throws XMLSignatureException {
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            signatureAlgorithm.initSign(key);
            signedInfo.generateDigestValues();
            UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(new SignerOutputStream(signatureAlgorithm));
            try {
                ((OutputStream)unsyncBufferedOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            signedInfo.signInOctectStream(unsyncBufferedOutputStream);
            byte[] byArray = signatureAlgorithm.sign();
            this.setSignatureValueElement(byArray);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        this.getSignedInfo().addResourceResolver(resourceResolver);
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.getSignedInfo().addResourceResolver(resourceResolverSpi);
    }

    public boolean checkSignatureValue(X509Certificate x509Certificate) throws XMLSignatureException {
        if (x509Certificate != null) {
            return this.checkSignatureValue(x509Certificate.getPublicKey());
        }
        Object[] objectArray = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", objectArray);
    }

    public boolean checkSignatureValue(Key key) throws XMLSignatureException {
        if (key == null) {
            Object[] objectArray = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", objectArray);
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            log.log(Level.FINE, "SignatureMethodURI = " + signatureAlgorithm.getAlgorithmURI());
            log.log(Level.FINE, "jceSigAlgorithm    = " + signatureAlgorithm.getJCEAlgorithmString());
            log.log(Level.FINE, "jceSigProvider     = " + signatureAlgorithm.getJCEProviderName());
            log.log(Level.FINE, "PublicKey = " + key);
            signatureAlgorithm.initVerify(key);
            SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
            UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);
            signedInfo.signInOctectStream(unsyncBufferedOutputStream);
            try {
                ((OutputStream)unsyncBufferedOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = this.getSignatureValue();
            if (!signatureAlgorithm.verify(byArray)) {
                log.log(Level.WARNING, "Signature verification failed.");
                return false;
            }
            return signedInfo.verify(this._followManifestsDuringValidation);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addDocument(String string2, Transforms transforms, String string3, String string4, String string5) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string2, transforms, string3, string4, string5);
    }

    public void addDocument(String string2, Transforms transforms, String string3) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string2, transforms, string3, null, null);
    }

    public void addDocument(String string2, Transforms transforms) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string2, transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String string2) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string2, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate x509Certificate) throws XMLSecurityException {
        X509Data x509Data = new X509Data(this._doc);
        x509Data.addCertificate(x509Certificate);
        this.getKeyInfo().add(x509Data);
    }

    public void addKeyInfo(PublicKey publicKey) {
        this.getKeyInfo().add(publicKey);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return this.getSignedInfo().createSecretKey(byArray);
    }

    public void setFollowNestedManifests(boolean bl) {
        this._followManifestsDuringValidation = bl;
    }

    public String getBaseLocalName() {
        return "Signature";
    }
}

