/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.resourcestore;

import com.ibm.form.webform.resources.ResourceManager;
import com.ibm.form.webform.resourcestore.GenericResourceProvider;
import com.ibm.form.webform.resourcestore.RemoteResourceProvider;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.ResourceProvider;
import com.ibm.form.webform.resourcestore.ResourceProviderGroup;
import com.ibm.form.webform.resourcestore.SpecificResourceProvider;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.net.URI;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ResourceProviderGroupImpl
implements ResourceProviderGroup {
    private SortedSet resourceProviders = new TreeSet();

    public void addResourceProvider(ResourceProvider p) {
        this.resourceProviders.add(new PrioritizedResourceProvider(p));
    }

    public void removeResourceProvider(ResourceProvider p) {
        this.resourceProviders.remove(p);
    }

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
        boolean handlerFound = false;
        boolean credentialsValid = true;
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            PrioritizedResourceProvider p = (PrioritizedResourceProvider)i.next();
            if (!p.doesHandleResourceType(id.getScheme())) continue;
            handlerFound = true;
            try {
                if (p.doesExist(id, userCredentials)) {
                    return true;
                }
                credentialsValid = true;
            }
            catch (InvalidCredentialsException e) {}
        }
        if (!handlerFound) {
            throw new UnhandledResourceTypeException();
        }
        if (!credentialsValid) {
            throw new InvalidCredentialsException();
        }
        return false;
    }

    public boolean doesHandleResourceType(String scheme) throws ResourceSystemError {
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            if (!((PrioritizedResourceProvider)i.next()).doesHandleResourceType(scheme)) continue;
            return true;
        }
        return false;
    }

    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws ResourceSystemError, InvalidCredentialsException, UnhandledResourceTypeException {
        boolean handlerFound = false;
        boolean credentialsValid = false;
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            PrioritizedResourceProvider p = (PrioritizedResourceProvider)i.next();
            if (!p.doesHandleResourceType(id.getScheme())) continue;
            handlerFound = true;
            try {
                StoredResource r = p.get(id, userCredentials);
                if (r != null) {
                    return r;
                }
                credentialsValid = true;
            }
            catch (InvalidCredentialsException e) {}
        }
        if (!handlerFound) {
            throw new UnhandledResourceTypeException();
        }
        if (!credentialsValid) {
            throw new InvalidCredentialsException();
        }
        return null;
    }

    public boolean put(URI id, StoredResource r, int replacePolicy, ResourceAccessCredentials userCredentials) throws ResourceSystemError, InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException, ResourceSystemError {
        boolean handlerFound = false;
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            PrioritizedResourceProvider p = (PrioritizedResourceProvider)i.next();
            if (!p.doesHandleResourceType(id.getScheme())) continue;
            handlerFound = true;
            try {
                return p.put(id, r, replacePolicy, userCredentials);
            }
            catch (InvalidCredentialsException e) {
            }
        }
        if (!handlerFound) {
            throw new UnhandledResourceTypeException();
        }
        throw new InvalidCredentialsException();
    }

    public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
        boolean handlerFound = false;
        boolean credentialsValid = false;
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            PrioritizedResourceProvider p = (PrioritizedResourceProvider)i.next();
            if (!p.doesHandleResourceType(id.getScheme())) continue;
            handlerFound = true;
            try {
                if (p.remove(id, userCredentials)) {
                    return true;
                }
                credentialsValid = true;
            }
            catch (InvalidCredentialsException e) {}
        }
        if (!handlerFound) {
            throw new UnhandledResourceTypeException();
        }
        if (!credentialsValid) {
            throw new InvalidCredentialsException();
        }
        return false;
    }

    public ResourceProvider getProvider(String scheme) throws ResourceSystemError {
        ResourceProvider provider = null;
        Iterator i = this.resourceProviders.iterator();
        while (i.hasNext()) {
            PrioritizedResourceProvider p = (PrioritizedResourceProvider)i.next();
            if (!p.doesHandleResourceType(scheme)) continue;
            provider = p.getProvider();
            break;
        }
        return provider;
    }

    private class PrioritizedResourceProvider
    implements Comparable,
    ResourceProvider {
        private static final int FIRST_PRIORITY_PROVIDER = 1;
        private static final int SECOND_PRIORITY_PROVIDER = 2;
        private static final int THIRD_PRIORITY_PROVIDER = 3;
        private final ResourceProvider p;
        private final int priority;

        public PrioritizedResourceProvider(ResourceProvider p) {
            this.p = p;
            if (p instanceof SpecificResourceProvider) {
                this.priority = 1;
            } else if (p instanceof GenericResourceProvider) {
                this.priority = 2;
            } else if (p instanceof RemoteResourceProvider) {
                this.priority = 3;
            } else {
                throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_UNKNOWN_PROVIDER_TYPE"), (String[])new String[]{p.getClass().getName()}));
            }
        }

        public int hashCode() {
            return this.p.hashCode();
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (this.priority != ((PrioritizedResourceProvider)o).priority) {
                return this.priority - ((PrioritizedResourceProvider)o).priority;
            }
            return this.hashCode() - o.hashCode();
        }

        public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
            return this.p.doesExist(id, userCredentials);
        }

        public boolean doesHandleResourceType(String scheme) throws ResourceSystemError {
            return this.p.doesHandleResourceType(scheme);
        }

        public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws ResourceSystemError, InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
            return this.p.get(id, userCredentials);
        }

        public boolean put(URI id, StoredResource r, int replacePolicy, ResourceAccessCredentials userCredentials) throws ResourceSystemError, InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException {
            return this.p.put(id, r, replacePolicy, userCredentials);
        }

        public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
            return this.p.remove(id, userCredentials);
        }

        public ResourceProvider getProvider() {
            return this.p;
        }
    }
}

