/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.resourcestore;

import com.ibm.form.webform.resources.ResourceManager;
import com.ibm.form.webform.resourcestore.RemoteResourceProvider;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceDoesNotExistException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceProviderException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class RemoteResourceProviderRESTImpl
implements RemoteResourceProvider {
    private HttpClient client = new HttpClient();
    private String resourceServiceURL;
    static /* synthetic */ Class class$com$ibm$form$webform$resourcestore$exceptions$InvalidCredentialsException;
    static /* synthetic */ Class class$com$ibm$form$webform$resourcestore$exceptions$ResourceDoesNotExistException;
    static /* synthetic */ Class class$com$ibm$form$webform$resourcestore$exceptions$ResourceExistsException;
    static /* synthetic */ Class class$com$ibm$form$webform$resourcestore$exceptions$UnhandledResourceTypeException;

    public RemoteResourceProviderRESTImpl(String translatorURL) {
        this.resourceServiceURL = translatorURL + "/ResourceService";
    }

    public boolean doesHandleResourceType(String scheme) throws ResourceSystemError {
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("Action", "providerAction"), new NameValuePair("Method", "doesHandleResourceType"), new NameValuePair("Scheme", scheme)};
        try {
            return this.executeBooleanMethod(params);
        }
        catch (ResourceSystemError e) {
            throw e;
        }
        catch (IOException e) {
            throw new ResourceSystemError(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("Action", "providerAction"), new NameValuePair("Method", "doesExist"), new NameValuePair("Scheme", id.getScheme()), new NameValuePair("Id", id.getSchemeSpecificPart()), new NameValuePair("UserCredentials", userCredentials == null ? "null" : userCredentials.toString())};
        try {
            return this.executeBooleanMethod(params);
        }
        catch (InvalidCredentialsException e) {
            throw e;
        }
        catch (UnhandledResourceTypeException e) {
            throw e;
        }
        catch (ResourceSystemError e) {
            throw e;
        }
        catch (IOException e) {
            throw new ResourceSystemError(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
        StoredResource storedResource;
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("Action", "providerAction"), new NameValuePair("Method", "get"), new NameValuePair("Scheme", id.getScheme()), new NameValuePair("Id", id.getSchemeSpecificPart()), new NameValuePair("UserCredentials", userCredentials == null ? "null" : userCredentials.toString())};
        GetMethod method = new GetMethod(this.resourceServiceURL);
        try {
            method.setQueryString(params);
            storedResource = (StoredResource)this.doExecuteObjectMethod((HttpMethodBase)method);
        }
        catch (Throwable throwable) {
            try {
                method.releaseConnection();
                throw throwable;
            }
            catch (InvalidCredentialsException e) {
                throw e;
            }
            catch (UnhandledResourceTypeException e) {
                throw e;
            }
            catch (ResourceSystemError e) {
                throw e;
            }
            catch (IOException e) {
                throw new ResourceSystemError(e);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        method.releaseConnection();
        return storedResource;
    }

    public boolean put(URI id, StoredResource resource, int replacePolicy, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException, ResourceSystemError {
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("Action", "providerAction"), new NameValuePair("Method", "put"), new NameValuePair("Scheme", id.getScheme()), new NameValuePair("Id", id.getSchemeSpecificPart()), new NameValuePair("ReplacePolicy", Integer.toString(replacePolicy)), new NameValuePair("UserCredentials", userCredentials == null ? "null" : userCredentials.toString())};
        Part[] parts = new Part[params.length + 1];
        for (int i = 0; i < params.length; ++i) {
            parts[i] = new StringPart(params[i].getName(), params[i].getValue());
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(resource);
            ByteArrayPartSource baps = new ByteArrayPartSource("resource", baos.toByteArray());
            parts[params.length] = new FilePart("resource", (PartSource)baps);
        }
        catch (IOException e) {
            throw new ResourceSystemError(e);
        }
        try {
            return this.executeBooleanMethod(parts);
        }
        catch (InvalidCredentialsException e) {
            throw e;
        }
        catch (UnhandledResourceTypeException e) {
            throw e;
        }
        catch (ResourceExistsException e) {
            throw e;
        }
        catch (ResourceSystemError e) {
            throw e;
        }
        catch (IOException e) {
            throw new ResourceSystemError(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceSystemError {
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("Action", "providerAction"), new NameValuePair("Method", "remove"), new NameValuePair("Scheme", id.getScheme()), new NameValuePair("Id", id.getSchemeSpecificPart()), new NameValuePair("UserCredentials", userCredentials == null ? "null" : userCredentials.toString())};
        try {
            return this.executeBooleanMethod(params);
        }
        catch (InvalidCredentialsException e) {
            throw e;
        }
        catch (UnhandledResourceTypeException e) {
            throw e;
        }
        catch (ResourceSystemError e) {
            throw e;
        }
        catch (IOException e) {
            throw new ResourceSystemError(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeBooleanMethod(NameValuePair[] params) throws ResourceProviderException, IOException {
        GetMethod method = new GetMethod(this.resourceServiceURL);
        try {
            method.setQueryString(params);
            boolean bl = this.doExecuteBooleanMethod((HttpMethodBase)method);
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBooleanMethod(Part[] parts) throws ResourceProviderException, IOException {
        PostMethod method = new PostMethod(this.resourceServiceURL);
        try {
            HttpMethodParams httpParams = new HttpMethodParams();
            MultipartRequestEntity mre = new MultipartRequestEntity(parts, httpParams);
            method.setRequestEntity((RequestEntity)mre);
            boolean bl = this.doExecuteBooleanMethod((HttpMethodBase)method);
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    private String transferStreamToStringBounded(InputStream is, int nMaxChars) throws IOException {
        int nTotalBytesRead = 0;
        StringBuffer result = new StringBuffer(nMaxChars);
        byte[] buf = new byte[32768];
        int nBytesRead = is.read(buf);
        while (nBytesRead != -1) {
            for (int i = 0; i < nBytesRead && nTotalBytesRead < nMaxChars; ++nTotalBytesRead, ++i) {
                result.append((char)buf[i]);
            }
            nBytesRead = is.read(buf);
        }
        return result.toString();
    }

    private boolean doExecuteBooleanMethod(HttpMethodBase method) throws ResourceProviderException, IOException {
        this.execute(method);
        InputStream resultStream = method.getResponseBodyAsStream();
        String resultText = this.transferStreamToStringBounded(resultStream, 10);
        return Boolean.valueOf(resultText);
    }

    private Object doExecuteObjectMethod(HttpMethodBase method) throws ResourceProviderException, IOException {
        try {
            this.execute(method);
            InputStream is = method.getResponseBodyAsStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }
        catch (ResourceProviderException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new ResourceSystemError(e);
        }
    }

    private void execute(HttpMethodBase method) throws ResourceProviderException, IOException {
        int status = this.client.executeMethod((HttpMethod)method);
        if (status == 200) {
            return;
        }
        if (status == 400) {
            String statusText = method.getStatusText();
            if (statusText.startsWith((class$com$ibm$form$webform$resourcestore$exceptions$InvalidCredentialsException == null ? (class$com$ibm$form$webform$resourcestore$exceptions$InvalidCredentialsException = RemoteResourceProviderRESTImpl.class$("com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException")) : class$com$ibm$form$webform$resourcestore$exceptions$InvalidCredentialsException).getName())) {
                throw new InvalidCredentialsException();
            }
            if (statusText.startsWith((class$com$ibm$form$webform$resourcestore$exceptions$ResourceDoesNotExistException == null ? (class$com$ibm$form$webform$resourcestore$exceptions$ResourceDoesNotExistException = RemoteResourceProviderRESTImpl.class$("com.ibm.form.webform.resourcestore.exceptions.ResourceDoesNotExistException")) : class$com$ibm$form$webform$resourcestore$exceptions$ResourceDoesNotExistException).getName())) {
                throw new ResourceDoesNotExistException(statusText.substring(statusText.indexOf(58) + 1));
            }
            if (statusText.startsWith((class$com$ibm$form$webform$resourcestore$exceptions$ResourceExistsException == null ? (class$com$ibm$form$webform$resourcestore$exceptions$ResourceExistsException = RemoteResourceProviderRESTImpl.class$("com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException")) : class$com$ibm$form$webform$resourcestore$exceptions$ResourceExistsException).getName())) {
                throw new ResourceExistsException();
            }
            if (statusText.startsWith((class$com$ibm$form$webform$resourcestore$exceptions$UnhandledResourceTypeException == null ? (class$com$ibm$form$webform$resourcestore$exceptions$UnhandledResourceTypeException = RemoteResourceProviderRESTImpl.class$("com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException")) : class$com$ibm$form$webform$resourcestore$exceptions$UnhandledResourceTypeException).getName())) {
                throw new UnhandledResourceTypeException();
            }
            throw new IllegalStateException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_UNKNOWN_RESOURCE_PROVIDER_EXCEPTION_TYPE") + statusText.substring(0, statusText.indexOf(58)));
        }
        if (status == 500) {
            throw new ResourceSystemError(method.getStatusText());
        }
        throw new IOException(method.getStatusText());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

