/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.resourcestore;

import com.ibm.form.webform.resourcestore.GenericResourceProvider;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GenericResourceProviderImpl
implements GenericResourceProvider {
    private Map resources = new HashMap();

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        return this.resources.containsKey(id);
    }

    public boolean doesHandleResourceType(String scheme) {
        return true;
    }

    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        return (StoredResource)this.resources.get(id);
    }

    public boolean put(URI id, StoredResource ft, int replacePolicy, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, ResourceExistsException {
        boolean alreadyExists = this.resources.containsKey(id);
        if (alreadyExists) {
            switch (replacePolicy) {
                case 2: {
                    return false;
                }
                case 3: {
                    throw new ResourceExistsException();
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.resources.put(id, ft);
        return true;
    }

    public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        if (this.resources.containsKey(id)) {
            this.resources.remove(id);
            return true;
        }
        return false;
    }
}

