/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.resourcestore;

import com.ibm.form.webform.resources.ResourceManager;
import com.ibm.form.webform.resourcestore.FormTemplateProvider;
import com.ibm.form.webform.resourcestore.FormTemplate_Stream;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class FormTemplateProvider_StreamImpl
implements FormTemplateProvider {
    private Map resources = new HashMap();

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        return this.resources.containsKey(id);
    }

    public boolean doesHandleResourceType(String scheme) {
        return scheme.equals("formtemplate");
    }

    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws ResourceSystemError, InvalidCredentialsException {
        return (FormTemplate_Stream)this.resources.remove(id);
    }

    public boolean put(URI id, StoredResource ft, int replacePolicy, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException {
        if (!(ft instanceof FormTemplate_Stream)) {
            throw new UnhandledResourceTypeException();
        }
        boolean alreadyExists = this.resources.containsKey(id);
        if (alreadyExists) {
            switch (replacePolicy) {
                case 2: {
                    return false;
                }
                case 3: {
                    throw new ResourceExistsException();
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_UNKNOWN_REPLACE_POLICY_OUT_OF_RANGE"), (String[])new String[]{"" + replacePolicy}));
                }
            }
        }
        this.resources.put(id, ft);
        return true;
    }

    public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        if (this.resources.containsKey(id)) {
            this.resources.remove(id);
            return true;
        }
        return false;
    }
}

