/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.resourcestore;

import com.PureEdge.IFSSingleton;
import com.PureEdge.error.UWIException;
import com.PureEdge.util.IdentifierFactory;
import com.ibm.form.webform.logging.Logger;
import com.ibm.form.webform.resources.ResourceManager;
import com.ibm.form.webform.resourcestore.BackgroundGeneratedResourceContainer;
import com.ibm.form.webform.resourcestore.DOMFactoryParamsImpl;
import com.ibm.form.webform.resourcestore.FormDOMFactory;
import com.ibm.form.webform.resourcestore.FormTemplateProvider;
import com.ibm.form.webform.resourcestore.FormTemplate_DOM;
import com.ibm.form.webform.resourcestore.FormTemplate_Stream;
import com.ibm.form.webform.resourcestore.GlobalFormTemplateStore;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceDoesNotExistException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class FormTemplateProvider_DOMImpl
implements FormTemplateProvider {
    public static final int DEFAULT_POOL_SIZE = 1;
    private static final String FORM_TEMPLATE_CACHE_NAME = "FormTemplateDOMCache";
    private final FormDOMFactory formDOMFactory;
    private final GlobalFormTemplateStore globalFormTemplateStore;
    private final String formCacheLocation;
    private final int poolSize;
    private Logger theLogger;
    private final Ehcache resources;
    private final CacheUpdateThread cacheUpdateThread = new CacheUpdateThread();

    public FormTemplateProvider_DOMImpl(FormDOMFactory formDOMFactory, GlobalFormTemplateStore globalFormTemplateStore, String formCacheLocation, CacheManager cacheManager, Logger theLogger) throws UWIException {
        this(formDOMFactory, globalFormTemplateStore, formCacheLocation, cacheManager, 1, theLogger);
    }

    public FormTemplateProvider_DOMImpl(FormDOMFactory formDOMFactory, GlobalFormTemplateStore globalFormTemplateStore, String formCacheLocation, CacheManager cacheManager, int poolSize, Logger theLogger) throws UWIException {
        this.formDOMFactory = formDOMFactory;
        this.globalFormTemplateStore = globalFormTemplateStore;
        this.formCacheLocation = formCacheLocation;
        this.poolSize = poolSize;
        this.theLogger = theLogger;
        this.resources = cacheManager.getCache(FORM_TEMPLATE_CACHE_NAME);
        if (this.resources == null) {
            throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/RESOURCESTORE_ERROR_UNABLE_TO_OPEN_CACHE"), (String[])new String[]{FORM_TEMPLATE_CACHE_NAME}));
        }
        this.cacheUpdateThread.start();
    }

    public void finalize() {
        this.destroy();
    }

    public void destroy() {
        this.cacheUpdateThread.interrupt();
        while (true) {
            try {
                this.cacheUpdateThread.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean doesHandleResourceType(String scheme) {
        return scheme.equals("formtemplate");
    }

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws ResourceSystemError, UnhandledResourceTypeException, InvalidCredentialsException {
        this.validateUserCredentials(userCredentials);
        if (!this.doesHandleResourceType(id.getScheme())) {
            throw new UnhandledResourceTypeException();
        }
        return this.globalFormTemplateStore.doesExist(id.getSchemeSpecificPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, ResourceSystemError {
        FormTemplate_DOM ft;
        this.validateUserCredentials(userCredentials);
        FormTemplatePool pool = null;
        Ehcache ehcache = this.resources;
        synchronized (ehcache) {
            Element element = this.resources.get((Serializable)id);
            FormTemplate_Stream ftStream = null;
            if (element == null) {
                try {
                    ftStream = this.globalFormTemplateStore.read(id.getSchemeSpecificPart());
                }
                catch (ResourceDoesNotExistException e) {
                    return null;
                }
            }
            pool = (FormTemplatePool)element.getValue();
            try {
                ftStream = this.globalFormTemplateStore.readIfNecessary(id.getSchemeSpecificPart(), pool.getRevision());
            }
            catch (ResourceDoesNotExistException e) {
                this.resources.remove((Serializable)id);
                pool.destroy();
                return null;
            }
            if (ftStream != null) {
                if (pool != null) {
                    this.resources.remove((Serializable)id);
                    pool.destroy();
                }
                pool = new FormTemplatePool(ftStream, this.poolSize);
                this.resources.put(new Element((Serializable)id, (Serializable)pool));
            }
        }
        try {
            ft = pool.assignInstance();
        }
        catch (UWIException e) {
            throw new ResourceSystemError((Exception)((Object)e));
        }
        ft.awaitGeneration();
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(URI id, StoredResource xfdlStream, int replacePolicy, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException, ResourceSystemError {
        this.validateUserCredentials(userCredentials);
        if (!(xfdlStream instanceof FormTemplate_Stream)) {
            throw new UnhandledResourceTypeException();
        }
        Ehcache ehcache = this.resources;
        synchronized (ehcache) {
            if (this.doesExist(id, userCredentials)) {
                switch (replacePolicy) {
                    case 2: {
                        return false;
                    }
                    case 3: {
                        throw new ResourceExistsException();
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_UNKNOWN_REPLACE_POLICY_OUT_OF_RANGE"), (String[])new String[]{"" + replacePolicy}));
                    }
                }
            }
            FormTemplate_Stream ft = (FormTemplate_Stream)xfdlStream;
            ft.setRevision(this.globalFormTemplateStore.write(ft));
            FormTemplatePool pool = new FormTemplatePool(ft, this.poolSize);
            this.resources.put(new Element((Serializable)id, (Serializable)pool));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(URI uri, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, ResourceSystemError {
        this.validateUserCredentials(userCredentials);
        Element element = null;
        Ehcache ehcache = this.resources;
        synchronized (ehcache) {
            element = this.resources.get((Serializable)uri);
            if (element != null) {
                this.resources.remove((Serializable)uri);
                FormTemplatePool pool = (FormTemplatePool)element.getValue();
                pool.destroy();
            }
        }
        return this.globalFormTemplateStore.remove(uri.getSchemeSpecificPart());
    }

    public static String createFormInstanceId() throws UWIException {
        IdentifierFactory theIDFactory = null;
        theIDFactory = IFSSingleton.getIdentifierFactory();
        if (theIDFactory == null) {
            throw new UWIException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_IDFACTORY_NOT_AVAILABE"));
        }
        String uuid = theIDFactory.getUUID(true).replaceAll("-", "");
        StringBuffer uuidText = new StringBuffer(uuid).reverse();
        String translatorID = System.getProperty("translator.id");
        if (translatorID == null) {
            translatorID = "000";
        } else if (!Pattern.matches("^[0-9a-fA-F]{1,3}$", translatorID)) {
            throw new UWIException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_INVALID_TRANSLATOR_ID"));
        }
        uuidText.append(translatorID);
        return uuidText.toString();
    }

    public static boolean isValidFormInstanceId(String id) {
        return Pattern.matches("^[0-9a-fA-F]{33,35}$", id);
    }

    public static String buildFormInstanceLocation(String rootLocation, String formInstanceId) {
        return rootLocation + File.separator + formInstanceId + File.separator;
    }

    private void validateUserCredentials(ResourceAccessCredentials userCredentials) throws InvalidCredentialsException {
        if (userCredentials != null) {
            throw new InvalidCredentialsException();
        }
    }

    private class FormTemplatePool
    implements BackgroundGeneratedResourceContainer,
    Serializable {
        private static final long serialVersionUID = -6763175461379348060L;
        private final URI uri;
        private final byte[] xfdlStream;
        private final int revision;
        private UWIException exception;
        private List instances;
        private int generationState;

        public FormTemplatePool(FormTemplate_Stream ft, int poolSize) throws ResourceSystemError {
            this.uri = ft.getURI();
            this.xfdlStream = ft.getXFDLStream();
            this.revision = ft.getRevision();
            this.exception = null;
            this.generationState = 0;
            FormTemplateProvider_DOMImpl.this.cacheUpdateThread.enqueueForInstallation(this);
            this.instances = new LinkedList();
            for (int i = 0; i < poolSize; ++i) {
                this.createInstance(this.uri, this.xfdlStream);
            }
        }

        public synchronized void destroy() throws ResourceSystemError {
            FormTemplateProvider_DOMImpl.this.cacheUpdateThread.dequeueAllWork(this.uri.getSchemeSpecificPart());
            for (int i = 0; i < this.instances.size(); ++i) {
                FormTemplate_DOM ft = (FormTemplate_DOM)this.instances.get(i);
                try {
                    ft.destroy(FormTemplateProvider_DOMImpl.this.formDOMFactory);
                    continue;
                }
                catch (UWIException uWIException) {
                    // empty catch block
                }
            }
            if (this.isQueuedForGeneration()) {
                throw new IllegalStateException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_DESTROY_FORM_TEMPLATE_POOL"));
            }
            if (this.isBeingGenerated()) {
                this.awaitGeneration();
            }
        }

        public synchronized FormTemplate_DOM assignInstance() throws UWIException {
            if (this.exception != null) {
                throw this.exception;
            }
            FormTemplate_DOM ft = (FormTemplate_DOM)this.instances.remove(0);
            this.createInstance(ft.getURI(), ft.getXFDLStream());
            return ft;
        }

        private void createInstance(URI id, byte[] xfdlStream) {
            FormTemplate_DOM ft = new FormTemplate_DOM(id, xfdlStream);
            this.instances.add(ft);
            FormTemplateProvider_DOMImpl.this.cacheUpdateThread.enqueueForInstanceGeneration(ft);
        }

        public String getId() {
            return this.uri.getSchemeSpecificPart();
        }

        public byte[] getXFDLStream() {
            return this.xfdlStream;
        }

        public URI getURI() {
            return this.uri;
        }

        public int getRevision() {
            return this.revision;
        }

        public synchronized void setException(UWIException exception) {
            this.exception = exception;
        }

        public synchronized boolean isBeingGenerated() {
            return this.generationState == 1;
        }

        public synchronized boolean isGenerated() {
            return this.generationState == 2;
        }

        public boolean isHalted() {
            return this.generationState == 3;
        }

        public synchronized boolean isQueuedForGeneration() {
            return this.generationState == 0;
        }

        public synchronized void setIsGenerated() {
            this.generationState = 2;
            this.notify();
        }

        public synchronized void setIsBeingGenerated() {
            this.generationState = 1;
        }

        public synchronized void setIsHalted() {
            this.generationState = 3;
        }

        public synchronized void awaitGeneration() {
            while (!this.isGenerated()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class CacheUpdateThread
    extends Thread {
        private LinkedList workQueue = new LinkedList();

        public CacheUpdateThread() {
            super(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/DOM_FORM_TEMPLATE_UPDATE_THREAD"));
            this.setDaemon(true);
            this.setPriority(4);
        }

        public void enqueueForInstanceGeneration(FormTemplate_DOM r) {
            this.enqueueCommand(new GenerateFormInstanceCommand(r));
        }

        public void enqueueForInstallation(FormTemplatePool p) {
            this.enqueueCommand(new InstallTemplateCommand(p));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueCommand(CacheUpdateCommand command) {
            LinkedList linkedList = this.workQueue;
            synchronized (linkedList) {
                this.workQueue.addLast(command);
                this.workQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeueAllWork(String templateId) {
            LinkedList linkedList = this.workQueue;
            synchronized (linkedList) {
                LinkedList<CacheUpdateCommand> newWorkQueue = new LinkedList<CacheUpdateCommand>();
                for (int i = 0; i < this.workQueue.size(); ++i) {
                    CacheUpdateCommand c = (CacheUpdateCommand)this.workQueue.get(i);
                    if (!c.getId().equals(templateId)) {
                        newWorkQueue.add(c);
                        continue;
                    }
                    c.resource.setIsHalted();
                }
                this.workQueue = newWorkQueue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                CacheUpdateCommand command = null;
                LinkedList linkedList = this.workQueue;
                synchronized (linkedList) {
                    if (this.workQueue.isEmpty()) {
                        try {
                            this.workQueue.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    command = (CacheUpdateCommand)this.workQueue.removeFirst();
                    Thread.yield();
                }
                command.getResource().setIsBeingGenerated();
                try {
                    command.execute();
                }
                catch (Throwable t) {
                    FormTemplateProvider_DOMImpl.this.theLogger.writeThrowableErrorLog(t);
                }
                finally {
                    command.getResource().setIsGenerated();
                }
            }
        }
    }

    private class InstallTemplateCommand
    extends CacheUpdateCommand {
        public InstallTemplateCommand(FormTemplatePool p) {
            super(p);
        }

        public void execute() {
            FormTemplatePool p = (FormTemplatePool)this.resource;
            try {
                FormTemplateProvider_DOMImpl.this.globalFormTemplateStore.extractEnclosures(new FormTemplate_Stream(p.getURI(), p.getXFDLStream()));
            }
            catch (ResourceSystemError e) {
                p.setException(new UWIException((Exception)e));
            }
        }
    }

    private class GenerateFormInstanceCommand
    extends CacheUpdateCommand {
        public GenerateFormInstanceCommand(FormTemplate_DOM t) {
            super(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            FormTemplate_DOM t = (FormTemplate_DOM)this.resource;
            try {
                String templateId = t.getId();
                String formInstanceId = FormTemplateProvider_DOMImpl.createFormInstanceId();
                String formInstanceLocation = FormTemplateProvider_DOMImpl.buildFormInstanceLocation(FormTemplateProvider_DOMImpl.this.formCacheLocation, formInstanceId);
                String userInfo = "";
                String action = "open";
                DOMFactoryParamsImpl params = new DOMFactoryParamsImpl(templateId, formInstanceId, formInstanceLocation, userInfo, action);
                FormTemplateProvider_DOMImpl.this.formDOMFactory.createForm(new ByteArrayInputStream(t.getXFDLStream()), params);
                FormTemplate_DOM formTemplate_DOM = t;
                synchronized (formTemplate_DOM) {
                    t.setContent(params);
                    t.notify();
                }
            }
            catch (UWIException e) {
                FormTemplate_DOM formTemplate_DOM = t;
                synchronized (formTemplate_DOM) {
                    t.setException(e);
                    t.notify();
                }
            }
            catch (Exception e) {
                FormTemplate_DOM formTemplate_DOM = t;
                synchronized (formTemplate_DOM) {
                    t.setException(new UWIException(e));
                    t.notify();
                }
            }
        }
    }

    private abstract class CacheUpdateCommand {
        protected final BackgroundGeneratedResourceContainer resource;

        CacheUpdateCommand(BackgroundGeneratedResourceContainer resource) {
            this.resource = resource;
        }

        public String getId() {
            return this.resource.getId();
        }

        public BackgroundGeneratedResourceContainer getResource() {
            return this.resource;
        }

        public abstract void execute();
    }
}

