/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.servlet;

import com.ibm.form.webform.framework.servlet.WebformServletHeader;
import com.ibm.form.webform.framework.servlet.WebformServletOutputStream;
import com.ibm.form.webform.pws.XFormsInstanceDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WebformServletResponse
extends HttpServletResponseWrapper {
    private static final int OUTPUT_METHOD_UNDETERMINED = -1;
    private static final int OUTPUT_METHOD_STREAM = 0;
    private static final int OUTPUT_METHOD_WRITER = 1;
    private int outputMethod = -1;
    private WebformServletOutputStream ourOutputStream = new WebformServletOutputStream();
    private PrintWriter writer = null;
    private WebformServletHeader headerTable = new WebformServletHeader();
    private boolean useHTML = false;
    private boolean useXFDL = false;
    private String filename = null;
    private String templateId = null;
    private List xformsInstances = new ArrayList();
    private String formName = null;
    private String renderMode = null;

    public WebformServletResponse(HttpServletResponse response, String theURIPrefix) {
        super(response);
    }

    public void addDateHeader(String name, long newDate) {
        this.headerTable.addDateHeader(name, newDate);
    }

    public void addHeader(String name, String newValue) {
        this.headerTable.addHeader(name, newValue);
    }

    public void addIntHeader(String name, int newValue) {
        this.headerTable.addIntHeader(name, newValue);
    }

    public boolean containsHeader(String name) {
        return this.headerTable.containsHeader(name);
    }

    public void setDateHeader(String name, long newDate) {
        this.headerTable.setDateHeader(name, newDate);
    }

    public void setHeader(String name, String value) {
        this.headerTable.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headerTable.setIntHeader(name, value);
    }

    public void removeHeader(String name) {
        this.headerTable.removeHeader(name);
    }

    public String getHeaderAsString() {
        return this.headerTable.toString();
    }

    public void setContentType(String type) {
        this.headerTable.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.headerTable.getHeader("Content-Type");
    }

    public void finalizeResponse() throws IOException {
        if (!super.isCommitted()) {
            Enumeration headerKeys = this.headerTable.getHeaderNames();
            while (headerKeys.hasMoreElements()) {
                String headerKey = (String)headerKeys.nextElement();
                if (headerKey.equalsIgnoreCase("content-length")) continue;
                Enumeration headerValueList = this.headerTable.getHeaders(headerKey);
                if (headerKey == null || !headerValueList.hasMoreElements()) continue;
                String headerValue = (String)headerValueList.nextElement();
                if (headerKey.equalsIgnoreCase("transfer-encoding")) continue;
                super.setHeader(headerKey, headerValue);
            }
            String contentType = this.getContentType();
            if (contentType != null) {
                super.setContentType(contentType);
                if (contentType.toLowerCase().startsWith("text/html")) {
                    super.setHeader("Cache-Control", "no-store");
                    super.setHeader("Pragma", "no-cache");
                    super.setDateHeader("Expires", 0L);
                }
            }
            byte[] currentData = this.currentStreamData();
            super.getOutputStream().write(currentData);
        }
    }

    synchronized ServletOutputStream getOutputStreamNoSelect() {
        this.flushWriter();
        return this.ourOutputStream;
    }

    public synchronized ServletOutputStream getOutputStream() throws IllegalStateException {
        if (this.outputMethod == 1) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        if (this.outputMethod == -1) {
            this.outputMethod = 0;
        }
        return this.ourOutputStream;
    }

    public byte[] currentStreamData() {
        this.flushWriter();
        return this.ourOutputStream.toByteArray();
    }

    private void flushWriter() {
        if (this.outputMethod == 1 && this.writer != null) {
            this.writer.flush();
        }
    }

    public void resetOutputStream() {
        this.ourOutputStream.reset();
    }

    public synchronized PrintWriter getWriter() throws IllegalStateException {
        if (this.outputMethod == 0) {
            throw new IllegalStateException("getOutputStream() has already been called");
        }
        if (this.outputMethod == -1) {
            this.outputMethod = 1;
        }
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)((Object)this.ourOutputStream), true);
        }
        return this.writer;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean newValue) {
        this.useHTML = newValue;
        if (this.useHTML) {
            this.useXFDL = false;
        }
    }

    public boolean isUseXFDL() {
        return this.useXFDL;
    }

    public void setUseXFDL(boolean newValue) {
        this.useXFDL = newValue;
        if (this.useXFDL) {
            this.useHTML = false;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String newFilename) {
        this.filename = newFilename;
    }

    public void flushBuffer() throws IOException {
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public List getXFormsInstances() {
        return this.xformsInstances;
    }

    public void addXFormsInstance(String modelId, String nodeRef, int flags, String model) {
        this.xformsInstances.add(new XFormsInstanceDetails(modelId, nodeRef, flags, model));
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setRenderMode(String renderMode) {
        this.renderMode = renderMode;
    }

    public String getRenderMode() {
        return this.renderMode;
    }
}

