/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.servlet;

import com.ibm.form.webform.framework.servlet.WebformServletHeader;
import com.ibm.form.webform.framework.servlet.WebformServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class WebformServletRequest
extends HttpServletRequestWrapper {
    private static final String BROWSER_MSIE_REGEX = "MSIE ([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private static final Pattern pattern = Pattern.compile("MSIE ([0-9]{1,}(\\.[0-9]{1,}){1,})");
    private WebformServletInputStream internalStream;
    private WebformServletHeader headerTable;
    private Hashtable paramTable;
    private String uriPrefix;
    private String method;

    public WebformServletRequest(HttpServletRequest request, String theURIPrefix) throws IOException {
        super(request);
        int bytesRead;
        this.uriPrefix = theURIPrefix;
        this.method = request.getMethod();
        this.paramTable = new Hashtable();
        Enumeration paramList = super.getParameterNames();
        while (paramList.hasMoreElements()) {
            String currentParam = (String)paramList.nextElement();
            this.paramTable.put(currentParam, super.getParameterValues(currentParam));
        }
        this.headerTable = new WebformServletHeader();
        Enumeration headerList = super.getHeaderNames();
        while (headerList.hasMoreElements()) {
            String currentHeader = (String)headerList.nextElement();
            Enumeration headerValueList = super.getHeaders(currentHeader);
            while (headerValueList.hasMoreElements()) {
                this.headerTable.addHeader(currentHeader, (String)headerValueList.nextElement());
            }
        }
        byte[] buf = new byte[32000];
        ServletInputStream superInputStream = super.getInputStream();
        ByteArrayOutputStream fullData = new ByteArrayOutputStream();
        while ((bytesRead = superInputStream.read(buf)) != -1) {
            fullData.write(buf, 0, bytesRead);
        }
        this.setInternalStream(fullData.toByteArray());
        fullData.close();
    }

    public String getFullURL() {
        String returnURL = "";
        returnURL = returnURL + this.getRequestURL();
        if (this.getQueryString() != null) {
            returnURL = returnURL + "?" + this.getQueryString();
        }
        return returnURL;
    }

    public Enumeration getHeaderNames() {
        return this.headerTable.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.headerTable.getHeaders(name);
    }

    public String getHeader(String name) {
        return this.headerTable.getHeader(name);
    }

    public void setHeader(String name, String value) {
        this.headerTable.setHeader(name, value);
    }

    public void removeHeader(String name) {
        this.headerTable.removeHeader(name);
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        return this.headerTable.getDateHeader(name);
    }

    public int getIntHeader(String name) throws NumberFormatException {
        return this.headerTable.getIntHeader(name);
    }

    public String getHeaderAsString() {
        return this.headerTable.toString();
    }

    public void setHeaders(String name, Enumeration options) {
        while (options.hasMoreElements()) {
            this.headerTable.addHeader(name, (String)options.nextElement());
        }
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String newContentType) {
        this.headerTable.setHeader("Content-Type", newContentType);
    }

    public boolean hasViewer() {
        String viewerVersionString = this.getViewerVersion();
        return viewerVersionString != null && !viewerVersionString.equals("none") && !viewerVersionString.equals("unknown");
    }

    private String getUserAgent() {
        return this.getHeader("User-Agent");
    }

    private boolean isBrowserIE() {
        return pattern.matcher(this.getUserAgent()).find();
    }

    public String getViewerVersion() {
        String returnValue = null;
        HttpSession session = this.getSession();
        String value = (String)session.getAttribute(this.uriPrefix + "HasViewer");
        if (value != null && value.length() > 0) {
            returnValue = value;
        } else {
            String userAgent = this.headerTable.getHeader("user-agent");
            if ("UWI_Masque/3.2".equalsIgnoreCase(userAgent)) {
                returnValue = "installed";
            }
            if (returnValue == null) {
                Enumeration acceptHeaders = this.headerTable.getHeaders("Accept");
                while (acceptHeaders != null && acceptHeaders.hasMoreElements()) {
                    String acceptValue = (String)acceptHeaders.nextElement();
                    if (acceptValue == null) continue;
                    int verIndex = acceptValue.indexOf("application/vnd.xfdl; version=\"");
                    if (verIndex != -1) {
                        returnValue = this.processAcceptHeader(acceptValue.substring(verIndex += "application/vnd.xfdl; version=\"".length()));
                        break;
                    }
                    verIndex = acceptValue.indexOf("application/vnd.xfdl; version=");
                    if (verIndex != -1) {
                        returnValue = this.processAcceptHeader(acceptValue.substring(verIndex += "application/vnd.xfdl; version=".length()));
                        break;
                    }
                    if (acceptValue.startsWith("*/*")) continue;
                    if (this.isBrowserIE()) {
                        returnValue = "none";
                        continue;
                    }
                    if ("unknown".equals(value)) {
                        returnValue = "none";
                        continue;
                    }
                    returnValue = "unknown";
                }
            }
            if (returnValue != null) {
                session.setAttribute(this.uriPrefix + "HasViewer", (Object)returnValue);
            }
        }
        return returnValue;
    }

    private String processAcceptHeader(String acceptHeader) {
        String versionRegex = "[0-9]{1,}(\\.[0-9]{1,}){1,}";
        Pattern pattern = null;
        Matcher matcher = null;
        String returnValue = null;
        pattern = Pattern.compile(versionRegex);
        matcher = pattern.matcher(acceptHeader);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            returnValue = acceptHeader.substring(start, end);
        }
        return returnValue;
    }

    public Enumeration getParameterNames() {
        return this.paramTable.keys();
    }

    public String getParameter(String name) {
        String[] paramValue = (String[])this.paramTable.get(name);
        if (paramValue != null) {
            return paramValue[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.paramTable);
    }

    public String[] getParameterValues(String name) {
        return (String[])this.paramTable.get(name);
    }

    public void removePWSParams() {
        Enumeration paramList = this.getParameterNames();
        while (paramList.hasMoreElements()) {
            String currentParameter = (String)paramList.nextElement();
            if (currentParameter == null || !currentParameter.startsWith(this.uriPrefix)) continue;
            this.paramTable.remove(currentParameter);
        }
    }

    public void addPWSParams() {
        Enumeration paramList = super.getParameterNames();
        while (paramList.hasMoreElements()) {
            String currentParameter = (String)paramList.nextElement();
            if (currentParameter == null || !currentParameter.startsWith(this.uriPrefix)) continue;
            this.paramTable.put(currentParameter, super.getParameterValues(currentParameter));
        }
    }

    public void setInternalStream(byte[] newData) throws IOException {
        if (this.internalStream != null) {
            this.internalStream.close();
            this.internalStream = null;
        }
        this.internalStream = new WebformServletInputStream(newData);
    }

    public ServletInputStream getInputStream() {
        return this.internalStream;
    }

    public BufferedReader getReader() {
        return this.internalStream.getReader();
    }

    public boolean allowPassToClient() {
        boolean returnValue = false;
        if (this.getParameter(this.uriPrefix + "Action") == null || this.isSubmitDoneTranslatorRequest()) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isSubmitDoneTranslatorRequest() {
        String dialogAction;
        boolean returnValue = false;
        String actionType = this.getParameter(this.uriPrefix + "Action");
        if (actionType != null && (actionType.equalsIgnoreCase("submit") || actionType.equalsIgnoreCase("done"))) {
            returnValue = true;
        } else if ("wizardAction".equalsIgnoreCase(actionType)) {
            String buttonAction = this.getParameter(this.uriPrefix + "WizardButtonAction");
            if ("submit".equalsIgnoreCase(buttonAction) || "done".equalsIgnoreCase(buttonAction)) {
                returnValue = true;
            }
        } else if ("dialog".equalsIgnoreCase(actionType) && ("submit".equalsIgnoreCase(dialogAction = this.getParameter(this.uriPrefix + "DialogAction")) || "done".equalsIgnoreCase(dialogAction))) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isSubmitDoneOpenTranslatorRequest() {
        boolean returnValue = false;
        String actionType = this.getParameter(this.uriPrefix + "Action");
        if (this.isSubmitDoneTranslatorRequest() || "open".equalsIgnoreCase(actionType)) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean allowBounce() {
        boolean returnValue = false;
        String action = this.getParameter(this.uriPrefix + "Action");
        String bounce = this.getParameter(this.uriPrefix + "Bounce");
        if (action == null && bounce == null || this.isSubmitDoneOpenTranslatorRequest()) {
            returnValue = true;
        }
        return returnValue;
    }

    public String getFilename() {
        return super.getParameter(this.uriPrefix + "FormName");
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

