/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.servlet;

import com.ibm.form.webform.logging.Logger;
import com.ibm.form.webform.logging.VectorMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public class WebformServletLogger
extends Logger {
    public static final String EXCEPTION_CODE = "Exception";
    private static final String USERINFO_TAG = "UserInfo";
    private static final String EXCEPTION_TIMESTAMP = "ExceptionTimestamp";
    private static final String URL_TAG = "URL";
    private static final String RECONNECTION_DELAY = "5000";
    private int logLevel;

    public WebformServletLogger(int logLevelToUse) {
        super("servlet");
        String hostName = null;
        this.logLevel = logLevelToUse;
        try {
            hostName = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException UHEex) {
            this.writeLog_0("Failed to get hostname", null);
            hostName = "unknownHostName";
        }
        super.setContext(hostName);
    }

    public void configure(String logServerHostname, String logServerPort) {
        boolean isDebugEnabled = this.logLevel > 1;
        String debugLevelStr = isDebugEnabled ? "ALL" : "OFF";
        Properties p = new Properties();
        p.setProperty("log4j.appender.A1", "org.apache.log4j.net.SocketAppender");
        p.setProperty("log4j.appender.A1.RemoteHost", logServerHostname);
        p.setProperty("log4j.appender.A1.Port", logServerPort);
        p.setProperty("log4j.appender.A1.ReconnectionDelay", RECONNECTION_DELAY);
        p.setProperty("log4j.category.servlet_debug", debugLevelStr + "#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.servlet_debug", "false");
        p.setProperty("log4j.category.servlet_error", "ALL#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.servlet_error", "false");
        p.setProperty("log4j.category.servlet_operational", "ALL#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.servlet_operational", "false");
        super.configure(p);
    }

    public void writeThrowableErrorLog(Throwable thrown, String userInfo) {
        if (this.isLoggable(3)) {
            String thrownString = "";
            if (null != thrown) {
                thrownString = thrown.toString();
            }
            VectorMap map = new VectorMap();
            map.put((Object)USERINFO_TAG, (Object)(userInfo == null ? "" : userInfo));
            this.writeErrorLog(thrownString, Logger.stackTraceToString((Throwable)thrown), "", EXCEPTION_CODE, (Map)map);
        }
    }

    public void writeThrowableErrorLog(Throwable thrown, String userInfo, long timestamp) {
        if (this.isLoggable(3)) {
            String thrownString = "";
            if (null != thrown) {
                thrownString = thrown.toString();
            }
            VectorMap map = new VectorMap();
            map.put((Object)USERINFO_TAG, (Object)(userInfo == null ? "" : userInfo));
            map.put((Object)EXCEPTION_TIMESTAMP, (Object)("" + timestamp));
            this.writeErrorLog(thrownString, Logger.stackTraceToString((Throwable)thrown), "", EXCEPTION_CODE, (Map)map);
        }
    }

    public void writeLog_0(String traceMsg, String userInfo) {
        VectorMap map = new VectorMap();
        map.put((Object)USERINFO_TAG, (Object)(userInfo == null ? "" : userInfo));
        if (this.logLevel >= 0) {
            super.writeErrorLog(traceMsg, "", "", "", (Map)map);
        }
    }

    public void writeLog_1(String traceMsg, String userInfo, String urlHit) {
        VectorMap map = new VectorMap();
        map.put((Object)USERINFO_TAG, (Object)(userInfo == null ? "" : userInfo));
        map.put((Object)URL_TAG, (Object)(urlHit == null ? "" : urlHit));
        if (this.logLevel >= 1) {
            super.writeOperationalLog(traceMsg, "", (Map)map);
        }
    }

    public void writeLog_1(String traceMsg) {
        this.writeLog_1(traceMsg, null, null);
    }

    public void writeLog_2(String traceMsg, String userInfo, String data) {
        VectorMap map = new VectorMap();
        map.put((Object)USERINFO_TAG, (Object)(userInfo == null ? "" : userInfo));
        if (this.logLevel >= 2) {
            super.writeDebugLog(traceMsg, data, (Map)map);
        }
    }

    public void writeLog_3(String traceMsg, String data) {
        if (this.logLevel >= 3) {
            super.writeDebugLog(traceMsg, data, null);
        }
    }

    public void writeLog_3(String traceMsg) {
        this.writeLog_3(traceMsg, null);
    }
}

