/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.servlet;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class WebformServletHeader {
    private Hashtable headerTable = new Hashtable();

    public String toString() {
        String returnValue = "";
        Enumeration headerContentList = this.getHeaderNames();
        while (headerContentList.hasMoreElements()) {
            String currentHeader = (String)headerContentList.nextElement();
            Enumeration headerValue = this.getHeaders(currentHeader);
            while (headerValue.hasMoreElements()) {
                returnValue = returnValue + currentHeader + ":  " + (String)headerValue.nextElement() + "\n";
            }
        }
        return returnValue;
    }

    public void removeHeader(String name) {
        if (name != null && this.containsHeader(name.toLowerCase())) {
            this.headerTable.remove(name.toLowerCase());
        }
    }

    public void setHeader(String name, String value) {
        if (name != null) {
            String[] newValue = new String[]{value};
            this.headerTable.put(name.toLowerCase(), newValue);
        }
    }

    public void addHeader(String name, String newValue) {
        if (name != null) {
            String[] currentHeaderValue = (String[])this.headerTable.get(name);
            if (currentHeaderValue == null) {
                this.setHeader(name, newValue);
            } else {
                String[] newHeaderValue = new String[currentHeaderValue.length + 1];
                for (int i = 0; i < currentHeaderValue.length; ++i) {
                    newHeaderValue[i] = currentHeaderValue[i];
                }
                newHeaderValue[i] = newValue;
                this.headerTable.put(name.toLowerCase(), newHeaderValue);
            }
        }
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public void setDateHeader(String name, long newDate) {
        if (name != null && newDate >= 0L) {
            this.setHeader(name, Long.toString(newDate));
        }
    }

    public void addDateHeader(String name, long newDate) {
        if (name != null && newDate >= 0L) {
            this.addHeader(name, Long.toString(newDate));
        }
    }

    public void setIntHeader(String name, int newValue) {
        if (name != null) {
            this.setHeader(name, Integer.toString(newValue));
        }
    }

    public void addIntHeader(String name, int newValue) {
        if (name != null) {
            this.addHeader(name, Integer.toString(newValue));
        }
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        long returnValue = -1L;
        try {
            String headerValue = this.getHeader(name);
            if (headerValue != null) {
                returnValue = DateFormat.getDateInstance().parse(headerValue).getTime();
            }
        }
        catch (ParseException PEex) {
            throw new IllegalArgumentException();
        }
        return returnValue;
    }

    public String getHeader(String name) {
        String[] paramValue;
        if (name != null && (paramValue = (String[])this.headerTable.get(name.toLowerCase())) != null) {
            return paramValue[0];
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        String[] headerValueArray;
        if (name != null && (headerValueArray = (String[])this.headerTable.get(name.toLowerCase())) != null) {
            return Collections.enumeration(Arrays.asList((Object[])headerValueArray));
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        return this.headerTable.keys();
    }

    public int getIntHeader(String name) throws NumberFormatException {
        int returnValue = -1;
        String headerValue = this.getHeader(name);
        if (headerValue != null) {
            returnValue = Integer.parseInt(headerValue);
        }
        return returnValue;
    }
}

