/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.servlet;

import com.ibm.form.webform.framework.FrameworkUtils;
import com.ibm.form.webform.framework.HttpResource;
import com.ibm.form.webform.framework.HttpResourceAccessCredentials;
import com.ibm.form.webform.framework.HttpResourceProvider;
import com.ibm.form.webform.framework.TemplateManager;
import com.ibm.form.webform.framework.XFormsInstancePart;
import com.ibm.form.webform.framework.servlet.WebformServletLogger;
import com.ibm.form.webform.framework.servlet.WebformServletRequest;
import com.ibm.form.webform.framework.servlet.WebformServletResponse;
import com.ibm.form.webform.framework.servlet.WebformServletSessionBean;
import com.ibm.form.webform.logging.Logger;
import com.ibm.form.webform.pws.UTF8URLDecoder;
import com.ibm.form.webform.pws.UTF8URLEncoder;
import com.ibm.form.webform.pws.XFormsInstanceDetails;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.ResourceProvider;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.CacheManager;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class IBMWorkplaceFormsServerServlet
extends HttpServlet {
    private static final long serialVersionUID = -3564188843126279171L;
    public static final int VIEWER_VIEWER = 0;
    public static final int VIEWER_WEBFORM = 1;
    private String translatorLocation = null;
    private String uriPrefix = null;
    private WebformServletLogger logger = null;
    private String tempDirectoryPath = null;
    private int logLevel = 0;
    private int maxConnections = 250;
    private boolean disableViewerDetection = false;
    private boolean disableResourceCache = true;
    private ResourceProvider httpResourceProvider = null;
    protected TemplateManager templateManager = null;
    private MultiThreadedHttpConnectionManager connectionManager = null;

    public void init() throws ServletException {
        try {
            String maxConValue;
            String logServerPort;
            String logServerName;
            String logLevelValue;
            super.init();
            String disableViewerDetectionStr = this.getInitParameter("disableViewerDetection");
            if (disableViewerDetectionStr != null) {
                this.disableViewerDetection = Boolean.valueOf(disableViewerDetectionStr);
            }
            if ((logLevelValue = this.getInitParameter("logLevel")) != null) {
                this.logLevel = Integer.parseInt(logLevelValue);
            }
            if ((logServerName = this.getInitParameter("logServerName")) == null) {
                logServerName = "localhost";
            }
            if ((logServerPort = this.getInitParameter("logServerPort")) == null) {
                logServerPort = "4560";
            }
            this.logger = new WebformServletLogger(this.logLevel);
            this.logger.configure(logServerName, logServerPort);
            this.uriPrefix = this.getInitParameter("uriPrefix");
            if (this.uriPrefix == null) {
                this.uriPrefix = "pws";
            }
            this.translatorLocation = this.getInitParameter("translatorLocation");
            if (this.translatorLocation == null) {
                throw new ServletException("TranslatorLocation must be specified in the web.xml");
            }
            String verMapFileLocation = this.getInitParameter("versionMappingFilePath");
            if (verMapFileLocation == null) {
                verMapFileLocation = this.getServletContext().getRealPath("/") + File.separator + "mapping.properties";
            }
            FrameworkUtils.processMappingConfig(verMapFileLocation);
            this.tempDirectoryPath = System.getProperty("java.io.tmpdir") + "/";
            String disableResourceCacheStr = this.getInitParameter("disableResourceCache");
            this.disableResourceCache = disableResourceCacheStr == null ? true : Boolean.valueOf(disableResourceCacheStr);
            if (!this.disableResourceCache) {
                String cachingSizeThresholdText = this.getInitParameter("cachingSizeThreshold_bytes");
                this.httpResourceProvider = new HttpResourceProvider(this.uriPrefix, CacheManager.getInstance(), (Logger)this.logger, cachingSizeThresholdText);
            }
            if ((maxConValue = this.getInitParameter("maxConnections")) != null) {
                this.maxConnections = Integer.parseInt(maxConValue);
            }
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams conMgrParams = new HttpConnectionManagerParams();
            conMgrParams.setDefaultMaxConnectionsPerHost(this.maxConnections);
            conMgrParams.setMaxTotalConnections(this.maxConnections);
            this.connectionManager.setParams(conMgrParams);
            this.templateManager = new TemplateManager(this.translatorLocation);
            this.logger.writeLog_3("Initialization Successful");
        }
        catch (Exception ex) {
            this.logger.writeThrowableErrorLog(ex);
            throw new ServletException(ex.getMessage());
        }
    }

    private int copyInputToOutputAndClose(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[32000];
        int bytesRead = -1;
        int totalBytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            os.write(buf, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        is.close();
        return totalBytesRead;
    }

    private void retrieveToolbeltForm(WebformServletRequest request, WebformServletResponse response) throws ServletException, IOException {
        String connectURL = null;
        GetMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        try {
            boolean isNotModified;
            connectURL = this.translatorLocation + "/Translate?" + this.uriPrefix + "Action=toolbelt";
            connectURL = connectURL + "&" + this.uriPrefix + "UserInfo=" + this.utf8URLEncode(request.getRemoteHost()) + (request.getRemoteUser() == null ? "" : ":" + this.utf8URLEncode(request.getRemoteUser()));
            method = new GetMethod(connectURL);
            String referer = request.getRequestURI();
            method.setRequestHeader("uriprefix", this.uriPrefix);
            method.setRequestHeader("x-ws-referer", referer);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerValueSet = "";
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (headerName == null || headerValue == null || headerName.equalsIgnoreCase("content-type")) continue;
                    if (headerValueSet.length() > 0) {
                        headerValueSet = headerValueSet + ",";
                    }
                    headerValueSet = headerValueSet + headerValue;
                }
                if (FrameworkUtils.isRestrictedHeader(headerName)) continue;
                method.setRequestHeader(headerName, headerValueSet);
            }
            int translatorResponseCode = client.executeMethod((HttpMethod)method);
            header = method.getResponseHeader("content-type");
            if (header != null) {
                response.setContentType(header.getValue());
            }
            boolean bl = isNotModified = translatorResponseCode == 412 || translatorResponseCode == 304;
            if (isNotModified) {
                response.setStatus(304);
            } else {
                response.setStatus(translatorResponseCode);
            }
            if (translatorResponseCode != 500) {
                Header[] responseHeaders = method.getResponseHeaders();
                for (int i = 0; i < responseHeaders.length; ++i) {
                    if (responseHeaders[i].getName() == null || "cookie".equalsIgnoreCase(responseHeaders[i].getName()) || "set-cookie".equalsIgnoreCase(responseHeaders[i].getName()) || FrameworkUtils.isRestrictedHeader(responseHeaders[i].getName())) continue;
                    response.setHeader(responseHeaders[i].getName(), responseHeaders[i].getValue());
                }
            }
            if (!isNotModified) {
                this.copyInputToOutputAndClose(method.getResponseBodyAsStream(), (OutputStream)response.getOutputStreamNoSelect());
            }
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ProtocolException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void callTranslator(WebformServletRequest request, WebformServletResponse response) throws ServletException, IOException {
        block91: {
            block87: {
                block88: {
                    openRequest = false;
                    method /* !! */  = null;
                    header = null;
                    client = new HttpClient((HttpConnectionManager)this.connectionManager);
                    actionType = request.getParameter(this.uriPrefix + "Action");
                    contentType = request.getContentType();
                    if (contentType != null && contentType.toLowerCase().startsWith("application/vnd.xfdl")) {
                        openRequest = true;
                    }
                    isTemplateOpenRequest = false;
                    isNonTemplateOpenRequest = false;
                    requestMethod = openRequest != false ? "POST" : request.getMethod();
                    connectURL = null;
                    params = new ArrayList<NameValuePair>();
                    try {
                        try {
                            if (contentType != null && contentType.toLowerCase().startsWith("application/vnd.xfdl")) {
                                openRequest = true;
                            }
                            if (openRequest) {
                                viewer = this.getViewerForResponse(request, response);
                                if (viewer == 1) {
                                    connectURL = this.translatorLocation + "/Translate?" + this.uriPrefix + "Action=open";
                                } else if (viewer == 0) {
                                    connectURL = this.translatorLocation + "/Translate?" + this.uriPrefix + "Action=opensave&" + this.uriPrefix + "Inline=true";
                                }
                                fileName = response.getFilename();
                                templateId = response.getTemplateId();
                                customFormName = response.getFormName();
                                if (templateId != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "TemplateId=" + this.utf8URLEncode(templateId);
                                    isTemplateOpenRequest = true;
                                }
                                if (fileName != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "FormName=" + this.utf8URLEncode(fileName);
                                    if (!isTemplateOpenRequest) {
                                        isNonTemplateOpenRequest = true;
                                    }
                                }
                                if (customFormName != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "customFormName=" + this.utf8URLEncode(customFormName);
                                }
                                bean = FrameworkUtils.getSessionBean((HttpServletRequest)request);
                                bean.setRenderMode(response.getRenderMode());
                                if (bean.getRenderMode() != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "RenderMode=" + bean.getRenderMode();
                                }
                                break block87;
                            }
                            if ("Resource".equalsIgnoreCase(actionType)) {
                                connectURL = this.translatorLocation + request.getParameter(this.uriPrefix + "Location");
                                break block87;
                            }
                            if ("Localize".equalsIgnoreCase(actionType)) {
                                connectURL = this.translatorLocation + "/ResourceService?" + this.uriPrefix + "Action=Localize&" + this.uriPrefix + "GID=" + request.getParameter(this.uriPrefix + "GID");
                                if (request.getParameter("lang") != null) {
                                    connectURL = connectURL + "&lang=" + request.getParameter("lang");
                                }
                                break block87;
                            }
                            if ("Plugin".equalsIgnoreCase(actionType)) {
                                connectURL = this.translatorLocation + "/ResourceService" + "?" + this.uriPrefix + "Action=Plugin" + "&" + this.uriPrefix + "Type=" + request.getParameter(this.uriPrefix + "Type") + "&" + this.uriPrefix + "Location=" + request.getParameter(this.uriPrefix + "Location");
                                break block87;
                            }
                            if ("Image".equalsIgnoreCase(actionType) || "Display".equalsIgnoreCase(actionType) || "Extract".equalsIgnoreCase(actionType) || "File".equalsIgnoreCase(actionType)) {
                                connectURL = this.translatorLocation + "/ResourceService?" + this.uriPrefix + "Action=" + actionType;
                                if (request.getParameter(this.uriPrefix + "FormInstance") != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "FormInstance=" + request.getParameter(this.uriPrefix + "FormInstance");
                                }
                                if (request.getParameter(this.uriPrefix + "TemplateId") != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "TemplateId=" + URLEncoder.encode(request.getParameter(this.uriPrefix + "TemplateId"), "UTF-8");
                                }
                                if (request.getParameter(this.uriPrefix + "FileName") != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "FileName=" + URLEncoder.encode(request.getParameter(this.uriPrefix + "FileName"), "UTF-8");
                                }
                                if (request.getParameter(this.uriPrefix + "Revision") != null) {
                                    connectURL = connectURL + "&" + this.uriPrefix + "Revision=" + request.getParameter(this.uriPrefix + "Revision");
                                }
                                break block87;
                            }
                            if ("Format".equalsIgnoreCase(actionType)) {
                                connectURL = this.translatorLocation + "/Translate?";
                                request.setCharacterEncoding("UTF-8");
                                parameterList = request.getParameterNames();
                                firstParam = true;
                                break block88;
                            }
                            connectURL = this.translatorLocation + "/Translate?fwURL=" + this.utf8URLEncode(request.getRequestURL().toString());
                            connectURL = connectURL + "&" + this.uriPrefix + "RenderMode=" + FrameworkUtils.getSessionBean((HttpServletRequest)request).getRenderMode();
                            doPostParams = "POST".equalsIgnoreCase(request.getMethod()) != false && request.getInputStream().available() == 0;
                            parameterList = request.getParameterNames();
                            while (parameterList.hasMoreElements()) {
                                currentParam = (String)parameterList.nextElement();
                                paramValues = request.getParameterValues(currentParam);
                                if (paramValues == null) continue;
                                for (i = 0; i < paramValues.length; ++i) {
                                    paramValue = paramValues[i];
                                    if (doPostParams) {
                                        params.add(new NameValuePair(currentParam, paramValue));
                                        continue;
                                    }
                                    connectURL = connectURL + "&" + currentParam + "=" + this.utf8URLEncode(paramValue);
                                }
                            }
                            break block87;
                        }
                        catch (MalformedURLException e) {
                            throw new ServletException((Throwable)e);
                        }
                        catch (ProtocolException e) {
                            throw new ServletException((Throwable)e);
                        }
                        catch (IOException e) {
                            throw new ServletException((Throwable)e);
                        }
                        catch (Exception e) {
                            throw new ServletException((Throwable)e);
                        }
                    }
                    catch (Throwable var27_62) {
                        var28_42 = null;
                        try {
                            if (method /* !! */  == null) throw var27_62;
                            method /* !! */ .releaseConnection();
                            throw var27_62;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var27_62;
                    }
                }
                while (parameterList.hasMoreElements()) {
                    currentParam = (String)parameterList.nextElement();
                    paramValues = request.getParameterValues(currentParam);
                    if (paramValues == null) continue;
                    for (i = 0; i < paramValues.length; ++i) {
                        paramValue = paramValues[i];
                        if (!firstParam) {
                            connectURL = connectURL + "&";
                        } else {
                            firstParam = false;
                        }
                        connectURL = connectURL + currentParam + "=" + this.utf8URLEncode(paramValue);
                    }
                }
            }
            if (actionType == null || !actionType.equalsIgnoreCase("Resource") && !actionType.equalsIgnoreCase("Plugin") && !actionType.equalsIgnoreCase("Localize")) {
                connectURL = connectURL + "&" + this.uriPrefix + "UserInfo=" + this.utf8URLEncode(request.getRemoteHost()) + (request.getRemoteUser() == null ? "" : ":" + this.utf8URLEncode(request.getRemoteUser()));
            }
            uri = new URI(connectURL.toString());
            connectURL = uri.normalize().toString();
            useCache = false;
            if ("GET".equalsIgnoreCase(request.getMethod()) && ("Resource".equalsIgnoreCase(actionType) || "Localize".equalsIgnoreCase(actionType) || "Image".equalsIgnoreCase(actionType))) {
                useCache = true;
            }
            if (useCache && !this.disableResourceCache) {
                block93: {
                    block92: {
                        block89: {
                            block90: {
                                if (!FrameworkUtils.isCssFile(connectURL) || null == (content = FrameworkUtils.getCorrectedCssFile((HttpServletRequest)request))) break block89;
                                response.setContentType("text/css");
                                createdDate = FrameworkUtils.getCssCacheFileCreatedTime((HttpServletRequest)request);
                                if (!FrameworkUtils.isCachedInBrowser((HttpServletRequest)request)) break block90;
                                ifModifiedSinceDate = FrameworkUtils.getIfModifiedSinceDate((HttpServletRequest)request);
                                if (createdDate == null || ifModifiedSinceDate == null || createdDate.after(ifModifiedSinceDate)) break block90;
                                response.setStatus(304);
                                var28_37 = null;
                                ** try [egrp 6[TRYBLOCK] [42 : 3413->3428)] { 
lbl140:
                                // 1 sources

                                if (method /* !! */  == null) return;
                                method /* !! */ .releaseConnection();
                                return;
lbl143:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                            response.addHeader("Last-Modified", FrameworkUtils.formatRfcString(createdDate));
                            this.copyInputToOutputAndClose(new ByteArrayInputStream(content.getBytes()), (OutputStream)response.getOutputStreamNoSelect());
                            var28_38 = null;
                            ** try [egrp 6[TRYBLOCK] [42 : 3413->3428)] { 
lbl154:
                            // 1 sources

                            if (method /* !! */  == null) return;
                            method /* !! */ .releaseConnection();
                            return;
lbl157:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        resource = (HttpResource)this.httpResourceProvider.get(new URI(connectURL), (ResourceAccessCredentials)new HttpResourceAccessCredentials((HttpServletRequest)request));
                        if (resource == null) break block91;
                        if (!FrameworkUtils.isCachedValidInBrowser((HttpServletRequest)request, resource)) break block92;
                        response.setStatus(304);
                        var28_39 = null;
                        ** try [egrp 6[TRYBLOCK] [42 : 3413->3428)] { 
lbl169:
                        // 1 sources

                        if (method /* !! */  == null) return;
                        method /* !! */ .releaseConnection();
                        return;
lbl172:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    try {
                        response.setStatus(resource.getResponseCode());
                        i = resource.getHeaderKeys().iterator();
                        while (i.hasNext()) {
                            key = (String)i.next();
                            value = resource.getHeader(key);
                            response.addHeader(key, value);
                        }
                        break block93;
                    }
                    catch (UnhandledResourceTypeException e) {
                    }
                    catch (InvalidCredentialsException e) {
                    }
                    catch (URISyntaxException e) {
                    }
                    catch (ResourceSystemError e) {
                        // empty catch block
                    }
                    break block91;
                }
                if (resource.getData() != null) {
                    if (!FrameworkUtils.isCssFile(connectURL)) {
                        this.copyInputToOutputAndClose(new ByteArrayInputStream(resource.getData()), (OutputStream)response.getOutputStreamNoSelect());
                    } else {
                        is = new ByteArrayInputStream(resource.getData());
                        isr = new InputStreamReader(is);
                        sr = new BufferedReader(isr);
                        sb = new StringBuffer();
                        line = "";
                        while ((line = sr.readLine()) != null) {
                            sb.append(line);
                        }
                        sr.close();
                        isr.close();
                        is.close();
                        value = sb.toString();
                        value = FrameworkUtils.substituteCssRelativePaths(request.getFullURL(), "Location=", value);
                        response.setContentType("text/css");
                        this.copyInputToOutputAndClose(new ByteArrayInputStream(value.getBytes()), (OutputStream)response.getOutputStreamNoSelect());
                    }
                }
                var28_40 = null;
                ** try [egrp 6[TRYBLOCK] [42 : 3413->3428)] { 
lbl220:
                // 1 sources

                if (method /* !! */  == null) return;
                method /* !! */ .releaseConnection();
                return;
lbl223:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
        }
        this.logger.writeLog_3("Calling translator with url", connectURL);
        method /* !! */  = "POST".equalsIgnoreCase(requestMethod) != false ? new PostMethod(connectURL) : new GetMethod(connectURL);
        headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerName = (String)headerNames.nextElement();
            if (headerName == null) continue;
            if ("cookie".equalsIgnoreCase(headerName)) {
                method /* !! */ .setRequestHeader("x-browser-cookie", request.getHeader("cookie"));
            }
            if ("content-length".equalsIgnoreCase(headerName)) {
                method /* !! */ .setRequestHeader("Content-Length", Integer.toString(request.getInputStream().available()));
                continue;
            }
            if (FrameworkUtils.isRestrictedHeader(headerName)) continue;
            headerValues = request.getHeaders(headerName);
            headerValueSet = "";
            while (headerValues.hasMoreElements()) {
                headerValue = (String)headerValues.nextElement();
                if (headerValue == null || headerValue.length() <= 0) continue;
                if (headerValueSet.length() > 0) {
                    headerValueSet = headerValueSet + ",";
                }
                headerValueSet = headerValueSet + headerValue;
            }
            method /* !! */ .setRequestHeader(headerName, headerValueSet);
        }
        cookieHeader = FrameworkUtils.getSessionBean((HttpServletRequest)request).getTranslatorCookieHeader();
        if (cookieHeader != null) {
            method /* !! */ .setRequestHeader("cookie", cookieHeader);
        }
        referer = request.getRequestURI();
        method /* !! */ .setRequestHeader("uriprefix", this.uriPrefix);
        method /* !! */ .setRequestHeader("x-ws-referer", referer);
        this.logger.writeLog_3("uriprefix", this.uriPrefix);
        this.logger.writeLog_3("Referer", referer);
        if (requestMethod.equalsIgnoreCase("POST")) {
            postMethod = method /* !! */ ;
            if (isNonTemplateOpenRequest) {
                reqInStream = request.getInputStream();
                if (reqInStream.available() > 0) {
                    postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)reqInStream));
                }
                postMethod.setRequestHeader("Content-Type", "application/vnd.xfdl");
            } else if (isTemplateOpenRequest) {
                xFormsInstances = response.getXFormsInstances();
                if (xFormsInstances.size() > 0) {
                    parts = new XFormsInstancePart[xFormsInstances.size()];
                    for (i = 0; i < xFormsInstances.size(); ++i) {
                        details = (XFormsInstanceDetails)xFormsInstances.get(i);
                        parts[i] = new XFormsInstancePart(details);
                    }
                    postMethod.removeRequestHeader("Content-Type");
                    postMethod.removeRequestHeader("Content-Length");
                    postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity((Part[])parts, postMethod.getParams()));
                } else {
                    postMethod.setRequestHeader("Content-Type", "application/vnd.xfdl");
                }
            } else {
                reqInStream = request.getInputStream();
                if (reqInStream.available() > 0) {
                    postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)reqInStream));
                } else if (params.size() > 0) {
                    paramArray = new NameValuePair[params.size()];
                    for (i = 0; i < params.size(); ++i) {
                        paramArray[i] = (NameValuePair)params.get(i);
                    }
                    postMethod.setRequestBody(paramArray);
                    postMethod.removeRequestHeader("content-length");
                }
            }
        }
        translatorResponseCode = client.executeMethod((HttpMethod)method /* !! */ );
        header = method /* !! */ .getResponseHeader("content-type");
        if (header != null) {
            response.setContentType(header.getValue());
        }
        if ((header = method /* !! */ .getResponseHeader("set-cookie")) != null) {
            FrameworkUtils.getSessionBean((HttpServletRequest)request).setTranslatorCookieHeader(header.getValue());
        }
        v0 = isNotModified = translatorResponseCode == 412 || translatorResponseCode == 304;
        if (isNotModified) {
            response.setStatus(304);
        } else {
            response.setStatus(translatorResponseCode);
        }
        if (translatorResponseCode != 500) {
            responseHeaders = method /* !! */ .getResponseHeaders();
            for (i = 0; i < responseHeaders.length; ++i) {
                if (responseHeaders[i].getName() == null || "cookie".equalsIgnoreCase(responseHeaders[i].getName()) || "set-cookie".equalsIgnoreCase(responseHeaders[i].getName()) || FrameworkUtils.isRestrictedHeader(responseHeaders[i].getName())) continue;
                response.setHeader(responseHeaders[i].getName(), responseHeaders[i].getValue());
            }
        }
        if (!isNotModified && (responseBodyStream = method /* !! */ .getResponseBodyAsStream()) != null) {
            if (!FrameworkUtils.isCssFile(connectURL)) {
                this.copyInputToOutputAndClose(responseBodyStream, (OutputStream)response.getOutputStreamNoSelect());
            } else {
                sr = new BufferedReader(new InputStreamReader(responseBodyStream));
                sb = new StringBuffer();
                line = "";
                while ((line = sr.readLine()) != null) {
                    sb.append(line);
                }
                sr.close();
                responseBodyStream.close();
                value = FrameworkUtils.substituteCssRelativePaths(request.getFullURL(), "Location=", sb.toString());
                is = new ByteArrayInputStream(value.getBytes());
                response.setContentType("text/css");
                this.copyInputToOutputAndClose(is, (OutputStream)response.getOutputStreamNoSelect());
            }
        }
        var28_41 = null;
        try {}
        catch (Exception e) {
            return;
        }
        if (method /* !! */  == null) return;
        method /* !! */ .releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes = null;
        FileInputStream is = null;
        try {
            int bytesRead;
            is = new FileInputStream(file);
            byte[] buf = new byte[32000];
            ByteArrayOutputStream fullData = new ByteArrayOutputStream();
            while ((bytesRead = ((InputStream)is).read(buf)) != -1) {
                fullData.write(buf, 0, bytesRead);
            }
            bytes = fullData.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException ioe2) {}
        return bytes;
    }

    private boolean checkForBounce(WebformServletRequest myRequest) throws ServletException, IOException {
        return myRequest.getParameter(this.uriPrefix + "Bounce") != null;
    }

    private void handleBounce(WebformServletRequest myRequest, WebformServletResponse myResponse) throws ServletException, IOException {
        HttpSession session = myRequest.getSession();
        String currentVersion = (String)session.getAttribute(this.uriPrefix + "HasViewer");
        if (currentVersion == null || currentVersion.equals("unknown")) {
            String viewerVersion = myRequest.getParameter(this.uriPrefix + "ViewerInstalled");
            if (viewerVersion == null || viewerVersion.length() == 0) {
                viewerVersion = currentVersion.equals("unknown") ? "none" : "unknown";
            }
            session.setAttribute(this.uriPrefix + "HasViewer", (Object)viewerVersion);
        }
        String bounce = myRequest.getParameter(this.uriPrefix + "Bounce");
        File cachedFile = new File(this.tempDirectoryPath + bounce + ".tmp");
        if (cachedFile.length() > 0L) {
            myRequest.setInternalStream(IBMWorkplaceFormsServerServlet.getBytesFromFile(cachedFile));
        }
        cachedFile.delete();
        File propFile = new File(this.tempDirectoryPath + bounce + ".properties");
        if (!propFile.exists()) {
            return;
        }
        Enumeration acceptHeaders = myRequest.getHeaders("accept");
        Enumeration<?> names = myRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String header = names.nextElement().toString();
            myRequest.removeHeader(header);
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propFile);
        props.load(in);
        in.close();
        propFile.delete();
        names = props.propertyNames();
        while (names.hasMoreElements()) {
            String header = names.nextElement().toString();
            String value = props.getProperty(header);
            if (header != null && header.equals(this.uriPrefix + "Method")) {
                myRequest.setMethod(value);
            }
            myRequest.setHeader(header, value);
        }
        myRequest.removeHeader("accept");
        myRequest.setHeaders("accept", acceptHeaders);
        WebformServletSessionBean sessionBean = FrameworkUtils.getSessionBean((HttpServletRequest)myRequest);
        HashMap requestAttributes = (HashMap)sessionBean.getRequestAttributes();
        if (requestAttributes != null) {
            Set attrKeys = requestAttributes.keySet();
            Iterator keyIter = attrKeys.iterator();
            while (keyIter.hasNext()) {
                String attrName = (String)keyIter.next();
                if (attrName == null) continue;
                myRequest.setAttribute(attrName, requestAttributes.get(attrName));
            }
            sessionBean.setRequestAttributes(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createBounce(WebformServletRequest myRequest, WebformServletResponse myResponse) throws ServletException, IOException {
        boolean bounced = false;
        if (!myRequest.allowBounce()) {
            return bounced;
        }
        File file = File.createTempFile(this.uriPrefix, ".tmp");
        String fileName = file.getName();
        String bounce = fileName.substring(0, fileName.length() - 4);
        FileOutputStream fOut = new FileOutputStream(file);
        if ("POST".equals(myRequest.getMethod())) {
            try {
                this.copyInputToOutputAndClose((InputStream)myRequest.getInputStream(), fOut);
            }
            finally {
                fOut.close();
            }
        } else {
            fOut.close();
        }
        HashMap<String, Object> requestAttributes = new HashMap<String, Object>();
        Enumeration attrEnum = myRequest.getAttributeNames();
        while (attrEnum.hasMoreElements()) {
            String attrName = (String)attrEnum.nextElement();
            if (attrName == null) continue;
            requestAttributes.put(attrName, myRequest.getAttribute(attrName));
        }
        FrameworkUtils.getSessionBean((HttpServletRequest)myRequest).setRequestAttributes(requestAttributes);
        Enumeration headerNames = myRequest.getHeaderNames();
        Properties props = new Properties();
        while (headerNames.hasMoreElements()) {
            String header = headerNames.nextElement().toString();
            Enumeration values = myRequest.getHeaders(header);
            if (!values.hasMoreElements()) continue;
            String value = values.nextElement().toString();
            while (values.hasMoreElements()) {
                value = value + ", " + values.nextElement().toString();
            }
            ((Hashtable)props).put(header, value);
        }
        ((Hashtable)props).put(this.uriPrefix + "Method", myRequest.getMethod());
        File propFile = new File(this.tempDirectoryPath + bounce + ".properties");
        FileOutputStream out = new FileOutputStream(propFile);
        props.store(out, bounce);
        out.close();
        StringBuffer url = new StringBuffer();
        String uri = myRequest.getRequestURI();
        url.append(uri.substring(uri.lastIndexOf("/") + 1));
        url.append("?" + this.uriPrefix + "Bounce=" + bounce);
        Enumeration params = myRequest.getParameterNames();
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        while (params.hasMoreElements()) {
            String param = params.nextElement().toString();
            if (param.indexOf(this.uriPrefix) == 0) {
                url.append("&" + param + "=" + this.utf8URLEncode(myRequest.getParameter(param)));
                continue;
            }
            customAttributes.put(param, myRequest.getParameter(param));
        }
        myResponse.setContentType("text/html; charset=UTF-8");
        myResponse.setHeader("Cache-Control", "no-store");
        myResponse.setHeader("Pragma", "no-cache");
        String bounceURL = url.toString();
        Iterator it = customAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            bounceURL = bounceURL + "&" + key + "=" + value;
        }
        bounceURL = bounceURL + "&" + this.uriPrefix + "ViewerInstalled=none";
        PrintWriter outP = myResponse.getWriter();
        outP.println("<html><head>");
        outP.println("<noscript>");
        outP.println("<meta http-equiv=\"refresh\" content=\"1;url=" + bounceURL + "\">");
        outP.println("</noscript>");
        outP.println("<script>");
        outP.println("\tfunction getViewerVersion()");
        outP.println("\t{");
        outP.println("\t\tvar viewerVersion = \"none\";");
        outP.println("");
        outP.println("\t\tif (navigator.userAgent.indexOf(\"Gecko\") != -1)");
        outP.println("\t\t{");
        outP.println("\t\t\tvar counter = 0;");
        outP.println("");
        outP.println("\t\t\tfor( counter=0; counter < navigator.plugins.length; counter ++)");
        outP.println("\t\t\t{");
        outP.println("\t\t\t\tvar pluginName = navigator.plugins[counter].name;");
        outP.println("\t\t\t\tvar peIndex = pluginName.indexOf(\"PureEdge Viewer\");");
        outP.println("");
        outP.println("\t\t\t\tif (peIndex != -1)");
        outP.println("\t\t\t\t{");
        outP.println("\t\t\t\t\tpeIndex += 16;");
        outP.println("\t\t\t\t}");
        outP.println("\t\t\t\telse");
        outP.println("\t\t\t\t{");
        outP.println("\t\t\t\t\tpeIndex = pluginName.indexOf(\"IBM Workplace Forms Viewer\");");
        outP.println("");
        outP.println("\t\t\t\t\tif (peIndex != -1)");
        outP.println("\t\t\t\t\t\tpeIndex += 27;");
        outP.println("\t\t\t\t\telse");
        outP.println("\t\t\t\t\t{");
        outP.println("\t\t\t\t\t\tpeIndex = pluginName.indexOf(\"IBM Lotus Forms Viewer\");");
        outP.println("");
        outP.println("\t\t\t\t\t\tif (peIndex != -1)");
        outP.println("\t\t\t\t\t\t\tpeIndex += 23;");
        outP.println("\t\t\t\t\t}");
        outP.println("\t\t\t\t}");
        outP.println("");
        outP.println("\t\t\t\tif (peIndex != -1)");
        outP.println("\t\t\t\t{");
        outP.println("\t\t\t\t\tviewerVersion = pluginName.substring(peIndex);");
        outP.println("\t\t\t\t\tbreak;");
        outP.println("\t\t\t\t}");
        outP.println("\t\t\t}");
        outP.println("\t\t}");
        outP.println("\t\telse if (navigator.userAgent.indexOf(\"MSIE\") != -1)");
        outP.println("\t\t{");
        outP.println("\t\t\tif ((document.viewerCheck != null) && (document.viewerCheck.object != null))");
        outP.println("\t\t\t{");
        outP.println("\t\t\t\tviewerVersion = document.viewerCheck.object.Version;");
        outP.println("");
        outP.println("\t\t\t\tif (viewerVersion == undefined)");
        outP.println("\t\t\t\t\tviewerVersion = \"Installed\";");
        outP.println("\t\t\t}");
        outP.println("\t\t}");
        outP.println("\n");
        outP.println("\t\treturn viewerVersion;");
        outP.println("\t}");
        outP.println("");
        outP.println("</script>");
        outP.println("</head>");
        outP.println("<body onload='document.forms[0].elements[\"" + this.uriPrefix + "ViewerInstalled\"].value=getViewerVersion(); document.forms[0].submit();'>");
        outP.println("<form method='post' action='" + url.toString() + "'>");
        outP.println("<input type='hidden' name='" + this.uriPrefix + "ViewerInstalled' value=''/>");
        it = customAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            outP.println("<input type='hidden' name='" + key + "' value='" + value + "'/>");
        }
        outP.println("</form>");
        outP.println("<object id=\"viewerCheck\" height=\"10\" width=\"10\" style=\"display:none;\" classid=\"CLSID:354913B2-7190-49C0-944B-1507C9125367\">");
        outP.println("\t<param NAME=\"XFDLID\" VALUE=\"XFDLData\">");
        outP.println("</object>");
        outP.println("");
        outP.println("<script language=\"XFDL\" id=\"XFDLData\" type=\"application/vnd.xfdl; wrapped=comment\">");
        outP.println("<!--<XFDL xmlns=\"http://www.PureEdge.com/XFDL/6.2\" xmlns:custom=\"http://www.PureEdge.com/XFDL/Custom\" xmlns:designer=\"http://www.PureEdge.com/Designer/6.1\" xmlns:xfdl=\"http://www.PureEdge.com/XFDL/6.2\">");
        outP.println("\t<globalpage sid=\"global\">");
        outP.println("\t\t<global sid=\"global\">");
        outP.println("\t\t\t<formid>");
        outP.println("\t\t\t\t<serialnumber>3A49E751-1D69-492F-8EAE-F090AE5F92B6</serialnumber>");
        outP.println("\t\t\t\t<version>2.3.1</version>");
        outP.println("\t\t\t</formid>");
        outP.println("\t\t\t<vfd_date>31/5/2004</vfd_date>");
        outP.println("\t\t</global>");
        outP.println("\t</globalpage>");
        outP.println("</XFDL>");
        outP.println("-->");
        outP.println("</script>");
        outP.println("</body></html>");
        outP.flush();
        bounced = true;
        return bounced;
    }

    public void useXFDL(HttpServletResponse response, boolean newValue) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).setUseXFDL(newValue);
        }
    }

    public void useHTML(HttpServletResponse response, boolean newValue) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).setUseHTML(newValue);
        }
    }

    public void setFilename(HttpServletResponse response, String newFilename) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).setFilename(newFilename);
        }
    }

    public void setFormName(HttpServletResponse response, String newFormName) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).setFormName(newFormName);
        }
    }

    public void setTemplateId(HttpServletResponse response, String templateId) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).setTemplateId(templateId);
        }
    }

    public void addXFormsInstance(HttpServletResponse response, String modelId, String nodeRef, int flags, String modelData) {
        if (response instanceof WebformServletResponse) {
            ((WebformServletResponse)response).addXFormsInstance(modelId, nodeRef, flags, modelData);
        }
    }

    public String getFilename(HttpServletRequest request) {
        String formName = null;
        if (request instanceof WebformServletRequest) {
            formName = ((WebformServletRequest)request).getFilename();
        }
        return formName;
    }

    public static boolean hasViewer(HttpServletRequest request) {
        if (request instanceof WebformServletRequest) {
            return ((WebformServletRequest)request).hasViewer();
        }
        return false;
    }

    public String getViewerVersion(HttpServletRequest request) {
        if (request instanceof WebformServletRequest) {
            return FrameworkUtils.getInternalVersion(((WebformServletRequest)request).getViewerVersion());
        }
        return null;
    }

    public String utf8URLEncode(String value) {
        return UTF8URLEncoder.encode((String)value);
    }

    public String utf8URLDecode(String value) {
        return UTF8URLDecoder.decode((String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        myRequest = null;
        myResponse = null;
        requestAction = null;
        userInfo = null;
        requestRequiresRefresh = false;
        errorOccurred = false;
        try {
            block35: {
                block30: {
                    block36: {
                        block37: {
                            block32: {
                                block33: {
                                    block34: {
                                        block31: {
                                            request.setCharacterEncoding("UTF-8");
                                            myRequest = new WebformServletRequest(request, this.uriPrefix);
                                            myResponse = new WebformServletResponse(response, this.uriPrefix);
                                            requestAction = myRequest.getParameter(this.uriPrefix + "Action");
                                            userInfo = myRequest.getRemoteHost() + " / [" + System.currentTimeMillis() + "]";
                                            myRequest.setHeader(this.uriPrefix + "TranslatorHook", this.translatorLocation);
                                            if (requestAction == null || requestAction.compareToIgnoreCase("resource") != 0 && requestAction.compareToIgnoreCase("localize") != 0 && requestAction.compareToIgnoreCase("plugin") != 0 && requestAction.compareToIgnoreCase("format") != 0) {
                                                this.logger.writeLog_1("Request", userInfo, myRequest.getFullURL());
                                                if (this.logLevel >= 2) {
                                                    this.logger.writeLog_2("Request Header", userInfo, myRequest.getHeaderAsString());
                                                    buf = new byte[32000];
                                                    requestInputStream = myRequest.getInputStream();
                                                    fullData = new ByteArrayOutputStream();
                                                    while ((bytesRead = requestInputStream.read(buf)) != -1) {
                                                        fullData.write(buf, 0, bytesRead);
                                                    }
                                                    streamData = new String(fullData.toByteArray(), "UTF-8");
                                                    myRequest.setInternalStream(fullData.toByteArray());
                                                    this.logger.writeLog_2("Request Stream", userInfo, streamData);
                                                    fullData.close();
                                                }
                                            }
                                            if (!this.disableViewerDetection) break block31;
                                            request.getSession().setAttribute(this.uriPrefix + "HasViewer", (Object)"none");
                                            break block32;
                                        }
                                        viewerVersion = myRequest.getViewerVersion();
                                        if (this.checkForBounce(myRequest)) break block33;
                                        value = (String)myRequest.getSession().getAttribute(this.uriPrefix + "HasViewer");
                                        v0 = sessionKnowsOfViewer = value != null && value.length() != 0 && "unknown".equals(value) == false;
                                        if (sessionKnowsOfViewer || !this.createBounce(myRequest, myResponse)) break block34;
                                        var15_23 = null;
                                        ** GOTO lbl146
                                    }
                                    this.logger.writeLog_3("viewerVersion", "" + viewerVersion);
                                    break block32;
                                }
                                this.handleBounce(myRequest, myResponse);
                            }
                            if (myRequest.isSubmitDoneTranslatorRequest()) {
                                this.callTranslator(myRequest, myResponse);
                                myRequest.setContentType(myResponse.getContentType());
                                myRequest.setInternalStream(myResponse.currentStreamData());
                                requestContentType = myRequest.getContentType();
                                if (requestContentType != null && requestContentType.toLowerCase().startsWith("text/html")) {
                                    requestRequiresRefresh = true;
                                } else {
                                    myResponse.resetOutputStream();
                                }
                            }
                            if (requestRequiresRefresh) break block35;
                            if (!myRequest.allowPassToClient()) break block36;
                            this.logger.writeLog_3("passing to client");
                            currentReferer = myRequest.getHeader("x-ws-referer");
                            myRequest.removeHeader("x-ws-referer");
                            myRequest.removePWSParams();
                            super.service((HttpServletRequest)myRequest, (HttpServletResponse)myResponse);
                            if (!response.isCommitted()) break block37;
                            ** GOTO lbl155
                        }
                        myRequest.addPWSParams();
                        if (currentReferer != null) {
                            myRequest.setHeader("x-ws-referer", currentReferer);
                        }
                        break block30;
                    }
                    if ("cancel".equalsIgnoreCase(requestAction)) {
                        this.formCancelled((HttpServletRequest)myRequest);
                        session = request.getSession();
                        formCancelled = (String)session.getAttribute("IBMWorkplaceFormsServerServlet.formCancelled");
                        if (formCancelled != null) {
                            session.removeAttribute("IBMWorkplaceFormsServerServlet.formCancelled");
                            this.retrieveToolbeltForm(myRequest, myResponse);
                        } else {
                            myRequest.removeHeader("x-ws-referer");
                            myRequest.removePWSParams();
                            myRequest.setMethod("GET");
                            super.service((HttpServletRequest)myRequest, (HttpServletResponse)myResponse);
                        }
                    } else {
                        this.callTranslator(myRequest, myResponse);
                    }
                }
                responseType = myResponse.getContentType();
                if (responseType != null && "xformsevent".equalsIgnoreCase(requestAction) && myResponse.containsHeader("xformsreplaceall")) {
                    super.service((HttpServletRequest)myRequest, (HttpServletResponse)myResponse);
                }
                responseType = myResponse.getContentType();
                this.logger.writeLog_3("Response type", responseType);
                this.logger.writeLog_3("Response.UseXFDL", "" + myResponse.isUseXFDL());
                this.logger.writeLog_3("Response.UseHTML", "" + myResponse.isUseHTML());
                if (responseType != null && responseType.toLowerCase().startsWith("application/vnd.xfdl")) {
                    if (this.getViewerForResponse(myRequest, myResponse) == 1) {
                        myRequest.setContentType(myResponse.getContentType());
                        myRequest.setInternalStream(myResponse.currentStreamData());
                        myResponse.resetOutputStream();
                        this.callTranslator(myRequest, myResponse);
                    } else {
                        if (myResponse.getTemplateId() != null) {
                            myRequest.setContentType("application/vnd.xfdl");
                            myResponse.resetOutputStream();
                            this.callTranslator(myRequest, myResponse);
                        }
                        if ((currentFileName = myResponse.getFilename()) == null) {
                            currentFileName = "untitled.xfdl";
                        }
                        myResponse.setHeader("Content-Disposition", "inline; filename=" + currentFileName);
                    }
                }
            }
            if (requestAction != null && (requestAction == null || requestAction.compareToIgnoreCase("resource") == 0 || requestAction.compareToIgnoreCase("localize") == 0 || requestAction.compareToIgnoreCase("format") == 0)) ** GOTO lbl165
            this.logger.writeLog_1("Response", userInfo, myRequest.getFullURL());
            if (this.logLevel >= 2) {
                this.logger.writeLog_2("Response Header", userInfo, myResponse.getHeaderAsString());
                if (myResponse.getContentType() == null || myResponse.getContentType().toLowerCase().startsWith("text/html") || myResponse.getContentType().toLowerCase().startsWith("application/vnd.xfdl")) {
                    responseData = new String(myResponse.currentStreamData(), "UTF-8");
                    this.logger.writeLog_2("Response Stream", userInfo, responseData);
                }
            }
            ** GOTO lbl165
        }
        catch (Exception e) {
            timestamp = System.currentTimeMillis();
            this.generateServerError(userInfo, e, timestamp);
            this.generateBrowserError(response, e, timestamp);
            errorOccurred = true;
            var15_26 = null;
            try {
                if (errorOccurred != false) return;
                myResponse.finalizeResponse();
                return;
            }
            catch (Exception e) {
                timestamp = System.currentTimeMillis();
                this.generateServerError(userInfo, e, timestamp);
                this.generateBrowserError(response, e, timestamp);
                return;
            }
        }
        {
            catch (Throwable var14_38) {
                var15_27 = null;
                ** try [egrp 2[TRYBLOCK] [8 : 1230->1243)] { 
lbl138:
                // 1 sources

                if (errorOccurred != false) throw var14_38;
                myResponse.finalizeResponse();
                throw var14_38;
lbl141:
                // 1 sources

                catch (Exception e) {
                    timestamp = System.currentTimeMillis();
                    this.generateServerError(userInfo, e, timestamp);
                    this.generateBrowserError(response, e, timestamp);
                }
                throw var14_38;
            }
lbl146:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [8 : 1230->1243)] { 
lbl147:
            // 1 sources

            if (errorOccurred != false) return;
            myResponse.finalizeResponse();
            return;
lbl150:
            // 1 sources

            catch (Exception e) {
                timestamp = System.currentTimeMillis();
                this.generateServerError(userInfo, e, timestamp);
                this.generateBrowserError(response, e, timestamp);
            }
            return;
lbl155:
            // 1 sources

            var15_24 = null;
            ** try [egrp 2[TRYBLOCK] [8 : 1230->1243)] { 
lbl157:
            // 1 sources

            if (errorOccurred != false) return;
            myResponse.finalizeResponse();
            return;
lbl160:
            // 1 sources

            catch (Exception e) {
                timestamp = System.currentTimeMillis();
                this.generateServerError(userInfo, e, timestamp);
                this.generateBrowserError(response, e, timestamp);
            }
            return;
lbl165:
            // 2 sources

            var15_25 = null;
            try {}
            catch (Exception e) {}
            timestamp = System.currentTimeMillis();
            this.generateServerError(userInfo, e, timestamp);
            this.generateBrowserError(response, e, timestamp);
            return;
            if (errorOccurred != false) return;
            myResponse.finalizeResponse();
            return;
        }
    }

    public void formCancelled(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute("IBMWorkplaceFormsServerServlet.formCancelled", (Object)"true");
    }

    private void generateServerError(String userInfo, Exception exception, long timestamp) {
        this.logger.writeThrowableErrorLog(exception, userInfo, timestamp);
    }

    private void generateBrowserError(HttpServletResponse response, Exception exception, long timestamp) {
        try {
            StringBuffer html = new StringBuffer();
            String errorTitle = "Webform Server Framework Error";
            String pattern = "An error has occurred in the Webform Server framework.  Please consult your system administrator and mention the following details:<BR><BR><CODE>EXCEPTION = {0}<BR>TIMESTAMP = {1}</CODE><BR><BR>We apologize for any inconvenience this error may have caused.";
            Object[] keys = new Object[]{exception.getMessage(), "" + timestamp};
            String errorMessage = MessageFormat.format(pattern, keys);
            html.append("<HTML><HEAD><TITLE>" + errorTitle + "</TITLE><META http-equiv=Content-Type content=\"text/html; charset=utf-8\"></HEAD>");
            html.append("<BODY><B>" + errorTitle + "</B><BR><BR>" + errorMessage + "</BODY></HTML>");
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter output = response.getWriter();
            output.print(html.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public boolean isViewerInstalled(WebformServletRequest request) {
        String sessionValue = (String)request.getSession().getAttribute(this.uriPrefix + "HasViewer");
        return sessionValue != null && sessionValue.length() > 0 && !"unknown".equals(sessionValue) && !"none".equals(sessionValue);
    }

    private int getViewerForResponse(WebformServletRequest request, WebformServletResponse response) {
        if (response.isUseHTML()) {
            return 1;
        }
        if (response.isUseXFDL()) {
            return 0;
        }
        if (!(response.isUseHTML() || response.isUseXFDL() || this.isViewerInstalled(request))) {
            return 1;
        }
        if (!response.isUseHTML() && !response.isUseXFDL() && this.isViewerInstalled(request)) {
            return 0;
        }
        return 1;
    }
}

