/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.portlet;

import com.ibm.form.webform.logging.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public class WebformPortletLogger
extends Logger {
    public static final String EXCEPTION_CODE = "Exception";
    private static final String RECONNECTION_DELAY = "5000";
    private int logLevel;

    public WebformPortletLogger(int logLevelToUse) {
        super("portlet");
        this.logLevel = logLevelToUse;
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException UHEex) {
            this.writeErrorLog("Failed to get hostname", null, null, null, null);
            hostName = "unknownHostName";
        }
        super.setContext(hostName);
    }

    public void configure(String logServerHostname, String logServerPort) {
        boolean isDebugEnabled = this.logLevel > 1;
        String debugLevelStr = isDebugEnabled ? "ALL" : "OFF";
        Properties p = new Properties();
        p.setProperty("log4j.appender.A1", "org.apache.log4j.net.SocketAppender");
        p.setProperty("log4j.appender.A1.RemoteHost", logServerHostname);
        p.setProperty("log4j.appender.A1.Port", logServerPort);
        p.setProperty("log4j.appender.A1.ReconnectionDelay", RECONNECTION_DELAY);
        p.setProperty("log4j.category.portlet_debug", debugLevelStr + "#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.portlet_debug", "false");
        p.setProperty("log4j.category.portlet_error", "ALL#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.portlet_error", "false");
        p.setProperty("log4j.category.portlet_operational", "ALL#com.ibm.form.webform.logging.PELevel, A1");
        p.setProperty("log4j.additivity.portlet_operational", "false");
        super.configure(p);
    }

    public void writeOperationalLog(String theOperation, String theData, Map extraDataMap) {
        if (this.logLevel >= 1) {
            super.writeOperationalLog(theOperation, theData, extraDataMap);
        }
    }

    public void writeRequestDebugLog(String theMessage, String theData, Map extraDataMap) {
        if (this.logLevel >= 2) {
            super.writeDebugLog(theMessage, theData, extraDataMap);
        }
    }

    public void writeDebugLog(String theMessage, String theData, Map extraDataMap) {
        if (this.logLevel >= 3) {
            super.writeDebugLog(theMessage, theData, extraDataMap);
        }
    }
}

