/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.portlet;

import com.ibm.form.webform.framework.FrameworkUtils;
import com.ibm.form.webform.framework.HttpResource;
import com.ibm.form.webform.framework.HttpResourceAccessCredentials;
import com.ibm.form.webform.framework.HttpResourceProvider;
import com.ibm.form.webform.framework.portlet.WebformPortletLogger;
import com.ibm.form.webform.framework.portlet.WebformPortletSessionBean;
import com.ibm.form.webform.logging.Logger;
import com.ibm.form.webform.pws.UTF8URLEncoder;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.ResourceProvider;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceSystemError;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.CacheManager;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class WebformPortletForwarder
extends HttpServlet {
    private static final long serialVersionUID = -1302689903962363877L;
    private String translatorURL;
    private String uriPrefix;
    private WebformPortletLogger logger;
    private MultiThreadedHttpConnectionManager connectionManager = null;
    private int maxConnections = 250;
    private boolean disableResourceCache = true;
    private ResourceProvider resourceProvider = null;

    public void init(ServletConfig config) throws ServletException {
        String logLevel;
        String logServerPort;
        String logServerName;
        this.translatorURL = config.getInitParameter("translatorLocation");
        this.uriPrefix = config.getInitParameter("uriPrefix");
        if (this.uriPrefix == null) {
            this.uriPrefix = "pws";
        }
        if ((logServerName = config.getInitParameter("logServerName")) == null) {
            logServerName = "localhost";
        }
        if ((logServerPort = config.getInitParameter("logServerPort")) == null) {
            logServerPort = "4560";
        }
        if ((logLevel = config.getInitParameter("logLevel")) == null) {
            logLevel = "0";
        }
        this.logger = new WebformPortletLogger(Integer.parseInt(logLevel));
        this.logger.configure(logServerName, logServerPort);
        String disableResourceCacheStr = config.getInitParameter("disableResourceCache");
        this.disableResourceCache = disableResourceCacheStr == null ? true : Boolean.valueOf(disableResourceCacheStr);
        if (!this.disableResourceCache) {
            String cachingSizeThresholdText = config.getInitParameter("cachingSizeThreshold_bytes");
            this.resourceProvider = new HttpResourceProvider(this.uriPrefix, CacheManager.getInstance(), (Logger)this.logger, cachingSizeThresholdText);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        String maxConValue = config.getInitParameter("maxConnections");
        if (maxConValue != null) {
            this.maxConnections = Integer.parseInt(maxConValue);
        }
        HttpConnectionManagerParams conMgrParams = new HttpConnectionManagerParams();
        conMgrParams.setDefaultMaxConnectionsPerHost(this.maxConnections);
        this.connectionManager.setParams(conMgrParams);
        this.logger.writeDebugLog("WebformPortletForwarder Initialized successfully", null, null);
        super.init(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String connectURL = null;
        PostMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        InputStream pwsInStream = null;
        OutputStream servletOutStream = null;
        String respContentType = null;
        String portletNamespace = req.getParameter(this.uriPrefix + "PortalNamespace");
        WebformPortletSessionBean sessionBean = this.getPortletSessionBean(req, portletNamespace);
        String actionType = req.getParameter(this.uriPrefix + "Action");
        try {
            try {
                boolean doIncludeRequestBody = true;
                if (actionType != null && (actionType.equalsIgnoreCase("print") || actionType.equalsIgnoreCase("remove") || actionType.equalsIgnoreCase("format") || actionType.equalsIgnoreCase("ajaxRequest") || actionType.equalsIgnoreCase("ajaxAPI"))) {
                    req.setCharacterEncoding("UTF-8");
                    connectURL = this.translatorURL + "/Translate?" + this.uriPrefix + "PortletMode=true";
                    Enumeration parameterList = req.getParameterNames();
                    while (parameterList.hasMoreElements()) {
                        String currentParam = (String)parameterList.nextElement();
                        String[] paramValues = req.getParameterValues(currentParam);
                        if (paramValues == null) continue;
                        for (int i = 0; i < paramValues.length; ++i) {
                            String paramValue = paramValues[i];
                            connectURL = connectURL + "&" + this.utf8URLEncode(currentParam) + "=" + this.utf8URLEncode(paramValue);
                        }
                    }
                    if (req.getContentType() != null && !req.getContentType().startsWith("multipart/form-data")) {
                        doIncludeRequestBody = false;
                    }
                } else if ("Image".equalsIgnoreCase(actionType) || "Display".equalsIgnoreCase(actionType) || "Extract".equalsIgnoreCase(actionType) || "File".equalsIgnoreCase(actionType)) {
                    connectURL = this.translatorURL + "/ResourceService? " + this.uriPrefix + "Action=" + actionType;
                } else {
                    req.setCharacterEncoding("UTF-8");
                    StringBuffer url = new StringBuffer();
                    url.append(this.translatorURL).append("/Translate?fwURL=").append(req.getRequestURL()).append("&").append(this.uriPrefix).append("PortletMode=true&").append(req.getQueryString());
                    connectURL = url.toString();
                }
                method = new PostMethod(connectURL);
                String referer = (req.getScheme().toLowerCase().startsWith("https") ? "https://" : "http://") + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI();
                method.setRequestHeader("x-ws-referer", referer);
                method.setRequestHeader("content-type", req.getContentType());
                method.setRequestHeader("uriprefix", this.uriPrefix);
                String cookieHeader = sessionBean.getTranslatorCookieHeader();
                if (cookieHeader != null) {
                    method.setRequestHeader("cookie", cookieHeader);
                }
                method.setRequestHeader("user-agent", req.getHeader("user-agent"));
                Enumeration headerNameList = req.getHeaderNames();
                while (headerNameList.hasMoreElements()) {
                    String headerName = (String)headerNameList.nextElement();
                    String headerValue = req.getHeader(headerName);
                    if (FrameworkUtils.isRestrictedHeader(headerName) || "cookie".equalsIgnoreCase(headerName)) continue;
                    method.setRequestHeader(headerName, headerValue);
                }
                ServletInputStream reqInStream = req.getInputStream();
                if (reqInStream.available() > 0 && doIncludeRequestBody) {
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)reqInStream));
                } else {
                    method.setRequestHeader("Content-Length", "0");
                }
                int responseCode = client.executeMethod((HttpMethod)method);
                if (responseCode == 412) {
                    resp.setStatus(304);
                } else {
                    resp.setStatus(responseCode);
                }
                this.propagateCacheHeaders(method.getResponseHeaders(), resp);
                header = method.getResponseHeader("content-type");
                if (header != null) {
                    respContentType = header.getValue();
                }
                if (respContentType != null) {
                    header = method.getResponseHeader("Content-Disposition");
                    if (header != null) {
                        resp.setHeader("Content-Disposition", header.getValue());
                    }
                    resp.setContentType(respContentType);
                }
                servletOutStream = resp.getOutputStream();
                this.transferStream(method.getResponseBodyAsStream(), servletOutStream);
                servletOutStream.flush();
            }
            catch (MalformedURLException e) {
                this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                throw new ServletException((Throwable)e);
            }
            catch (ProtocolException e) {
                this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                throw new ServletException((Throwable)e);
            }
            catch (IOException e) {
                this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                throw new ServletException((Throwable)e);
            }
            Object var20_26 = null;
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            try {
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (servletOutStream != null) {
                    servletOutStream.close();
                }
                if (method == null) throw throwable;
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (servletOutStream != null) {
            servletOutStream.close();
        }
        if (method == null) return;
        method.releaseConnection();
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block75: {
            block74: {
                block73: {
                    block72: {
                        block71: {
                            method = null;
                            header = null;
                            client = new HttpClient((HttpConnectionManager)this.connectionManager);
                            url = new StringBuffer();
                            pwsInStream = null;
                            servletOutStream = null;
                            actionType = req.getParameter(this.uriPrefix + "Action");
                            portletNamespace = req.getParameter(this.uriPrefix + "PortalNamespace");
                            sessionBean = this.getPortletSessionBean(req, portletNamespace);
                            try {
                                try {
                                    block70: {
                                        if (actionType != null && actionType.equalsIgnoreCase("Resource")) {
                                            url.append(this.translatorURL).append("/").append(req.getParameter(this.uriPrefix + "Location"));
                                        } else if (actionType != null && actionType.equalsIgnoreCase("Localize")) {
                                            url.append(this.translatorURL).append("/ResourceService?" + this.uriPrefix + "Action=Localize&").append(this.uriPrefix).append("GID=").append(req.getParameter(this.uriPrefix + "GID")).append("&locale=").append(req.getParameter("lang"));
                                        } else if ("Image".equalsIgnoreCase(actionType) || "Display".equalsIgnoreCase(actionType) || "Extract".equalsIgnoreCase(actionType) || "File".equalsIgnoreCase(actionType)) {
                                            url.append(this.translatorURL).append("/ResourceService?").append(this.uriPrefix).append("Action=").append(actionType);
                                            if (req.getParameter(this.uriPrefix + "FormInstance") != null) {
                                                url.append("&").append(this.uriPrefix).append("FormInstance=").append(req.getParameter(this.uriPrefix + "FormInstance"));
                                            }
                                            if (req.getParameter(this.uriPrefix + "TemplateId") != null) {
                                                url.append("&").append(this.uriPrefix).append("TemplateId=").append(URLEncoder.encode(req.getParameter(this.uriPrefix + "TemplateId"), "UTF-8"));
                                            }
                                            if (req.getParameter(this.uriPrefix + "FileName") != null) {
                                                url.append("&").append(this.uriPrefix).append("FileName=").append(URLEncoder.encode(req.getParameter(this.uriPrefix + "FileName"), "UTF-8"));
                                            }
                                            if (req.getParameter(this.uriPrefix + "Revision") != null) {
                                                url.append("&").append("Revision=").append(req.getParameter(this.uriPrefix + "Revision"));
                                            }
                                        } else if ("plugin".equalsIgnoreCase(actionType)) {
                                            url.append(this.translatorURL).append("/ResourceService?").append(this.uriPrefix).append("Action=").append(actionType);
                                            if (req.getParameter(this.uriPrefix + "Type") != null) {
                                                url.append("&").append(this.uriPrefix).append("Type=").append(URLEncoder.encode(req.getParameter(this.uriPrefix + "Type"), "UTF-8"));
                                            }
                                            if (req.getParameter(this.uriPrefix + "Location") != null) {
                                                url.append("&").append(this.uriPrefix).append("Location=").append(URLEncoder.encode(req.getParameter(this.uriPrefix + "Location"), "UTF-8"));
                                            }
                                        } else {
                                            url.append(this.translatorURL).append("/Translate?fwURL=").append(req.getRequestURL()).append("&").append(this.uriPrefix).append("PortletMode=true&").append(req.getQueryString());
                                        }
                                        uri = new URI(url.toString());
                                        normalizedUrl = uri.normalize().toString();
                                        method = new GetMethod(normalizedUrl);
                                        method.setRequestHeader("uriprefix", this.uriPrefix);
                                        if (this.disableResourceCache || !"Resource".equalsIgnoreCase(actionType) && !"Localize".equalsIgnoreCase(actionType) && !"Image".equalsIgnoreCase(actionType)) break block70;
                                        try {
                                            if (!FrameworkUtils.isCssFile(normalizedUrl) || null == (content = FrameworkUtils.getCorrectedCssFile(req))) ** GOTO lbl-1000
                                            resp.setContentType("text/css");
                                            createdDate = FrameworkUtils.getCssCacheFileCreatedTime(req);
                                            if (FrameworkUtils.isCachedInBrowser(req)) {
                                                ifModifiedSinceDate = FrameworkUtils.getIfModifiedSinceDate(req);
                                                if (createdDate != null && ifModifiedSinceDate != null && !createdDate.after(ifModifiedSinceDate)) {
                                                    resp.setStatus(304);
                                                }
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (UnhandledResourceTypeException e) {
                                            break block70;
                                        }
                                        catch (InvalidCredentialsException e) {
                                            break block70;
                                        }
                                        catch (URISyntaxException e) {
                                            break block70;
                                        }
                                        catch (ResourceSystemError e) {
                                            break block70;
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                            break block70;
                                        }
                                        var25_31 = null;
                                        break block71;
lbl-1000:
                                        // 1 sources

                                        {
                                            resp.addHeader("Last-Modified", FrameworkUtils.formatRfcString(createdDate));
                                            this.transferStream(new ByteArrayInputStream(content.getBytes()), (OutputStream)resp.getOutputStream());
                                        }
                                        break block72;
lbl-1000:
                                        // 1 sources

                                        {
                                            resource = (HttpResource)this.resourceProvider.get(new URI(normalizedUrl), (ResourceAccessCredentials)new HttpResourceAccessCredentials(req));
                                            if (resource == null) break block70;
                                            if (!FrameworkUtils.isCachedValidInBrowser(req, resource)) ** GOTO lbl-1000
                                            resp.setStatus(304);
                                        }
                                        break block73;
lbl-1000:
                                        // 1 sources

                                        {
                                            resp.setStatus(resource.getResponseCode());
                                            i = resource.getHeaderKeys().iterator();
                                            while (i.hasNext()) {
                                                key = (String)i.next();
                                                value = resource.getHeader(key);
                                                resp.addHeader(key, value);
                                            }
                                            if (resource.getData() == null) break block74;
                                            if (!FrameworkUtils.isCssFile(normalizedUrl)) {
                                                this.transferStream(new ByteArrayInputStream(resource.getData()), (OutputStream)resp.getOutputStream());
                                                break block74;
                                            }
                                            is = new ByteArrayInputStream(resource.getData());
                                            isr = new InputStreamReader(is);
                                            sr = new BufferedReader(isr);
                                            sb = new StringBuffer();
                                            line = "";
                                            while ((line = sr.readLine()) != null) {
                                                sb.append(line);
                                            }
                                            sr.close();
                                            isr.close();
                                            is.close();
                                            value = sb.toString();
                                            value = FrameworkUtils.substituteCssRelativePaths(FrameworkUtils.getFullPath(req), "Location=", value);
                                            this.transferStream(new ByteArrayInputStream(value.getBytes()), (OutputStream)resp.getOutputStream());
                                        }
                                        break block74;
                                    }
                                    if ((cookieHeader = sessionBean.getTranslatorCookieHeader()) != null) {
                                        method.setRequestHeader("cookie", cookieHeader);
                                    }
                                    v0 = isNotModified = (responseCode = client.executeMethod((HttpMethod)method)) == 412 || responseCode == 304;
                                    if (isNotModified) {
                                        resp.setStatus(304);
                                    } else {
                                        resp.setStatus(responseCode);
                                    }
                                    this.propagateCacheHeaders(method.getResponseHeaders(), resp);
                                    header = method.getResponseHeader("content-type");
                                    if (header != null) {
                                        if (method.getResponseHeader("Content-Disposition") != null) {
                                            resp.setHeader("Content-Disposition", method.getResponseHeader("Content-Disposition").getValue());
                                        }
                                        resp.setContentType(header.getValue());
                                    }
                                    if (!isNotModified) {
                                        responseBodyStream = method.getResponseBodyAsStream();
                                        servletOutStream = resp.getOutputStream();
                                        if (responseBodyStream != null) {
                                            if (!FrameworkUtils.isCssFile(normalizedUrl)) {
                                                this.transferStream(responseBodyStream, servletOutStream);
                                            } else {
                                                sr = new BufferedReader(new InputStreamReader(responseBodyStream));
                                                sb = new StringBuffer();
                                                line = "";
                                                while ((line = sr.readLine()) != null) {
                                                    sb.append(line);
                                                }
                                                sr.close();
                                                fullPath = FrameworkUtils.getFullPath(req);
                                                value = FrameworkUtils.substituteCssRelativePaths(fullPath.toString(), "Location=", sb.toString());
                                                is = new ByteArrayInputStream(value.getBytes());
                                                this.transferStream(is, servletOutStream);
                                                is.close();
                                            }
                                        }
                                        responseBodyStream.close();
                                        servletOutStream.close();
                                    }
                                    break block75;
                                }
                                catch (MalformedURLException e) {
                                    this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                                    throw new ServletException((Throwable)e);
                                }
                                catch (ProtocolException e) {
                                    this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                                    throw new ServletException((Throwable)e);
                                }
                                catch (IOException e) {
                                    this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                                    throw new ServletException((Throwable)e);
                                }
                                catch (URISyntaxException e) {
                                    this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                                    throw new ServletException((Throwable)e);
                                }
                                catch (Exception e) {
                                    this.logger.writeErrorLog(e.getClass().getName() + ": " + e.getMessage(), null, null, null, null);
                                    throw new ServletException((Throwable)e);
                                }
                            }
                            catch (Throwable var24_55) {
                                var25_36 = null;
                                try {
                                    if (pwsInStream != null) {
                                        pwsInStream.close();
                                    }
                                    if (servletOutStream != null) {
                                        servletOutStream.close();
                                    }
                                    if (method == null) throw var24_55;
                                    method.releaseConnection();
                                    throw var24_55;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                throw var24_55;
                            }
                        }
                        try {}
                        catch (IOException e) {
                            // empty catch block
                            return;
                        }
                        if (pwsInStream != null) {
                            pwsInStream.close();
                        }
                        if (servletOutStream != null) {
                            servletOutStream.close();
                        }
                        if (method == null) return;
                        method.releaseConnection();
                        return;
                    }
                    var25_32 = null;
                    try {}
                    catch (IOException e) {
                        // empty catch block
                        return;
                    }
                    if (pwsInStream != null) {
                        pwsInStream.close();
                    }
                    if (servletOutStream != null) {
                        servletOutStream.close();
                    }
                    if (method == null) return;
                    method.releaseConnection();
                    return;
                }
                var25_33 = null;
                try {}
                catch (IOException e) {
                    // empty catch block
                    return;
                }
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (servletOutStream != null) {
                    servletOutStream.close();
                }
                if (method == null) return;
                method.releaseConnection();
                return;
            }
            var25_34 = null;
            try {}
            catch (IOException e) {
                // empty catch block
                return;
            }
            if (pwsInStream != null) {
                pwsInStream.close();
            }
            if (servletOutStream != null) {
                servletOutStream.close();
            }
            if (method == null) return;
            method.releaseConnection();
            return;
        }
        var25_35 = null;
        try {}
        catch (IOException e) {}
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (servletOutStream != null) {
            servletOutStream.close();
        }
        if (method == null) return;
        method.releaseConnection();
        return;
    }

    private void propagateCacheHeaders(Header[] headers, HttpServletResponse response) {
        for (int i = 0; i < headers.length; ++i) {
            String key = headers[i].getName();
            String value = headers[i].getValue();
            if ("Last-Modified".equalsIgnoreCase(key)) {
                response.setHeader("Last-Modified", value);
                continue;
            }
            if ("Date".equalsIgnoreCase(key)) {
                response.setHeader("Date", value);
                continue;
            }
            if (!"Expires".equalsIgnoreCase(key)) continue;
            response.setHeader("Expires", value);
        }
    }

    private WebformPortletSessionBean getPortletSessionBean(HttpServletRequest request, String portletNamespace) {
        HttpSession session = request.getSession();
        if (portletNamespace == null) {
            return new WebformPortletSessionBean();
        }
        WebformPortletSessionBean sessionBean = (WebformPortletSessionBean)session.getAttribute("javax.portlet.p." + portletNamespace + "?" + "WebformPortletSessionBean");
        if (sessionBean == null) {
            sessionBean = new WebformPortletSessionBean();
        }
        return sessionBean;
    }

    public String utf8URLEncode(String value) {
        return UTF8URLEncoder.encode((String)value);
    }

    private int transferStream(InputStream is, OutputStream os) throws IOException {
        int totalBytesRead = 0;
        byte[] buf = new byte[32768];
        int nBytesRead = is.read(buf);
        while (nBytesRead != -1) {
            os.write(buf, 0, nBytesRead);
            totalBytesRead += nBytesRead;
            nBytesRead = is.read(buf);
        }
        return totalBytesRead;
    }
}

