/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.portlet;

import com.ibm.form.webform.framework.FrameworkUtils;
import com.ibm.form.webform.framework.TemplateManager;
import com.ibm.form.webform.framework.XFormsInstancePart;
import com.ibm.form.webform.framework.portlet.MultiPartFormOutputStream;
import com.ibm.form.webform.framework.portlet.WebformPortletActionRequest;
import com.ibm.form.webform.framework.portlet.WebformPortletActionResponse;
import com.ibm.form.webform.framework.portlet.WebformPortletContext;
import com.ibm.form.webform.framework.portlet.WebformPortletLogger;
import com.ibm.form.webform.framework.portlet.WebformPortletRenderRequest;
import com.ibm.form.webform.framework.portlet.WebformPortletRenderResponse;
import com.ibm.form.webform.framework.portlet.WebformPortletSessionBean;
import com.ibm.form.webform.pws.UTF8URLDecoder;
import com.ibm.form.webform.pws.UTF8URLEncoder;
import com.ibm.form.webform.pws.XFormsInstanceDetails;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public abstract class IBMWorkplaceFormsServerPortlet
extends GenericPortlet {
    protected static final String SESSION_BEAN = "WebformPortletSessionBean";
    private String translatorLocation;
    private String uriPrefix;
    private String viewerTTL;
    private boolean isDebugEnabled = false;
    private boolean disableViewerDetection = false;
    private WebformPortletLogger logger = null;
    private boolean usePWS = true;
    private ThreadLocal replaceAll;
    private String portletWidth;
    private String portletHeight;
    private String minPortletWidth;
    private String minPortletHeight;
    private MultiThreadedHttpConnectionManager connectionManager = null;
    private boolean showFormBorder;
    private int maxConnections = 250;
    private String customFormName;
    protected TemplateManager templateManager = null;

    public void init(PortletConfig config) throws PortletException {
        try {
            super.init(config);
            String debugValue = config.getInitParameter("debug");
            if (debugValue != null) {
                this.isDebugEnabled = Boolean.valueOf(debugValue);
            }
            if (this.usePWS) {
                String verMapFileLocation;
                String logLevel;
                String logServerPort;
                String logServerName;
                String disableViewerDetectionStr;
                String showFormBorderParam;
                this.translatorLocation = config.getInitParameter("translatorLocation");
                if (this.translatorLocation == null) {
                    throw new PortletException("TranslatorLocation must be specified in the web.xml");
                }
                this.portletWidth = config.getInitParameter("portletWidth");
                if (this.portletWidth == null) {
                    this.portletWidth = "640";
                }
                this.portletHeight = config.getInitParameter("portletHeight");
                if (this.portletHeight == null) {
                    this.portletHeight = "480";
                }
                this.minPortletWidth = config.getInitParameter("minPortletWidth");
                if (this.minPortletWidth == null) {
                    this.minPortletWidth = "0";
                }
                this.minPortletHeight = config.getInitParameter("minPortletHeight");
                if (this.minPortletHeight == null) {
                    this.minPortletHeight = "0";
                }
                this.showFormBorder = (showFormBorderParam = config.getInitParameter("showFormBorder")) != null ? Boolean.valueOf(showFormBorderParam) : true;
                this.uriPrefix = config.getInitParameter("uriPrefix");
                if (this.uriPrefix == null) {
                    this.uriPrefix = "pws";
                }
                if ((disableViewerDetectionStr = config.getInitParameter("disableViewerDetection")) != null) {
                    this.disableViewerDetection = Boolean.valueOf(disableViewerDetectionStr);
                }
                if ((logServerName = config.getInitParameter("logServerName")) == null) {
                    logServerName = "localhost";
                }
                if ((logServerPort = config.getInitParameter("logServerPort")) == null) {
                    logServerPort = "4560";
                }
                if ((logLevel = config.getInitParameter("logLevel")) == null) {
                    logLevel = "0";
                }
                this.logger = new WebformPortletLogger(Integer.parseInt(logLevel));
                this.logger.configure(logServerName, logServerPort);
                this.viewerTTL = config.getInitParameter("viewerTTL");
                if (this.viewerTTL == null) {
                    this.viewerTTL = "15";
                }
                if ((verMapFileLocation = config.getInitParameter("versionMappingFilePath")) == null) {
                    verMapFileLocation = config.getPortletContext().getRealPath("/") + File.separator + "mapping.properties";
                }
                FrameworkUtils.processMappingConfig(verMapFileLocation);
                String maxConValue = config.getInitParameter("maxConnections");
                if (maxConValue != null) {
                    this.maxConnections = Integer.parseInt(maxConValue);
                }
                this.connectionManager = new MultiThreadedHttpConnectionManager();
                HttpConnectionManagerParams conMgrParams = new HttpConnectionManagerParams();
                conMgrParams.setDefaultMaxConnectionsPerHost(this.maxConnections);
                conMgrParams.setMaxTotalConnections(this.maxConnections);
                this.connectionManager.setParams(conMgrParams);
                this.templateManager = new TemplateManager(this.translatorLocation);
                this.replaceAll = new ThreadLocal(){

                    protected synchronized Object initialValue() {
                        return new Boolean(false);
                    }
                };
                this.logger.writeDebugLog("Portlet Initialization Successful", null, null);
            }
        }
        catch (Exception ex) {
            this.logger.writeThrowableErrorLog(ex);
            throw new PortletException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            if (!this.usePWS) {
                this.processActionEx(request, response);
                return;
            }
            WebformPortletActionRequest pwsRequest = new WebformPortletActionRequest(request);
            WebformPortletActionResponse pwsResponse = new WebformPortletActionResponse(response);
            WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
            if (request.getContentType() != null && request.getContentType().toLowerCase().startsWith("application/vnd.xfdl")) {
                this.processActionEx(request, response);
                sessionBean.reset();
                return;
            }
            if (sessionBean.getState() != 1) {
                this.processActionEx(request, response);
                return;
            }
            sessionBean.setParameters((PortletRequest)request);
            String action = request.getParameter(this.uriPrefix + "Action");
            if ("open".equalsIgnoreCase(action)) {
                sessionBean.removeParameter(this.uriPrefix + "FormName");
                sessionBean.setFormFilename(null);
            }
            if ("cancel".equalsIgnoreCase(action)) {
                this.formCancelled((PortletRequest)pwsRequest);
                if (sessionBean.getState() != 2) {
                    this.resetPortlet((PortletRequest)request);
                    return;
                }
                String toolbeltForm = this.retrieveToolbeltForm(pwsRequest, pwsResponse);
                sessionBean.clearParameters();
                sessionBean.setHtml(toolbeltForm);
                sessionBean.setState(1);
                return;
            }
            this.setReplaceAll(false);
            String result = this.submitToPWS(request, pwsResponse);
            String contentType = pwsResponse.getContentType();
            if (this.isReplaceAll()) {
                pwsRequest.setInputStreamData(result.getBytes("UTF-8"));
                pwsRequest.setContentType("text/xml; charset=UTF-8");
                this.processActionEx(pwsRequest, response);
                sessionBean.reset();
                this.setReplaceAll(false);
                return;
            }
            if (contentType != null && contentType.toLowerCase().startsWith("application/vnd.xfdl")) {
                pwsRequest.setInputStreamData(result.getBytes("UTF-8"));
                pwsRequest.setContentType(contentType);
                this.processActionEx(pwsRequest, response);
                sessionBean.reset();
                return;
            }
            if (contentType != null && contentType.startsWith("text/html")) {
                sessionBean.setState(1);
                sessionBean.setHtml(result);
                sessionBean.setSkipNextRevCheck(true);
                return;
            }
            if (!this.usePWS) throw new PortletException("Unhandled content-type (" + contentType + ") was returned from the translator in processAction().");
            this.logger.writeErrorLog("Unhandled content-type (" + contentType + ") was returned from the translator in processAction().", null, null, null, null);
            throw new PortletException("Unhandled content-type (" + contentType + ") was returned from the translator in processAction().");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!this.usePWS) throw new PortletException((Throwable)ex);
            this.logger.writeThrowableErrorLog(ex);
            throw new PortletException((Throwable)ex);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        boolean skipRevCheck = sessionBean.isSkipNextRevCheck();
        sessionBean.setSkipNextRevCheck(false);
        try {
            String userAgent;
            String viewerVersion = request.getParameter(this.uriPrefix + "ViewerVersion");
            if (viewerVersion != null) {
                viewerVersion = FrameworkUtils.getInternalVersion(viewerVersion);
                sessionBean.setInstalledViewer(viewerVersion);
            }
            if ((userAgent = request.getParameter(this.uriPrefix + "UserAgent")) != null && sessionBean.getUserAgent() == null) {
                sessionBean.setUserAgent(userAgent);
            }
            if (sessionBean.getInstalledViewer() == null && this.disableViewerDetection) {
                sessionBean.setInstalledViewer("none");
                PortletURL renderURL = response.createRenderURL();
                String bounceHTML = this.generateUserAgentHTML(renderURL.toString());
                response.setContentType("text/html; charset=UTF-8");
                response.getWriter().write(bounceHTML);
                return;
            }
            if (sessionBean.getInstalledViewer() == null) {
                PortletURL renderURL = response.createRenderURL();
                String bounceHTML = this.generateViewerDetectionHTML(renderURL.toString());
                response.setContentType("text/html; charset=UTF-8");
                response.getWriter().write(bounceHTML);
                return;
            }
            if (!this.usePWS) {
                this.doViewEx(request, response);
            } else {
                WebformPortletRenderRequest pwsRequest = new WebformPortletRenderRequest(request);
                WebformPortletRenderResponse pwsResponse = new WebformPortletRenderResponse(response);
                sessionBean.setActionURL(response.createActionURL().toString());
                if (sessionBean.getState() == 1) {
                    response.setContentType("text/html; charset=UTF-8");
                    String revCheckResponse = null;
                    if (sessionBean.getFormInstance() != null && !skipRevCheck && !sessionBean.useViewer()) {
                        revCheckResponse = this.checkRevisionAndRetrieveForm(pwsRequest, pwsResponse);
                    }
                    if (revCheckResponse != null && revCheckResponse.length() > 0) {
                        sessionBean.setHtml(revCheckResponse);
                        response.getWriter().write(revCheckResponse);
                    } else {
                        response.getWriter().write(sessionBean.getHtml());
                    }
                } else {
                    this.callApplication(response, sessionBean, pwsRequest, pwsResponse);
                }
            }
        }
        catch (Exception ex) {
            if (this.usePWS) {
                this.logger.writeThrowableErrorLog(ex);
            }
            throw new PortletException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkRevisionAndRetrieveForm(WebformPortletRenderRequest request, WebformPortletRenderResponse response) throws IOException, PortletException {
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        String formFilename = sessionBean.getFormFilename();
        if (formFilename == null) {
            formFilename = "form.xfdl";
        }
        String openParameters = this.uriPrefix + "Action=revCheckAndRetrieve&" + this.uriPrefix + "Revision=" + sessionBean.getRevisionNumber() + "&" + this.uriPrefix + "FormInstance=" + sessionBean.getFormInstance();
        InputStream pwsInStream = null;
        ByteArrayOutputStream bufOut = null;
        String result = null;
        PostMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        String path = "/Translate?" + openParameters + "&" + this.uriPrefix + "FormName=" + formFilename + "&" + this.buildQueryString(sessionBean, response.createActionURL().toString(), request.getContextPath(), false, request.getLocale());
        try {
            try {
                int bytesRead;
                method = new PostMethod(this.translatorLocation + path);
                method.setRequestHeader("uriprefix", this.uriPrefix);
                method.setRequestHeader("ws-portal-namespace", sessionBean.getPortalNamespace());
                String cookieHeader = sessionBean.getTranslatorCookieHeader();
                if (cookieHeader != null) {
                    method.setRequestHeader("cookie", cookieHeader);
                }
                client.executeMethod((HttpMethod)method);
                pwsInStream = new BufferedInputStream(method.getResponseBodyAsStream());
                bufOut = new ByteArrayOutputStream();
                byte[] buf = new byte[32000];
                while ((bytesRead = pwsInStream.read(buf)) != -1) {
                    bufOut.write(buf, 0, bytesRead);
                }
                pwsInStream.close();
                pwsInStream = null;
                header = method.getResponseHeader("content-type");
                if (header != null) {
                    response.setContentType(header.getValue());
                }
                this.setCommonSessionAttrs(sessionBean, (HttpMethod)method);
                result = bufOut.toString("UTF-8");
            }
            catch (MalformedURLException e) {
                throw new PortletException((Throwable)e);
            }
            catch (ProtocolException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            try {
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (method == null) throw throwable;
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (method == null) return result;
        method.releaseConnection();
        return result;
    }

    private void setCommonSessionAttrs(WebformPortletSessionBean sessionBean, HttpMethod method) {
        Header header = null;
        header = method.getResponseHeader("set-cookie");
        if (header != null) {
            sessionBean.setTranslatorCookieHeader(header.getValue());
        }
        if ((header = method.getResponseHeader("ws-revision-number")) != null) {
            sessionBean.setRevisionNumber(header.getValue());
        }
        if ((header = method.getResponseHeader("ws-form-instance")) != null) {
            sessionBean.setFormInstance(header.getValue());
        }
    }

    private void callApplication(RenderResponse response, WebformPortletSessionBean sessionBean, WebformPortletRenderRequest pwsRequest, WebformPortletRenderResponse pwsResponse) throws PortletException, IOException {
        this.doViewEx(pwsRequest, pwsResponse);
        this.setReplaceAll(false);
        if (pwsResponse.getContentType().toLowerCase().startsWith("application/vnd.xfdl")) {
            String html = null;
            String cachedHTML = null;
            boolean useViewer = false;
            if (!sessionBean.usePWS()) {
                String installedViewer = sessionBean.getInstalledViewer();
                if (sessionBean.useViewer() || installedViewer != null && !installedViewer.equals("none")) {
                    useViewer = true;
                }
            }
            if (useViewer) {
                if (sessionBean.getTemplateId() != null) {
                    String xfdl = this.openForm("xfdl", pwsRequest, pwsResponse);
                    ((ByteArrayOutputStream)pwsResponse.getPortletOutputStream()).reset();
                    pwsResponse.getPortletOutputStream().write(xfdl.getBytes());
                }
                html = this.generateViewerHTML(pwsRequest, pwsResponse, true);
                cachedHTML = this.generateViewerHTML(pwsRequest, pwsResponse, false);
            } else {
                cachedHTML = html = this.openForm("html", pwsRequest, pwsResponse);
            }
            sessionBean.setHtml(cachedHTML);
            sessionBean.setState(1);
            if (this.isDebugEnabled) {
                html = "usePWS = " + sessionBean.usePWS() + "<br/>" + "useViewer = " + sessionBean.useViewer() + "<br/>" + "installedViewer = " + sessionBean.getInstalledViewer() + "<br/><br/>" + html;
            }
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write(html);
        } else {
            String content = pwsResponse.outputStream.toString("UTF-8");
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write(content);
            response.getWriter().flush();
            sessionBean.reset();
        }
    }

    private String generateViewerDetectionHTML(String renderURL) {
        StringBuffer buf = new StringBuffer();
        buf.append("<script>");
        buf.append("\tfunction getViewerVersion()");
        buf.append("\t{");
        buf.append("\t\tvar viewerVersion = \"none\";");
        buf.append("\n");
        buf.append("\t\tif(navigator.userAgent.indexOf(\"Gecko\") != -1)");
        buf.append("\t\t{");
        buf.append("\t\t\tvar counter = 0;");
        buf.append("\n");
        buf.append("\t\t\tfor( counter=0; counter < navigator.plugins.length; counter ++)");
        buf.append("\t\t\t{");
        buf.append("\t\t\t\tvar pluginName = navigator.plugins[counter].name;");
        buf.append("\t\t\t\tvar peIndex = pluginName.indexOf(\"PureEdge Viewer\");");
        buf.append("\n");
        buf.append("\t\t\t\tif (peIndex != -1)");
        buf.append("\t\t\t\t{");
        buf.append("\t\t\t\t\tpeIndex += 16;");
        buf.append("\t\t\t\t}");
        buf.append("\t\t\t\telse");
        buf.append("\t\t\t\t{");
        buf.append("\t\t\t\t\tpeIndex = pluginName.indexOf(\"IBM Workplace Forms Viewer\");");
        buf.append("\n");
        buf.append("\t\t\t\t\tif (peIndex != -1)");
        buf.append("\t\t\t\t\t\tpeIndex += 27;");
        buf.append("\t\t\t\t\telse");
        buf.append("\t\t\t\t\t{");
        buf.append("\t\t\t\t\t\tpeIndex = pluginName.indexOf(\"IBM Lotus Forms Viewer\");");
        buf.append("");
        buf.append("\t\t\t\t\t\tif (peIndex != -1)");
        buf.append("\t\t\t\t\t\t\tpeIndex += 23;");
        buf.append("\t\t\t\t\t}");
        buf.append("\t\t\t\t}");
        buf.append("");
        buf.append("\t\t\t\tif (peIndex != -1)");
        buf.append("\t\t\t\t{");
        buf.append("\t\t\t\t\tviewerVersion = pluginName.substring(peIndex);");
        buf.append("\t\t\t\t\tbreak;");
        buf.append("\t\t\t\t}");
        buf.append("\t\t\t}");
        buf.append("\t\t}");
        buf.append("\t\telse if (navigator.userAgent.indexOf(\"MSIE\") != -1)");
        buf.append("\t\t{");
        buf.append("\t\t\tif ((document.viewerCheck != null) && (document.viewerCheck.object != null))");
        buf.append("\t\t\t{");
        buf.append("\t\t\t\tviewerVersion = document.viewerCheck.object.Version;");
        buf.append("");
        buf.append("\t\t\t\tif (viewerVersion == undefined)");
        buf.append("\t\t\t\t\tviewerVersion = \"Installed\";");
        buf.append("\t\t\t}");
        buf.append("\t\t}");
        buf.append("\n");
        buf.append("\t\treturn viewerVersion;");
        buf.append("\t}");
        buf.append("\n");
        buf.append("</script>");
        buf.append("\n");
        buf.append("<object id=\"viewerCheck\" height=\"10\" width=\"10\" style=\"display:none;\" classid=\"CLSID:354913B2-7190-49C0-944B-1507C9125367\">");
        buf.append("\t<param NAME=\"XFDLID\" VALUE=\"XFDLData\">\n");
        buf.append("<!--[if !IE]>\n");
        buf.append("Mozilla 1.x, Firefox 1.x, Netscape 7+ and others will use the inner object, the nested object\n");
        buf.append("-->\n");
        buf.append("\t<object id=\"Form1\" type=\"application/vnd.xfdl\"");
        buf.append("\t\t<param NAME=\"XFDLID\" VALUE=\"XFDLData\">");
        buf.append("\t</object>\n");
        buf.append("<!--<![endif]-->\n");
        buf.append("</object>");
        buf.append("\n");
        buf.append("<script language=\"XFDL\" id=\"XFDLData\" type=\"application/vnd.xfdl; wrapped=comment\">");
        buf.append("<!--<XFDL xmlns=\"http://www.PureEdge.com/XFDL/6.2\" xmlns:custom=\"http://www.PureEdge.com/XFDL/Custom\" xmlns:designer=\"http://www.PureEdge.com/Designer/6.1\" xmlns:xfdl=\"http://www.PureEdge.com/XFDL/6.2\">");
        buf.append("\t<globalpage sid=\"global\">");
        buf.append("\t\t<global sid=\"global\">");
        buf.append("\t\t\t<formid>");
        buf.append("\t\t\t\t<serialnumber>3A49E751-1D69-492F-8EAE-F090AE5F92B6</serialnumber>");
        buf.append("\t\t\t\t<version>2.3.1</version>");
        buf.append("\t\t\t</formid>");
        buf.append("\t\t\t<vfd_date>31/5/2004</vfd_date>");
        buf.append("\t\t</global>");
        buf.append("\t</globalpage>");
        buf.append("</XFDL>");
        buf.append("-->");
        buf.append("</script>");
        buf.append("\n");
        buf.append("<form name=\"portletBounceForm\" method=\"post\" action=\"" + renderURL + "\">");
        buf.append("\t<input type=\"hidden\" name=\"" + this.uriPrefix + "ViewerVersion\"></input>");
        buf.append("\t<input type=\"hidden\" name=\"" + this.uriPrefix + "UserAgent\"></input>");
        buf.append("</form>\n");
        buf.append("\n");
        buf.append("<script>\n");
        buf.append("\tdocument.portletBounceForm." + this.uriPrefix + "ViewerVersion.value = getViewerVersion();\n");
        buf.append("\tdocument.portletBounceForm." + this.uriPrefix + "UserAgent.value = navigator.userAgent;\n");
        buf.append("\tdocument.portletBounceForm.submit();\n");
        buf.append("</script>\n");
        return buf.toString();
    }

    private String generateViewerHTML(WebformPortletRenderRequest request, WebformPortletRenderResponse response, boolean loadForm) throws PortletException {
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        String refreshURL = sessionBean.getRefreshURL();
        if (sessionBean.getDetachID() == null) {
            sessionBean.setDetachID(new UID().toString());
        }
        String sessionDetachID = sessionBean.getDetachID();
        StringBuffer html = new StringBuffer();
        String viewerScriptLocation = request.getContextPath() + "/PWSForwarder?pwsAction=Resource&amp;pwsLocation=/javascript/viewerJS/";
        html.append("\n");
        html.append("<script type=\"text/javascript\" src=\"" + viewerScriptLocation + "LF_FormNodeP.js\"></script>\n");
        html.append("<script type=\"text/javascript\" src=\"" + viewerScriptLocation + "LF_XFDL.js\"></script>\n");
        html.append("<script type=\"text/javascript\" src=\"" + viewerScriptLocation + "LF_ViewerScript.js\"></script>\n");
        html.append("<script type=\"text/javascript\">\n");
        html.append("\tfunction OnLoadForm()\n");
        html.append("\t{\n");
        html.append("\t\tvar formName = '" + this.getFormname() + "';\n");
        html.append("\t\tvar formFNP = new FormNodeP(formName);\n");
        html.append("\t\tXFDL.registerForm(formFNP, formName);\n");
        html.append("\t}\n\n");
        html.append("\tif(window.addEventListener)\n");
        html.append("\t\twindow.addEventListener('load', OnLoadForm, false);\n");
        html.append("\telse\n");
        html.append("\t\twindow.attachEvent('onload', OnLoadForm);\n");
        html.append("</script>\n\n");
        try {
            if (loadForm) {
                html.append("<script id=\"XFDLData_" + sessionDetachID + "\" language=\"XFDL\" type=\"application/vnd.xfdl; wrapped=comment\">\n");
                html.append("<!--");
                html.append(new String(response.getBytes(), "UTF-8"));
                html.append("-->\n");
                html.append("</script>");
            }
            html.append("<div id=\"divID\">\n");
            html.append("\t<script type=\"text/javascript\">\n");
            html.append("\t\taddViewer('divID', '" + this.getFormname() + "', " + this.portletWidth + ", " + this.portletHeight + "\n");
            html.append("\t\t\t, 'detach_id', '" + sessionDetachID + "'\n");
            html.append("\t\t\t, 'TTL', '" + this.viewerTTL + "'\n");
            html.append("\t\t\t, 'PortletURL', '" + new URL(request.getScheme(), request.getServerName(), request.getServerPort(), response.createActionURL().toString()).toString() + "'\n");
            if (refreshURL != null) {
                html.append("\t\t\t, 'refresh_URL', '" + refreshURL + "'\n");
            }
            if (loadForm) {
                html.append("\t\t\t, 'XFDLID', 'XFDLData_" + sessionDetachID + "'\n");
            }
            html.append("\t\t);\n");
            html.append("\t</script>\n");
            html.append("</div>\n\n");
        }
        catch (UnsupportedEncodingException uee) {
            if (this.usePWS) {
                this.logger.writeThrowableErrorLog(uee);
            }
            throw new PortletException((Throwable)uee);
        }
        catch (IOException uee) {
            if (this.usePWS) {
                this.logger.writeThrowableErrorLog(uee);
            }
            throw new PortletException((Throwable)uee);
        }
        return html.toString();
    }

    private String generateUserAgentHTML(String renderURL) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form name=\"portletBounceForm\" method=\"post\" action=\"" + renderURL + "\">");
        buf.append("\t<input type=\"hidden\" name=\"" + this.uriPrefix + "UserAgent\"></input>");
        buf.append("</form>\n");
        buf.append("\n");
        buf.append("<script>\n");
        buf.append("\tdocument.portletBounceForm." + this.uriPrefix + "UserAgent.value = navigator.userAgent;\n");
        buf.append("\tdocument.portletBounceForm.submit();\n");
        buf.append("</script>\n");
        return buf.toString();
    }

    public PortletContext getPortletContext() {
        return new WebformPortletContext(super.getPortletContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String openForm(String returnType, WebformPortletRenderRequest request, WebformPortletRenderResponse response) throws IOException, PortletException {
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        String portalNamespace = this.getNamespace(response);
        sessionBean.setPortalNamespace(portalNamespace);
        String formFilename = sessionBean.getFormFilename();
        if (formFilename == null) {
            formFilename = "form.xfdl";
        }
        String openParameters = null;
        if ("html".equalsIgnoreCase(returnType)) {
            openParameters = this.uriPrefix + "Action=open&";
        } else {
            if (!"xfdl".equalsIgnoreCase(returnType)) throw new IllegalArgumentException("returnType must be either \"html\" or \"xfdl\"");
            openParameters = this.uriPrefix + "Action=opensave&" + this.uriPrefix + "Inline=true&";
        }
        if (sessionBean.getTemplateId() == null) {
            String formInstance;
            String revisionNumber;
            URL pwsServerURL = new URL(this.translatorLocation + "/Translate?" + openParameters + this.buildQueryString(sessionBean, response.createActionURL().toString(), request.getContextPath(), false, request.getLocale()));
            String boundary = MultiPartFormOutputStream.createBoundary();
            URLConnection pwsConn = MultiPartFormOutputStream.createConnection(pwsServerURL);
            pwsConn.setRequestProperty("Accept", "*/*");
            pwsConn.setRequestProperty("Content-Type", MultiPartFormOutputStream.getContentType(boundary));
            pwsConn.setRequestProperty("Connection", "Keep-Alive");
            pwsConn.setRequestProperty("Cache-Control", "no-cache");
            pwsConn.setRequestProperty("uriprefix", this.uriPrefix);
            pwsConn.setRequestProperty("ws-portal-namespace", portalNamespace);
            String cookieHeader = sessionBean.getTranslatorCookieHeader();
            if (cookieHeader != null) {
                pwsConn.setRequestProperty("cookie", cookieHeader);
            }
            MultiPartFormOutputStream out = new MultiPartFormOutputStream(pwsConn.getOutputStream(), boundary);
            out.writeFile("openFilePicker", "application/vnd.xfdl", URLEncoder.encode(formFilename), response.getBytes());
            out.close();
            ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
            InputStream httpInStream = pwsConn.getInputStream();
            int bytesRead2 = -1;
            byte[] buf = new byte[32000];
            while ((bytesRead2 = httpInStream.read(buf)) != -1) {
                bufOut.write(buf, 0, bytesRead2);
            }
            String setCookieValue = pwsConn.getHeaderField("set-cookie");
            if (setCookieValue != null) {
                sessionBean.setTranslatorCookieHeader(setCookieValue);
            }
            if ((revisionNumber = pwsConn.getHeaderField("ws-revision-number")) != null) {
                sessionBean.setRevisionNumber(revisionNumber);
            }
            if ((formInstance = pwsConn.getHeaderField("ws-form-instance")) == null) return bufOut.toString("UTF-8");
            sessionBean.setFormInstance(formInstance);
            return bufOut.toString("UTF-8");
        }
        InputStream pwsInStream = null;
        ByteArrayOutputStream bufOut = null;
        String result = null;
        PostMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        String path = "/Translate?" + openParameters + this.uriPrefix + "TemplateId=" + URLEncoder.encode(sessionBean.getTemplateId(), "UTF-8") + "&" + this.uriPrefix + "FormName=" + formFilename + "&" + this.buildQueryString(sessionBean, response.createActionURL().toString(), request.getContextPath(), false, request.getLocale());
        try {
            try {
                int bytesRead;
                method = new PostMethod(this.translatorLocation + path);
                method.setRequestHeader("uriprefix", this.uriPrefix);
                method.setRequestHeader("ws-portal-namespace", portalNamespace);
                List xFormsInstances = this.getXFormsInstances((PortletRequest)request);
                if (xFormsInstances.size() > 0) {
                    XFormsInstancePart[] parts = new XFormsInstancePart[xFormsInstances.size()];
                    for (int i = 0; i < xFormsInstances.size(); ++i) {
                        XFormsInstanceDetails details = (XFormsInstanceDetails)xFormsInstances.get(i);
                        parts[i] = new XFormsInstancePart(details);
                    }
                    method.removeRequestHeader("Content-Type");
                    method.removeRequestHeader("Content-Length");
                    method.setRequestEntity((RequestEntity)new MultipartRequestEntity((Part[])parts, method.getParams()));
                } else {
                    method.setRequestHeader("Content-Type", "application/vnd.xfdl");
                }
                String cookieHeader = sessionBean.getTranslatorCookieHeader();
                if (cookieHeader != null) {
                    method.setRequestHeader("cookie", cookieHeader);
                }
                client.executeMethod((HttpMethod)method);
                pwsInStream = new BufferedInputStream(method.getResponseBodyAsStream());
                bufOut = new ByteArrayOutputStream();
                byte[] buf = new byte[32000];
                while ((bytesRead = pwsInStream.read(buf)) != -1) {
                    bufOut.write(buf, 0, bytesRead);
                }
                pwsInStream.close();
                pwsInStream = null;
                header = method.getResponseHeader("content-type");
                if (header != null) {
                    response.setContentType(header.getValue());
                }
                this.setCommonSessionAttrs(sessionBean, (HttpMethod)method);
                result = bufOut.toString("UTF-8");
            }
            catch (MalformedURLException e) {
                throw new PortletException((Throwable)e);
            }
            catch (ProtocolException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            Object var22_36 = null;
        }
        catch (Throwable throwable) {
            Object var22_37 = null;
            try {
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (method == null) throw throwable;
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (method == null) return result;
        method.releaseConnection();
        return result;
    }

    private String getNamespace(WebformPortletRenderResponse response) {
        String trimmedNamespace = response.getNamespace();
        String prefix = "PC_";
        String postfix = "_";
        return trimmedNamespace.substring(prefix.length(), trimmedNamespace.length() - postfix.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String submitToPWS(ActionRequest request, WebformPortletActionResponse response) throws PortletException {
        InputStream pwsInStream = null;
        OutputStream pwsOutStream = null;
        ByteArrayOutputStream bufOut = null;
        String result = null;
        PostMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        String path = "/Translate?" + this.buildQueryString(sessionBean, sessionBean.getActionURL(), request.getContextPath(), true, request.getLocale());
        try {
            try {
                int bytesRead;
                method = new PostMethod(this.translatorLocation + path);
                method.setRequestHeader("Content-Type", request.getContentType());
                method.setRequestHeader("uriprefix", this.uriPrefix);
                method.setRequestHeader("ws-portal-namespace", sessionBean.getPortalNamespace());
                String cookieHeader = sessionBean.getTranslatorCookieHeader();
                if (cookieHeader != null) {
                    method.setRequestHeader("cookie", cookieHeader);
                }
                method.setRequestBody(request.getPortletInputStream());
                client.executeMethod((HttpMethod)method);
                pwsInStream = new BufferedInputStream(method.getResponseBodyAsStream());
                bufOut = new ByteArrayOutputStream();
                byte[] buf = new byte[32000];
                while ((bytesRead = pwsInStream.read(buf)) != -1) {
                    bufOut.write(buf, 0, bytesRead);
                }
                pwsInStream.close();
                pwsInStream = null;
                header = method.getResponseHeader("xformsreplaceall");
                if (header != null) {
                    this.setReplaceAll(header.getValue().compareToIgnoreCase("true") == 0);
                }
                if ((header = method.getResponseHeader("content-type")) != null) {
                    response.setContentType(header.getValue());
                }
                this.setCommonSessionAttrs(sessionBean, (HttpMethod)method);
                result = bufOut.toString("UTF-8");
            }
            catch (MalformedURLException e) {
                throw new PortletException((Throwable)e);
            }
            catch (ProtocolException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {
                if (pwsOutStream != null) {
                    pwsOutStream.close();
                }
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (method == null) throw throwable;
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (pwsOutStream != null) {
            pwsOutStream.close();
        }
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (method == null) return result;
        method.releaseConnection();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retrieveToolbeltForm(WebformPortletActionRequest request, WebformPortletActionResponse response) throws PortletException {
        InputStream pwsInStream = null;
        ByteArrayOutputStream bufOut = null;
        String result = null;
        GetMethod method = null;
        Header header = null;
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        WebformPortletSessionBean sessionBean = this.getSessionBean((PortletRequest)request);
        String path = "/Translate?" + this.uriPrefix + "Action=toolbelt&" + this.buildQueryString(sessionBean, sessionBean.getActionURL(), request.getContextPath(), false, request.getLocale());
        try {
            try {
                int bytesRead;
                method = new GetMethod(this.translatorLocation + path);
                method.setRequestHeader("uriprefix", this.uriPrefix);
                method.setRequestHeader("ws-portal-namespace", sessionBean.getPortalNamespace());
                String cookieHeader = sessionBean.getTranslatorCookieHeader();
                if (cookieHeader != null) {
                    method.setRequestHeader("cookie", cookieHeader);
                }
                client.executeMethod((HttpMethod)method);
                pwsInStream = new BufferedInputStream(method.getResponseBodyAsStream());
                bufOut = new ByteArrayOutputStream();
                byte[] buf = new byte[32000];
                while ((bytesRead = pwsInStream.read(buf)) != -1) {
                    bufOut.write(buf, 0, bytesRead);
                }
                pwsInStream.close();
                pwsInStream = null;
                header = method.getResponseHeader("content-type");
                if (header != null) {
                    response.setContentType(header.getValue());
                }
                this.setCommonSessionAttrs(sessionBean, (HttpMethod)method);
                result = bufOut.toString("UTF-8");
            }
            catch (MalformedURLException e) {
                throw new PortletException((Throwable)e);
            }
            catch (ProtocolException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            try {
                if (pwsInStream != null) {
                    pwsInStream.close();
                }
                if (method == null) throw throwable;
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (pwsInStream != null) {
            pwsInStream.close();
        }
        if (method == null) return result;
        method.releaseConnection();
        return result;
    }

    private String buildQueryString(WebformPortletSessionBean sessionBean, String url, String contextPath, boolean useParams, Locale locale) {
        String userAgent;
        StringBuffer buf = new StringBuffer();
        if (useParams) {
            boolean first = true;
            Enumeration enumP = sessionBean.getParameterNames();
            while (enumP.hasMoreElements()) {
                String name = (String)enumP.nextElement();
                if (!first) {
                    buf.append("&");
                } else {
                    first = false;
                }
                buf.append(name);
                buf.append("=");
                buf.append(URLEncoder.encode(sessionBean.getParameter(name)));
            }
            buf.append("&");
        }
        buf.append(this.uriPrefix + "RenderWidth=" + this.portletWidth);
        buf.append("&");
        buf.append(this.uriPrefix + "RenderHeight=" + this.portletHeight);
        buf.append("&");
        buf.append(this.uriPrefix + "MinRenderWidth=" + this.minPortletWidth);
        buf.append("&");
        buf.append(this.uriPrefix + "MinRenderHeight=" + this.minPortletHeight);
        buf.append("&");
        buf.append(this.uriPrefix + "PortletFormBorder=" + this.showFormBorder);
        buf.append("&");
        buf.append(this.uriPrefix + "PortletContextPath=");
        buf.append(URLEncoder.encode(contextPath));
        buf.append("&");
        buf.append(this.uriPrefix + "RenderMode=portlet");
        if (buf.toString().indexOf("customFormName") < 0) {
            buf.append("&");
            buf.append(this.uriPrefix + "customFormName=" + this.getFormname());
        }
        if ((userAgent = sessionBean.getUserAgent()) != null) {
            buf.append("&");
            buf.append(this.uriPrefix + "UserAgent=" + URLEncoder.encode(userAgent));
        }
        String language = locale.getLanguage().toLowerCase();
        String country = locale.getCountry().toUpperCase();
        String localeCode = language;
        if (country != null && !country.equals("")) {
            localeCode = localeCode + "_" + country;
        }
        buf.append("&" + this.uriPrefix + "PortletLocale=" + localeCode);
        if (url != null) {
            String updateActionStr = url;
            int index = updateActionStr.lastIndexOf(35);
            if (index > 0) {
                updateActionStr = updateActionStr.substring(0, index);
            }
            buf.append("&" + this.uriPrefix + "PortletUpdatePath=");
            buf.append(URLEncoder.encode(updateActionStr));
        }
        return buf.toString();
    }

    public void formCancelled(PortletRequest request) throws PortletException {
        this.getSessionBean(request).setState(2);
    }

    private WebformPortletSessionBean getSessionBean(PortletRequest request) throws PortletException {
        WebformPortletSessionBean sessionBean = null;
        PortletSession session = request.getPortletSession();
        if (session != null) {
            sessionBean = (WebformPortletSessionBean)session.getAttribute(SESSION_BEAN, 2);
            if (sessionBean == null) {
                sessionBean = new WebformPortletSessionBean();
                session.setAttribute(SESSION_BEAN, (Object)sessionBean, 2);
            }
        } else {
            throw new PortletException("Unable to retrieve a session. Sessions must be enabled for this portlet.");
        }
        return sessionBean;
    }

    private List getXFormsInstances(PortletRequest request) throws PortletException {
        return this.getSessionBean(request).getXFormsInstances();
    }

    public void addXFormsInstance(PortletRequest request, String modelId, String nodeRef, int flags, String modelData) throws PortletException {
        this.getSessionBean(request).addXFormsInstance(modelId, nodeRef, flags, modelData);
    }

    public void setRefreshURL(PortletRequest request, String url) throws PortletException {
        this.getSessionBean(request).setRefreshURL(url);
    }

    public String getRefreshURL(PortletRequest request) throws PortletException {
        return this.getSessionBean(request).getRefreshURL();
    }

    public void useXFDL(PortletRequest request, boolean newValue) throws PortletException {
        this.getSessionBean(request).setUseViewer(newValue);
    }

    public void useHTML(PortletRequest request, boolean newValue) throws PortletException {
        this.getSessionBean(request).setUsePWS(newValue);
    }

    public String getViewerVersion(PortletRequest request) throws PortletException {
        String viewerVersion = this.getSessionBean(request).getInstalledViewer();
        if (viewerVersion != null && viewerVersion.equals("none")) {
            viewerVersion = null;
        }
        return viewerVersion;
    }

    public String getFilename(PortletRequest request) throws PortletException {
        return this.getSessionBean(request).getFormFilename();
    }

    public void setFilename(PortletRequest request, String filename) throws PortletException {
        this.getSessionBean(request).setFormFilename(filename);
    }

    public void setFormname(String formname) {
        this.customFormName = formname;
    }

    public String getFormname() {
        if (this.customFormName == null) {
            return "customFormName";
        }
        return this.customFormName;
    }

    public void setTemplateId(PortletRequest request, String templateId) throws PortletException {
        this.getSessionBean(request).setTemplateId(templateId);
    }

    public void resetPortlet(PortletRequest request) throws PortletException {
        this.getSessionBean(request).reset();
    }

    public String utf8URLEncode(String value) {
        return UTF8URLEncoder.encode((String)value);
    }

    public String utf8URLDecode(String value) {
        return UTF8URLDecoder.decode((String)value);
    }

    public boolean isReplaceAll() {
        return (Boolean)this.replaceAll.get();
    }

    private void setReplaceAll(boolean replaceAllValue) {
        this.replaceAll.set(new Boolean(replaceAllValue));
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public abstract void processActionEx(ActionRequest var1, ActionResponse var2) throws PortletException, IOException;

    public abstract void doViewEx(RenderRequest var1, RenderResponse var2) throws PortletException, IOException;

    protected void setViewerParam(RenderResponse response, String name, String value) {
        ((WebformPortletRenderResponse)response).setViewerParameter(name, value);
    }
}

