/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework.portlet;

import com.ibm.form.webform.framework.portlet.BufferingOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends BufferingOutputStream {
    private int totalEncodedBytes = 0;
    private boolean isClosing = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64OutputStream(OutputStream out) {
        super(out, 31875);
    }

    protected void flushBuffer() throws IOException {
        if (this.count > 0) {
            int leftOver = this.count % 3;
            if (this.isClosing) {
                leftOver = 0;
            }
            byte[] theBytes = this.base64Encode(this.theBuffer, this.count - leftOver, true);
            this.out.write(theBytes, 0, theBytes.length);
            if (leftOver > 0 && this.count != leftOver) {
                System.arraycopy(this.theBuffer, this.count - leftOver, this.theBuffer, 0, leftOver);
            }
            this.count = leftOver;
        }
    }

    private byte[] base64Encode(byte[] data, int theLength, boolean doCrLfs) {
        int j;
        if (data == null) {
            return null;
        }
        int leftover = theLength % 3;
        int threes = theLength / 3;
        int totalOut = threes * 4 + (leftover == 0 ? 0 : 4);
        if (doCrLfs) {
            int testBytes;
            totalOut += (testBytes = this.totalEncodedBytes % 76 + totalOut) % 76 == 0 ? testBytes / 76 - 1 : testBytes / 76;
        }
        int offset = 0;
        int dataOutPtr = 0;
        byte[] dataOut = new byte[totalOut];
        byte[] dataBack = new byte[4];
        for (int i = 0; i < threes; ++i) {
            offset = i * 3;
            dataBack = this.encodeAtom(data, offset, 3);
            for (j = 0; j < 4; ++j) {
                ++this.totalEncodedBytes;
                dataOut[dataOutPtr++] = dataBack[j];
            }
            if (!doCrLfs || this.totalEncodedBytes % 76 != 0 || i == threes - 1) continue;
            dataOut[dataOutPtr++] = 10;
        }
        if (leftover != 0) {
            offset = threes * 3;
            dataBack = this.encodeAtom(data, offset, leftover);
            for (j = 0; j < 4; ++j) {
                dataOut[dataOutPtr++] = dataBack[j];
            }
        }
        return dataOut;
    }

    public void close() throws IOException {
        this.isClosing = true;
        super.close();
    }

    private byte[] encodeAtom(byte[] data, int offset, int len) {
        byte[] dataOut = new byte[4];
        if (len == 1) {
            byte a = data[offset];
            int b = 0;
            boolean c = false;
            dataOut[0] = (byte)pem_array[a >>> 2 & 0x3F];
            dataOut[1] = (byte)pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            dataOut[2] = 61;
            dataOut[3] = 61;
        } else if (len == 2) {
            byte a = data[offset];
            byte b = data[offset + 1];
            int c = 0;
            dataOut[0] = (byte)pem_array[a >>> 2 & 0x3F];
            dataOut[1] = (byte)pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            dataOut[2] = (byte)pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            dataOut[3] = 61;
        } else {
            byte a = data[offset];
            byte b = data[offset + 1];
            byte c = data[offset + 2];
            dataOut[0] = (byte)pem_array[a >>> 2 & 0x3F];
            dataOut[1] = (byte)pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            dataOut[2] = (byte)pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            dataOut[3] = (byte)pem_array[c & 0x3F];
        }
        return dataOut;
    }
}

