/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework;

import com.ibm.form.webform.pws.XFormsInstanceDetails;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.util.EncodingUtil;

public class XFormsInstancePart
extends PartBase {
    private static final String NAME_PREFIX = "XForms-Instances";
    private static int nextPartNumber = 0;
    private static final String CHAR_SET = "UTF-8";
    public static final String CONTENT_TYPE = "xforms-instance";
    protected static final byte[] NULL_BYTE = new byte[]{0};
    private byte[] modelIdBytes = null;
    private byte[] nodeRefBytes = null;
    private byte[] flagBytes = null;
    private byte[] instanceBytes = null;

    public XFormsInstancePart(XFormsInstanceDetails details) {
        super(NAME_PREFIX + Integer.toString(nextPartNumber++), CONTENT_TYPE, CHAR_SET, null);
        if (details.getNodeRef() == null) {
            throw new IllegalArgumentException("Node Ref in XFormsInstanceDetails is null");
        }
        if (details.getModel() == null) {
            throw new IllegalArgumentException("Model in XFormsInstanceDetails is null");
        }
        this.modelIdBytes = this.encodeString(details.getModelId());
        this.nodeRefBytes = this.encodeString(details.getNodeRef());
        this.flagBytes = this.encodeString(Integer.toString(details.getFlags()));
        this.instanceBytes = this.encodeString(details.getModel());
    }

    private byte[] encodeString(String s) {
        byte[] ba;
        if (s == null) {
            ba = new byte[]{};
        } else {
            if (s.trim().length() == 0) {
                s = " ";
            }
            ba = EncodingUtil.getBytes((String)s, (String)this.getCharSet());
        }
        return ba;
    }

    protected long lengthOfData() throws IOException {
        return this.modelIdBytes.length + Part.CRLF_BYTES.length + this.nodeRefBytes.length + Part.CRLF_BYTES.length + this.flagBytes.length + Part.CRLF_BYTES.length + this.instanceBytes.length + Part.CRLF_BYTES.length;
    }

    protected void sendData(OutputStream os) throws IOException {
        os.write(this.modelIdBytes);
        os.write(Part.CRLF_BYTES);
        os.write(this.nodeRefBytes);
        os.write(Part.CRLF_BYTES);
        os.write(this.flagBytes);
        os.write(Part.CRLF_BYTES);
        os.write(this.instanceBytes);
        os.write(Part.CRLF_BYTES);
    }
}

