/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework;

import com.ibm.form.webform.framework.TemplateManagerException;
import com.ibm.form.webform.resourcestore.FormTemplate;
import com.ibm.form.webform.resourcestore.FormTemplate_Stream;
import com.ibm.form.webform.resourcestore.RemoteResourceProvider;
import com.ibm.form.webform.resourcestore.RemoteResourceProviderRESTImpl;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.ResourceProviderException;
import com.ibm.form.webform.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;

public class TemplateManager {
    private RemoteResourceProvider formTemplateResourceProvider = null;
    String translatorLocation;
    static int MAX_ID_LENGTH = 80;
    static int MAX_APP_ID_LENGTH = 37;

    public TemplateManager(String translatorLocation) {
        this.translatorLocation = translatorLocation;
        this.formTemplateResourceProvider = new RemoteResourceProviderRESTImpl(this.translatorLocation);
    }

    public boolean isFormTemplateInstalled(String templateId) throws TemplateManagerException {
        try {
            return this.formTemplateResourceProvider.doesExist(FormTemplate.buildURI((String)templateId), null);
        }
        catch (URISyntaxException e) {
            throw new TemplateManagerException("Form template id \"" + templateId + "\" is an invalid id.", e);
        }
        catch (ResourceProviderException e) {
            throw new TemplateManagerException("Cannot determine if form template \"" + templateId + "\" is installed.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateManagerException(e);
        }
    }

    public void addFormTemplate(String templateId, InputStream templateStream) throws TemplateManagerException {
        FormTemplate_Stream template = null;
        try {
            byte[] templateContent = StreamUtils.toByteArray((InputStream)templateStream);
            template = new FormTemplate_Stream(templateId, templateContent);
            this.formTemplateResourceProvider.put(template.getURI(), (StoredResource)template, 2, null);
        }
        catch (IOException ioe) {
            throw new TemplateManagerException("Error reading from template stream.", ioe);
        }
        catch (ResourceProviderException rpe) {
            throw new TemplateManagerException("Cannot add form template \"" + template.getId() + "\" to the system.", rpe);
        }
        catch (URISyntaxException use) {
            throw new TemplateManagerException("Invalid form template id.", use);
        }
    }

    public void replaceFormTemplate(String templateId, InputStream templateStream) throws TemplateManagerException {
        FormTemplate_Stream template = null;
        try {
            byte[] templateContent = StreamUtils.toByteArray((InputStream)templateStream);
            template = new FormTemplate_Stream(templateId, templateContent);
            this.formTemplateResourceProvider.put(template.getURI(), (StoredResource)template, 1, null);
        }
        catch (IOException ioe) {
            throw new TemplateManagerException("Error reading from template stream.", ioe);
        }
        catch (ResourceProviderException rpe) {
            throw new TemplateManagerException("Failed to replace form template in system.", rpe);
        }
        catch (URISyntaxException use) {
            throw new TemplateManagerException("Invalid form template id.", use);
        }
    }

    public void removeFormTemplate(String templateId) throws TemplateManagerException {
        try {
            this.formTemplateResourceProvider.remove(FormTemplate.buildURI((String)templateId), null);
        }
        catch (URISyntaxException e) {
            throw new TemplateManagerException("Form template id \"" + templateId + "\" is an invalid id.", e);
        }
        catch (ResourceProviderException e) {
            throw new TemplateManagerException("Failed to remove form template to system.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateManagerException(e);
        }
    }

    static int setMaxIdLength(int newMaxIdLength) {
        int formerValue = MAX_ID_LENGTH;
        MAX_ID_LENGTH = newMaxIdLength;
        return formerValue;
    }

    static int setMaxAppIdLength(int newMaxAppIdLength) {
        int formerValue = MAX_APP_ID_LENGTH;
        MAX_ID_LENGTH = newMaxAppIdLength;
        return formerValue;
    }
}

