/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework;

import com.ibm.form.webform.framework.FrameworkUtils;
import com.ibm.form.webform.framework.HttpResource;
import com.ibm.form.webform.framework.HttpResourceAccessCredentials;
import com.ibm.form.webform.logging.Logger;
import com.ibm.form.webform.resourcestore.RemoteResourceProvider;
import com.ibm.form.webform.resourcestore.ResourceAccessCredentials;
import com.ibm.form.webform.resourcestore.StoredResource;
import com.ibm.form.webform.resourcestore.exceptions.InvalidCredentialsException;
import com.ibm.form.webform.resourcestore.exceptions.ResourceExistsException;
import com.ibm.form.webform.resourcestore.exceptions.UnhandledResourceTypeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class HttpResourceProvider
implements RemoteResourceProvider {
    public static final int DEFAULT_CACHING_SIZE_THRESHOLD_BYTES = 0x100000;
    private static final String CACHE_NAME = "translatorHttpCache";
    protected final long cachingSizeThreshold_bytes;
    private String uriPrefix = "";
    protected Cache cache = null;

    public HttpResourceProvider(String uriPrefix, CacheManager cacheManager, Logger logger) {
        this(uriPrefix, cacheManager, logger, 0x100000L);
    }

    public HttpResourceProvider(String uriPrefix, CacheManager cacheManager, Logger logger, String cachingSizeThresholdText) {
        this(uriPrefix, cacheManager, logger, HttpResourceProvider.getCachingSizeThreshold(logger, cachingSizeThresholdText));
    }

    public HttpResourceProvider(String uriPrefix, CacheManager cacheManager, Logger logger, long cachingSizeThreshold_bytes) {
        logger.writeDebugLog("Starting HttpResourceProvider.", null, null);
        this.uriPrefix = uriPrefix == null || "".equalsIgnoreCase(uriPrefix) ? "" : uriPrefix;
        if (!cacheManager.cacheExists(CACHE_NAME)) {
            logger.writeDebugLog("Creating translatorHttpCache with default values.", null, null);
            cacheManager.addCache(CACHE_NAME);
        }
        this.cache = CacheManager.getInstance().getCache(CACHE_NAME);
        this.cachingSizeThreshold_bytes = cachingSizeThreshold_bytes;
    }

    public boolean doesExist(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException {
        return false;
    }

    public boolean doesHandleResourceType(String scheme) {
        return "http".equalsIgnoreCase(scheme);
    }

    public StoredResource get(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException {
        HttpResourceAccessCredentials credentials = null;
        try {
            credentials = (HttpResourceAccessCredentials)userCredentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException();
        }
        String key = id.toString() + "&" + credentials.getHeaderValue("accept-language");
        Element element = this.cache.get((Serializable)((Object)key));
        if (element != null) {
            return (StoredResource)element.getObjectValue();
        }
        HttpResource resource = this.getResource(id, credentials);
        if (resource != null && resource.getData() != null && (long)resource.getData().length < this.cachingSizeThreshold_bytes) {
            this.cache.put(new Element((Serializable)((Object)key), (Serializable)((Object)resource)));
        }
        return resource;
    }

    public boolean put(URI id, StoredResource r, int replacePolicy, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException, ResourceExistsException {
        return false;
    }

    public boolean remove(URI id, ResourceAccessCredentials userCredentials) throws InvalidCredentialsException, UnhandledResourceTypeException {
        this.cache.remove((Serializable)((Object)id.toString()));
        return true;
    }

    private HttpResource getResource(URI id, HttpResourceAccessCredentials credentials) throws UnhandledResourceTypeException {
        HttpResource resource = new HttpResource(id);
        int httpResponseCode = 0;
        httpResponseCode = this.fillResource(id, credentials, resource);
        if (httpResponseCode == 304 || httpResponseCode == 404) {
            return null;
        }
        return resource;
    }

    private int fillResource(URI id, HttpResourceAccessCredentials credentials, HttpResource resource) throws UnhandledResourceTypeException {
        if (resource == null) {
            throw new IllegalArgumentException("resource to fill cannot be null");
        }
        int translatorResponseCode = Integer.MIN_VALUE;
        try {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)id.toURL().openConnection();
            }
            catch (ClassCastException e) {
                throw new UnhandledResourceTypeException();
            }
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            this.copyHeaders(credentials, connection);
            connection.addRequestProperty("uriprefix", this.uriPrefix);
            connection.addRequestProperty("x-ws-referer", credentials.getReferer());
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            translatorResponseCode = connection.getResponseCode();
            if (translatorResponseCode != 500) {
                resource.setResponseCode(translatorResponseCode);
                resource.setCredentials(credentials);
                int loop = 0;
                String keyName = connection.getHeaderFieldKey(loop);
                String keyValue = connection.getHeaderField(loop);
                while (keyName != null || keyValue != null) {
                    if (!(keyName == null || "cookie".equalsIgnoreCase(keyName) || "set-cookie".equalsIgnoreCase(keyName) || FrameworkUtils.isRestrictedHeader(keyName))) {
                        resource.setHeader(keyName, keyValue);
                    }
                    keyName = connection.getHeaderFieldKey(++loop);
                    keyValue = connection.getHeaderField(loop);
                }
                InputStream in = connection.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int c = 0;
                int BUFFER_SIZE = 32000;
                byte[] buffer = new byte[32000];
                while ((c = in.read(buffer, 0, 32000)) > 0) {
                    baos.write(buffer, 0, c);
                }
                resource.setData(baos.toByteArray());
            }
        }
        catch (MalformedURLException e) {
            throw new UnhandledResourceTypeException();
        }
        catch (IOException e) {
            // empty catch block
        }
        return translatorResponseCode;
    }

    private void copyHeaders(HttpResourceAccessCredentials credentials, HttpURLConnection connection) {
        Iterator iterator = credentials.getHeaderNames().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = credentials.getHeaderValue(key);
            if (FrameworkUtils.isRestrictedHeader(key)) continue;
            connection.addRequestProperty(key, value);
        }
    }

    private static long getCachingSizeThreshold(Logger logger, String cachingSizeThresholdText) {
        if (cachingSizeThresholdText != null) {
            try {
                return Long.parseLong(cachingSizeThresholdText);
            }
            catch (NumberFormatException e) {
                logger.writeErrorLog("Invalid caching size threshold \"" + cachingSizeThresholdText + "\"; must be a number", null, null, null, null);
            }
        }
        return 0x100000L;
    }
}

