/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.framework;

import com.ibm.form.webform.framework.HttpResource;
import com.ibm.form.webform.framework.servlet.WebformServletSessionBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FrameworkUtils {
    private static final String SESSION_BEAN = "WebformServletSessionBean";
    private static final String versionRegex = "[0-9]{1,}(\\.[0-9]{1,}){1,}";
    private static HashMap verMappings = new HashMap();
    private static HashMap cssFileCache;
    private static HashMap cssFileCacheCreatedTime;

    public static String getInternalVersion(String version) {
        String versionString = null;
        String returnVersion = null;
        Pattern pattern = null;
        Matcher matcher = null;
        if (version == null) {
            return null;
        }
        pattern = Pattern.compile(versionRegex);
        matcher = pattern.matcher(version);
        if (matcher.find()) {
            int end;
            int start = matcher.start();
            versionString = version.substring(start, end = matcher.end());
            if (versionString != null) {
                String majorVer = null;
                String minorVer = null;
                String maintVer = null;
                String buildVer = null;
                String[] verParts = versionString.split("\\.");
                block6: for (int j = 0; j < verParts.length; ++j) {
                    switch (j) {
                        case 0: {
                            majorVer = verParts[j];
                            continue block6;
                        }
                        case 1: {
                            minorVer = verParts[j];
                            continue block6;
                        }
                        case 2: {
                            maintVer = verParts[j];
                            continue block6;
                        }
                        case 3: {
                            buildVer = verParts[j];
                        }
                    }
                }
                String lookup = majorVer + (minorVer != null ? "." + minorVer : "") + (maintVer != null ? "." + maintVer : "");
                returnVersion = (String)verMappings.get(lookup);
                if (returnVersion != null) {
                    if (minorVer == null) {
                        returnVersion = returnVersion + ".0";
                    }
                    if (maintVer == null) {
                        returnVersion = returnVersion + ".0";
                    }
                    returnVersion = buildVer == null ? returnVersion + ".0" : returnVersion + "." + buildVer;
                } else {
                    returnVersion = majorVer + (minorVer != null ? "." + minorVer : ".0") + (maintVer != null ? "." + maintVer : ".0") + (buildVer != null ? "." + buildVer : ".0");
                }
            }
        } else {
            returnVersion = version;
        }
        return returnVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processMappingConfig(String fileLocation) throws FileNotFoundException, IOException {
        File mappingFile = new File(fileLocation);
        if (!mappingFile.exists()) return;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(mappingFile);
            Properties props = new Properties();
            props.load(fis);
            Enumeration propsEnum = ((Hashtable)props).keys();
            while (propsEnum.hasMoreElements()) {
                String propKey = (String)propsEnum.nextElement();
                String propValue = props.getProperty(propKey);
                verMappings.put(propKey, propValue);
            }
            Object var8_7 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fis.close();
            return;
        }
        catch (IOException ioe) {}
    }

    public static WebformServletSessionBean getSessionBean(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebformServletSessionBean sessionBean = (WebformServletSessionBean)session.getAttribute(SESSION_BEAN);
        if (sessionBean == null) {
            sessionBean = new WebformServletSessionBean();
            session.setAttribute(SESSION_BEAN, (Object)sessionBean);
        }
        return sessionBean;
    }

    public static boolean isRestrictedHeader(String headerName) {
        if (headerName == null) {
            return false;
        }
        return headerName.length() == 5 && headerName.toLowerCase().startsWith("$ws");
    }

    private static String normalizeString(String str) {
        try {
            URI uri = new URI(str).normalize();
            return uri.toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static String getParentPath(String requestURL, String locationIdentity) throws Exception {
        String parentPath = "";
        try {
            requestURL = requestURL.replaceAll("localhost", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        String[] splitedRequestURL = requestURL.split("\\?|\\&");
        int length = splitedRequestURL.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (splitedRequestURL[i].indexOf(locationIdentity) < 0) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new Exception("FrameworkUtils.getParentPath : Location Identity not found in the requestURL");
        }
        if (index == length - 1) {
            parentPath = requestURL;
        } else {
            StringBuffer reorderedRequestURL = new StringBuffer(splitedRequestURL[0] + "?");
            for (int i = 1; i < length; ++i) {
                if (i == index) continue;
                reorderedRequestURL.append(splitedRequestURL[i] + "&");
            }
            reorderedRequestURL.append(splitedRequestURL[index]);
            parentPath = reorderedRequestURL.toString();
        }
        parentPath = splitedRequestURL[index].indexOf("/") > 0 ? parentPath.substring(0, parentPath.lastIndexOf("/") + 1) : parentPath + "/";
        return parentPath;
    }

    public static String getFullPath(HttpServletRequest req) {
        StringBuffer fullPath = req.getRequestURL();
        if (req.getQueryString() != null) {
            fullPath.append("?").append(req.getQueryString());
        }
        return fullPath.toString();
    }

    public static String getCorrectedCssFile(HttpServletRequest request) {
        String requestURL = FrameworkUtils.getFullPath(request);
        if (cssFileCache.containsKey(requestURL)) {
            return (String)cssFileCache.get(requestURL);
        }
        return null;
    }

    public static Date getCssCacheFileCreatedTime(HttpServletRequest request) {
        String requestURL = FrameworkUtils.getFullPath(request);
        if (cssFileCacheCreatedTime.containsKey(requestURL)) {
            return (Date)cssFileCacheCreatedTime.get(requestURL);
        }
        return null;
    }

    public static boolean isCssFile(String connectURL) {
        return connectURL.lastIndexOf(".css") > 0;
    }

    public static String substituteCssRelativePaths(String requestURL, String locationIdentity, String str) throws Exception {
        String key = requestURL;
        String folderPath = FrameworkUtils.getParentPath(requestURL, locationIdentity);
        requestURL = requestURL.substring(0, requestURL.lastIndexOf("/") + 1);
        Pattern urlPattern = Pattern.compile("url(\\s*)\\((\\s*)['\"]?\\s*?(.+?)\\)");
        Matcher m = urlPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (m.find(index)) {
            int start = m.start();
            int end = m.end();
            sb.append(str.substring(index, m.start()));
            String match = str.substring(start, end).toString();
            match = match.replaceAll("'", "\"");
            int firstQuoteIndex = match.indexOf("\"");
            String path = "";
            if (firstQuoteIndex >= 0) {
                int lastQuoteIndex = match.lastIndexOf("\"");
                path = match.substring(firstQuoteIndex + 1, lastQuoteIndex).trim();
            } else {
                path = match.substring(match.indexOf("(") + 1, match.lastIndexOf(")")).trim();
            }
            sb.append("url(\"");
            sb.append(FrameworkUtils.normalizeString(folderPath + path));
            sb.append("\")");
            index = m.end();
        }
        sb.append(str.substring(index, str.length()));
        String content = sb.toString();
        cssFileCache.put(key, content);
        cssFileCacheCreatedTime.put(key, new Date());
        return content;
    }

    public static Date parseRfcString(String s) {
        if (s == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        try {
            Date date = dateFormat.parse(s);
            return date;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String formatRfcString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return dateFormat.format(date);
    }

    public static Date getIfModifiedSinceDate(HttpServletRequest request) {
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        return FrameworkUtils.parseRfcString(ifModifiedSince);
    }

    public static boolean isCachedInBrowser(HttpServletRequest request) {
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        return ifModifiedSince != null;
    }

    public static boolean isCachedValidInBrowser(HttpServletRequest request, HttpResource resource) {
        String lastModified = resource.getHeader("Last-Modified");
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (lastModified == null || ifModifiedSince == null) {
            return false;
        }
        if (lastModified.equalsIgnoreCase(ifModifiedSince)) {
            return true;
        }
        Date ifModifiedSinceDate = FrameworkUtils.getIfModifiedSinceDate(request);
        Date lastModifiedDate = FrameworkUtils.parseRfcString(lastModified);
        if (ifModifiedSinceDate == null || lastModifiedDate == null) {
            return false;
        }
        return ifModifiedSince != null && lastModified != null && !ifModifiedSinceDate.before(lastModifiedDate);
    }

    static {
        verMappings.put("2.5", "6.5");
        verMappings.put("2.6", "7.0");
        verMappings.put("2.6.0", "7.0.0");
        verMappings.put("2.6.1", "7.0.1");
        verMappings.put("2.7.0", "7.1.0");
        cssFileCache = new HashMap();
        cssFileCacheCreatedTime = new HashMap();
    }
}

