/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.xslt;

import com.ibm.form.webform.xslt.XSLTParams;
import com.ibm.form.webform.xslt.XSLTProcessor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSLT4JProcessor
implements XSLTProcessor {
    private Templates templates;
    private ErrorListener errorListener;

    public XSLT4JProcessor(String xsltFilename) throws TransformerConfigurationException {
        this(xsltFilename, null);
    }

    public XSLT4JProcessor(String xsltFilename, ErrorListener errorListener) throws TransformerConfigurationException {
        this.errorListener = errorListener;
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        TransformerFactory tf = TransformerFactory.newInstance();
        if (errorListener != null) {
            tf.setErrorListener(errorListener);
        }
        this.templates = tf.newTemplates(new StreamSource(new File(xsltFilename)));
    }

    public void process(String input, XSLTParams params, OutputStream out) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        if (params != null) {
            params.toJDParamSet(transformer);
        }
        if (this.errorListener != null) {
            transformer.setErrorListener(this.errorListener);
        }
        transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(out));
    }

    public void process(InputStream input, XSLTParams params, OutputStream out) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        if (params != null) {
            params.toJDParamSet(transformer);
        }
        if (this.errorListener != null) {
            transformer.setErrorListener(this.errorListener);
        }
        transformer.transform(new StreamSource(input), new StreamResult(out));
    }

    public void process(Document doc, XSLTParams params, OutputStream out) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        if (params != null) {
            params.toJDParamSet(transformer);
        }
        if (this.errorListener != null) {
            transformer.setErrorListener(this.errorListener);
        }
        transformer.transform(new DOMSource(doc), new StreamResult(out));
    }
}

