/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.pws;

import com.ibm.form.webform.resources.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLProperties {
    private LinkedHashMap properties = new LinkedHashMap();
    private LinkedHashMap comments = new LinkedHashMap();

    public void loadFromXML(InputStream propsFile) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce.getMessage());
        }
        try {
            doc = docBuilder.parse(propsFile);
        }
        catch (SAXException se) {
            throw new IOException(ResourceManager.getFormattedErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_PARSING_PROPERTIES_FILE", (String)se.getMessage()));
        }
        Element rootElem = doc.getDocumentElement();
        NodeList childNodes = rootElem.getChildNodes();
        boolean commentFound = false;
        String comment = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element currElem = (Element)child;
            String nodeName = currElem.getNodeName();
            if (nodeName.equals("comment")) {
                commentFound = true;
                comment = this.getFullNodeValue(currElem);
                continue;
            }
            if (!nodeName.equals("entry")) continue;
            String key = currElem.getAttribute("key");
            String value = this.getFullNodeValue(currElem);
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            if (!commentFound) continue;
            if (comment != null) {
                this.comments.put(key, comment);
            }
            commentFound = false;
            comment = null;
        }
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n\n");
        buffer.append("<properties>\n\n");
        Iterator e = this.propertyNames();
        while (e.hasNext()) {
            String propName = (String)e.next();
            String propComment = this.getComment(propName);
            String propValue = this.getProperty(propName, "");
            if (propComment != null) {
                buffer.append("\t<comment>");
                buffer.append(propComment);
                buffer.append("</comment>\n");
            }
            buffer.append("\t<entry key=\"" + propName + "\">");
            buffer.append(propValue);
            buffer.append("</entry>\n\n");
        }
        buffer.append("</properties>\n");
        os.write(buffer.toString().getBytes(encoding));
    }

    private String getFullNodeValue(Element elem) {
        StringBuffer value = new StringBuffer();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Text text;
            String currValue;
            Node currNode = children.item(i);
            if (currNode.getNodeType() != 3 || (currValue = (text = (Text)currNode).getNodeValue()) == null || currValue.length() <= 0) continue;
            value.append(currValue);
        }
        return value.toString();
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String value = null;
        value = (String)this.properties.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getComment(String key) {
        String value = null;
        value = (String)this.comments.get(key);
        return value;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean result = false;
        String value = this.getProperty(key);
        if (value != null && (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1"))) {
            result = true;
        }
        if (value == null) {
            result = defaultValue;
        }
        return result;
    }

    public int getIntProperty(String key, int defaultValue) {
        int result = -1;
        String value = this.getProperty(key);
        result = value != null ? Integer.parseInt(value) : defaultValue;
        return result;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        double result = -1.0;
        String value = this.getProperty(key);
        result = value != null ? Double.parseDouble(value) : defaultValue;
        return result;
    }

    public ArrayList getListProperty(String key, ArrayList defaultValues) {
        ArrayList result = new ArrayList();
        String tempString = this.getProperty(key);
        if (tempString != null) {
            StringTokenizer tokenizer = new StringTokenizer(tempString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token = token.trim()).length() == 0) continue;
                result.add(token);
            }
        }
        return result.size() > 0 ? result : defaultValues;
    }

    public Iterator propertyNames() {
        return ((HashMap)this.properties).keySet().iterator();
    }
}

