/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.pws;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientInfo {
    private final String BROWSER_MSIE_REGEX = "MSIE ([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String BROWSER_NETSCAPE_REGEX = "Netscape/([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String BROWSER_FIREFOX_REGEX = "Firefox/([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String BROWSER_MOZILLA_REGEX = "rv:([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String BROWSER_SAFARI_REGEX = "Safari/([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String BROWSER_SAFARI_VERSION_REGEX = "Version/([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String OS_WINNT_REGEX = "Windows NT ([0-9]{1,}(\\.[0-9]{1,}){1,})";
    private final String OS_WIN9X_REGEX = "Windows 9[58]";
    private final String OS_OSX_REGEX = "Mac OS X";
    private String userAgent;
    private String browserName;
    private String browserVersion;
    private String osName;
    private boolean isMozBrowser = false;

    public ClientInfo(String userAgent) {
        this.userAgent = userAgent;
        if (userAgent != null) {
            this.parseBrowserInfo();
            this.parseOSInfo();
        }
    }

    private void parseBrowserInfo() {
        Pattern pattern = null;
        Matcher matcher = null;
        Matcher safariVersionMatcher = null;
        pattern = Pattern.compile("MSIE ([0-9]{1,}(\\.[0-9]{1,}){1,})");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            this.browserName = "MSIE";
            this.browserVersion = this.userAgent.substring(start + "MSIE ".length(), end);
            return;
        }
        pattern = Pattern.compile("Firefox/([0-9]{1,}(\\.[0-9]{1,}){1,})");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            this.browserName = "Firefox";
            this.browserVersion = this.userAgent.substring(start + "Firefox/".length(), end);
            this.isMozBrowser = true;
            return;
        }
        pattern = Pattern.compile("Netscape/([0-9]{1,}(\\.[0-9]{1,}){1,})");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            this.browserName = "Netscape";
            this.browserVersion = this.userAgent.substring(start + "Netscape/".length(), end);
            this.isMozBrowser = true;
            return;
        }
        pattern = Pattern.compile("Safari/([0-9]{1,}(\\.[0-9]{1,}){1,})");
        matcher = pattern.matcher(this.userAgent);
        pattern = Pattern.compile("Version/([0-9]{1,}(\\.[0-9]{1,}){1,})");
        safariVersionMatcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            this.browserName = "Safari";
            if (safariVersionMatcher.find()) {
                int start = matcher.start();
                int versionStart = safariVersionMatcher.start();
                this.browserVersion = this.userAgent.substring(versionStart + "Version/".length(), start).trim();
            } else {
                this.browserVersion = String.valueOf(2);
            }
            return;
        }
        if (this.userAgent.indexOf("Mozilla") != -1) {
            pattern = Pattern.compile("rv:([0-9]{1,}(\\.[0-9]{1,}){1,})");
            matcher = pattern.matcher(this.userAgent);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                this.browserName = "Mozilla";
                this.browserVersion = this.userAgent.substring(start + "rv:".length(), end);
                this.isMozBrowser = true;
            }
            return;
        }
    }

    private void parseOSInfo() {
        Pattern pattern = null;
        Matcher matcher = null;
        pattern = Pattern.compile("Windows NT ([0-9]{1,}(\\.[0-9]{1,}){1,})");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            String osVersion = null;
            int start = matcher.start();
            int end = matcher.end();
            osVersion = this.userAgent.substring(start + "Windows NT ".length(), end);
            if ("6.0".equals(osVersion)) {
                this.osName = "Windows Vista";
            } else if ("5.2".equals(osVersion)) {
                this.osName = "Windows Server 2003";
            } else if ("5.1".equals(osVersion)) {
                this.osName = "Windows XP";
            } else if ("5.01".equals(osVersion)) {
                this.osName = "Windows 2000 SP1";
            } else if ("5.0".equals(osVersion)) {
                this.osName = "Windows 2000";
            } else if ("4.0".equals(osVersion)) {
                this.osName = "Windows NT 4.0";
            }
            return;
        }
        pattern = Pattern.compile("Windows 9[58]");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            this.osName = this.userAgent.substring(start, end);
            return;
        }
        pattern = Pattern.compile("Mac OS X");
        matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            this.osName = this.userAgent.substring(start, end);
            return;
        }
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getOSName() {
        return this.osName;
    }

    public boolean isMozBrowser() {
        return this.isMozBrowser;
    }
}

