/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.marshall.json;

import com.ibm.form.webform.marshall.Marshaller;
import com.ibm.form.webform.marshall.MarshallingDirector;
import com.ibm.form.webform.marshall.json.JSONBooleanMarshaller;
import com.ibm.form.webform.marshall.json.JSONListMarshaller;
import com.ibm.form.webform.marshall.json.JSONMapMarshaller;
import com.ibm.form.webform.marshall.json.JSONMarshaller;
import com.ibm.form.webform.marshall.json.JSONNumberMarshaller;
import com.ibm.form.webform.marshall.json.JSONSerializableMarshaller;
import com.ibm.form.webform.marshall.json.JSONStringMarshaller;
import com.ibm.form.webform.resources.ResourceManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONMarshallingDirector
implements MarshallingDirector {
    private static Map marshallers = new HashMap();
    private static JSONMarshallingDirector instance = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;

    public static JSONMarshallingDirector getInstance() {
        if (instance == null) {
            instance = new JSONMarshallingDirector();
        }
        return instance;
    }

    public static void registerMarshaller(Class clazz, Marshaller marshaller) {
        if (!(marshaller instanceof JSONMarshaller)) {
            throw new IllegalArgumentException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/JSON_MARSHALLER_ERROR_UNIMPLEMENTED_INTERFACE"));
        }
        marshallers.put(clazz, marshaller);
    }

    public void marshall(Object object, OutputStream os) throws IOException, IllegalArgumentException {
        if (os == null) {
            throw new IllegalArgumentException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/JSON_MARSHALLER_ILLEGAL_OUTPUT_STREAM"));
        }
        if (object == null) {
            os.write("null".getBytes("UTF-8"));
        } else {
            JSONMarshaller m = (JSONMarshaller)marshallers.get(object.getClass());
            if (m != null) {
                m.marshall(this, object, os);
            } else {
                boolean found = false;
                Iterator i = marshallers.keySet().iterator();
                while (i.hasNext()) {
                    Class c = (Class)i.next();
                    if (!c.isInstance(object)) continue;
                    m = (JSONMarshaller)marshallers.get(c);
                    m.marshall(this, object, os);
                    JSONMarshallingDirector.registerMarshaller(object.getClass(), m);
                    found = true;
                    break;
                }
                if (!found) {
                    if ((class$java$io$Serializable == null ? (class$java$io$Serializable = JSONMarshallingDirector.class$("java.io.Serializable")) : class$java$io$Serializable).isInstance(object)) {
                        new JSONSerializableMarshaller().marshall(this, object, os);
                    } else {
                        throw new IllegalArgumentException(ResourceManager.getFormattedErrorMessage((String)"com.ibm.form.webform.resources/STRING/JSON_MARSHALLER_MISSING_MARSHALLER", (String)object.getClass().getName()));
                    }
                }
            }
        }
    }

    public String marshall(Object object) throws IOException, IllegalArgumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.marshall(object, baos);
        return new String(baos.toByteArray(), "UTF-8");
    }

    public void marshall(Object object, StringBuffer buffer) throws IOException, IllegalArgumentException {
        buffer.append(this.marshall(object));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JSONMarshallingDirector.registerMarshaller(class$java$lang$String == null ? (class$java$lang$String = JSONMarshallingDirector.class$("java.lang.String")) : class$java$lang$String, new JSONStringMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$lang$Integer == null ? (class$java$lang$Integer = JSONMarshallingDirector.class$("java.lang.Integer")) : class$java$lang$Integer, new JSONNumberMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$lang$Long == null ? (class$java$lang$Long = JSONMarshallingDirector.class$("java.lang.Long")) : class$java$lang$Long, new JSONNumberMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$lang$Float == null ? (class$java$lang$Float = JSONMarshallingDirector.class$("java.lang.Float")) : class$java$lang$Float, new JSONNumberMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$lang$Double == null ? (class$java$lang$Double = JSONMarshallingDirector.class$("java.lang.Double")) : class$java$lang$Double, new JSONNumberMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONMarshallingDirector.class$("java.lang.Boolean")) : class$java$lang$Boolean, new JSONBooleanMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$util$List == null ? (class$java$util$List = JSONMarshallingDirector.class$("java.util.List")) : class$java$util$List, new JSONListMarshaller());
        JSONMarshallingDirector.registerMarshaller(class$java$util$Map == null ? (class$java$util$Map = JSONMarshallingDirector.class$("java.util.Map")) : class$java$util$Map, new JSONMapMarshaller());
    }
}

