/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.logging;

import org.apache.log4j.Level;

public class PELevel
extends Level {
    private static final String ALL_STR = "ALL";
    private static final String SEVERE_STR = "SEVERE";
    private static final String WARNING_STR = "WARNING";
    private static final String INFO_STR = "INFO";
    private static final String CONFIG_STR = "CONFIG";
    private static final String FINE_STR = "FINE";
    private static final String FINER_STR = "FINER";
    private static final String FINEST_STR = "FINEST";
    private static final String OFF_STR = "OFF";
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int SEVERE_INT = 50000;
    public static final int WARNING_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int CONFIG_INT = 15000;
    public static final int FINE_INT = 10000;
    public static final int FINER_INT = 6000;
    public static final int FINEST_INT = 3000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final PELevel OFF = new PELevel(Integer.MAX_VALUE, "OFF", 8);
    public static final PELevel SEVERE = new PELevel(50000, "SEVERE", 0);
    public static final PELevel WARNING = new PELevel(30000, "WARNING", 1);
    public static final PELevel INFO = new PELevel(20000, "INFO", 2);
    public static final PELevel CONFIG = new PELevel(15000, "CONFIG", 3);
    public static final PELevel FINE = new PELevel(10000, "FINE", 4);
    public static final PELevel FINER = new PELevel(6000, "FINER", 5);
    public static final PELevel FINEST = new PELevel(3000, "FINEST", 6);
    public static final PELevel ALL = new PELevel(Integer.MIN_VALUE, "ALL", 7);

    protected PELevel(int level, String strLevel, int syslogEquiv) {
        super(level, strLevel, syslogEquiv);
    }

    public static Level toLevel(int level) {
        PELevel theLevel = null;
        switch (level) {
            case -2147483648: {
                theLevel = ALL;
                break;
            }
            case 50000: {
                theLevel = SEVERE;
                break;
            }
            case 30000: {
                theLevel = WARNING;
                break;
            }
            case 20000: {
                theLevel = INFO;
                break;
            }
            case 15000: {
                theLevel = CONFIG;
                break;
            }
            case 10000: {
                theLevel = FINE;
                break;
            }
            case 6000: {
                theLevel = FINER;
                break;
            }
            case 3000: {
                theLevel = FINEST;
                break;
            }
            case 0x7FFFFFFF: {
                theLevel = OFF;
            }
        }
        return theLevel;
    }

    public static Level toLevel(int level, Level defaultLevel) {
        Level theLevel = PELevel.toLevel(level);
        if (theLevel == null) {
            theLevel = defaultLevel;
        }
        return theLevel;
    }

    public static Level toLevel(String name, Level defaultValue) {
        PELevel newLevel = null;
        if (name == null) {
            return defaultValue;
        }
        if (name.equals(ALL_STR)) {
            newLevel = ALL;
        } else if (name.equals(SEVERE_STR)) {
            newLevel = SEVERE;
        } else if (name.equals(WARNING_STR)) {
            newLevel = WARNING;
        } else if (name.equals(INFO_STR)) {
            newLevel = INFO;
        } else if (name.equals(CONFIG_STR)) {
            newLevel = CONFIG;
        } else if (name.equals(FINE_STR)) {
            newLevel = FINE;
        } else if (name.equals(FINER_STR)) {
            newLevel = FINER;
        } else if (name.equals(FINEST_STR)) {
            newLevel = FINEST;
        } else if (name.equals(OFF_STR)) {
            newLevel = OFF;
        }
        return newLevel;
    }
}

