/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.logging;

import com.ibm.form.webform.logging.Bridge;
import com.ibm.form.webform.logging.BridgeFactory;
import com.ibm.form.webform.logging.BridgeManager;
import com.ibm.form.webform.logging.PELevel;
import com.ibm.form.webform.logging.VectorMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;

public class Logger {
    public static final String EXCEPTION_CODE = "Exception";
    public static final int DEBUG_TYPE = 1;
    public static final int BILLING_TYPE = 2;
    public static final int ERROR_TYPE = 3;
    public static final int OPERATIONAL_TYPE = 4;
    public static final int UNKNOWN_TYPE = 5;
    private static final PELevel BILLING_LEVEL = PELevel.INFO;
    private static final PELevel DEBUG_LEVEL = PELevel.FINE;
    private static final PELevel ERROR_LEVEL = PELevel.SEVERE;
    private static final PELevel OPERATIONAL_LEVEL = PELevel.INFO;
    private static final String BILLING_STR = "billing";
    private static final String DEBUG_STR = "debug";
    private static final String ERROR_STR = "error";
    private static final String OPERATIONAL_STR = "operational";
    private static final String UNKNOWN_STR = "unknown";
    private static final String CONTEXT_TAG = "context";
    private static final String OPERATION_TAG = "operation";
    private static final String MESSAGE_TAG = "message";
    private static final String DATA_TAG = "data";
    private static final String ERROR_MESSAGE_TAG = "message";
    private static final String ERROR_HISTORY_TAG = "errorHistory";
    private static final String ERROR_SERIAL_TAG = "errorSerialization";
    private static final String ERROR_CODE_TAG = "errorCode";
    private BridgeFactory myFactory;
    private Bridge debugBridge;
    private Bridge billingBridge;
    private Bridge errorBridge;
    private Bridge operationalBridge;
    private String context = "";
    private String loggerName = null;
    private String escapedContext = "";

    public Logger(String loggerTypeName) {
        this.loggerName = loggerTypeName;
        this.myFactory = BridgeManager.getDefaultBridgeFactory();
        this.debugBridge = this.myFactory.getNamedBridge(this.loggerName + "_" + DEBUG_STR);
        this.billingBridge = this.myFactory.getNamedBridge(this.loggerName + "_" + BILLING_STR);
        this.errorBridge = this.myFactory.getNamedBridge(this.loggerName + "_" + ERROR_STR);
        this.operationalBridge = this.myFactory.getNamedBridge(this.loggerName + "_" + OPERATIONAL_STR);
    }

    public Logger(String currContext, String loggerTypeName) {
        this(loggerTypeName);
        this.setContext(currContext);
    }

    public void setContext(String currContext) {
        this.context = currContext;
        this.escapedContext = Logger.escapeXMLSpecialChars(this.context);
    }

    public String getContext() {
        return this.context;
    }

    public void writeLog(int logType, Map logMap) {
        Bridge myBridge = this.getBridgeForType(logType);
        Level currLevel = Logger.getLevelForType(logType);
        if (null != myBridge && myBridge.isLoggable(currLevel)) {
            String key = null;
            String escapedValue = null;
            Map.Entry currEntry = null;
            String logTypeString = Logger.escapeXMLSpecialChars(Logger.getLogTypeString(logType));
            StringBuffer logString = new StringBuffer("\t<" + logTypeString + ">\r\n");
            Iterator mapIterator = logMap.entrySet().iterator();
            logString.append("\t\t<context>" + this.escapedContext + "</" + CONTEXT_TAG + ">\r\n");
            while (mapIterator.hasNext()) {
                currEntry = mapIterator.next();
                key = currEntry.getKey().toString();
                escapedValue = Logger.escapeXMLSpecialChars(currEntry.getValue().toString());
                logString.append("\t\t<" + key + '>' + escapedValue + "</" + key + ">\r\n");
            }
            logString.append("\t</" + logTypeString + ">");
            myBridge.log(currLevel, logString.toString());
        }
    }

    public void writeDebugLog(String theMessage, String theData, Map extraDataMap) {
        if (null == theData) {
            theData = "";
        }
        VectorMap logMap = new VectorMap();
        logMap.put("message", theMessage);
        logMap.put(DATA_TAG, theData);
        if (null != extraDataMap) {
            logMap.putAll(extraDataMap);
        }
        this.writeLog(1, logMap);
    }

    public void writeErrorLog(String theMessage, String theHistory, String theSerialization, String theCode, Map extraDataMap) {
        if (null == theHistory) {
            theHistory = "";
        }
        if (null == theSerialization) {
            theSerialization = "";
        }
        if (null == theCode) {
            theCode = "";
        }
        VectorMap logMap = new VectorMap();
        logMap.put("message", theMessage);
        logMap.put(ERROR_HISTORY_TAG, theHistory);
        logMap.put(ERROR_SERIAL_TAG, theSerialization);
        logMap.put(ERROR_CODE_TAG, theCode);
        if (null != extraDataMap) {
            logMap.putAll(extraDataMap);
        }
        this.writeLog(3, logMap);
    }

    public void writeOperationalLog(String theOperation, String theData, Map extraDataMap) {
        if (null == theData) {
            theData = "";
        }
        VectorMap logMap = new VectorMap();
        logMap.put(OPERATION_TAG, theOperation);
        logMap.put(DATA_TAG, theData);
        if (null != extraDataMap) {
            logMap.putAll(extraDataMap);
        }
        this.writeLog(4, logMap);
    }

    public void writeThrowableOperationalLog(Throwable t, Map extraDataMap) {
        if (t != null) {
            VectorMap map = new VectorMap();
            if (extraDataMap != null) {
                map.putAll(extraDataMap);
            }
            map.put("message", t.toString());
            map.put(ERROR_HISTORY_TAG, Logger.stackTraceToString(t));
            map.put(ERROR_CODE_TAG, EXCEPTION_CODE);
            this.writeLog(4, map);
        }
    }

    public void configure(String propsFileName) {
        this.myFactory.getDefaultBridge().configure(propsFileName);
    }

    public void configure(Properties props) {
        this.myFactory.getDefaultBridge().configure(props);
    }

    public static String stackTraceToString(Throwable thrown) {
        PrintWriter pw = null;
        StringWriter sw = null;
        String stackTraceStr = null;
        if (null != thrown) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            thrown.printStackTrace(pw);
            pw.close();
            stackTraceStr = sw.toString();
        }
        return stackTraceStr;
    }

    public static String escapeXMLSpecialChars(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char currChar = s.charAt(i);
            switch (currChar) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(currChar);
                }
            }
        }
        return sb.toString();
    }

    public boolean isLoggable(int logType) {
        Bridge bridge = this.getBridgeForType(logType);
        Level level = Logger.getLevelForType(logType);
        return bridge.isLoggable(level);
    }

    protected Bridge getBridgeForType(int logType) {
        Bridge theBridge = null;
        switch (logType) {
            case 4: {
                theBridge = this.operationalBridge;
                break;
            }
            case 2: {
                theBridge = this.billingBridge;
                break;
            }
            case 1: {
                theBridge = this.debugBridge;
                break;
            }
            case 3: {
                theBridge = this.errorBridge;
            }
        }
        return theBridge;
    }

    protected static Level getLevelForType(int logType) {
        PELevel theLevel = null;
        switch (logType) {
            case 4: {
                theLevel = OPERATIONAL_LEVEL;
                break;
            }
            case 2: {
                theLevel = BILLING_LEVEL;
                break;
            }
            case 1: {
                theLevel = DEBUG_LEVEL;
                break;
            }
            case 3: {
                theLevel = ERROR_LEVEL;
            }
        }
        return theLevel;
    }

    protected static String getLogTypeString(int logType) {
        String logTypeString = UNKNOWN_STR;
        switch (logType) {
            case 4: {
                logTypeString = OPERATIONAL_STR;
                break;
            }
            case 2: {
                logTypeString = BILLING_STR;
                break;
            }
            case 1: {
                logTypeString = DEBUG_STR;
                break;
            }
            case 3: {
                logTypeString = ERROR_STR;
            }
        }
        return logTypeString;
    }

    public void writeThrowableErrorLog(Throwable thrown) {
        if (this.isLoggable(3)) {
            String thrownString = "";
            if (null != thrown) {
                thrownString = thrown.toString();
            }
            VectorMap map = new VectorMap();
            this.writeErrorLog(thrownString, Logger.stackTraceToString(thrown), "", EXCEPTION_CODE, map);
        }
    }
}

