/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.logging;

import com.ibm.form.webform.logging.BridgeFactory;

public class BridgeManager {
    private static final String BRIDGE_NAME_PROPERTY = "com.ibm.form.webform.logging.bridgeFactoryClass";
    private static final String DEFAULT_BRIDGE_NAME = "com.ibm.form.webform.logging.log4j.Log4jBridgeFactory";

    private BridgeManager() {
    }

    public static BridgeFactory getDefaultBridgeFactory() {
        return BridgeManager.getBridgeFactory(System.getProperty(BRIDGE_NAME_PROPERTY, DEFAULT_BRIDGE_NAME));
    }

    public static BridgeFactory getBridgeFactory(String bridgeFactoryName) {
        BridgeFactory newFactory = null;
        try {
            newFactory = (BridgeFactory)Class.forName(bridgeFactoryName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("com.ibm.form.webform.logging.BridgeManager: could not find class " + bridgeFactoryName);
            cnfe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("com.ibm.form.webform.logging.BridgeManager: could not instantiate class " + bridgeFactoryName);
            e.printStackTrace();
        }
        return newFactory;
    }
}

