/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.json.builder;

import com.ibm.form.webform.json.JSONEncoder;
import com.ibm.form.webform.json.builder.JSONValueBuilder;
import com.ibm.form.webform.json.builder.JSONValueBuilderStateAny;
import com.ibm.form.webform.json.builder.JSONValueBuilderStateBase;

class JSONValueBuilderStateProperty
extends JSONValueBuilderStateAny {
    private boolean hasValue = false;

    JSONValueBuilderStateProperty(JSONValueBuilder owner, String name) {
        super(owner);
        if (name == null) {
            throw new IllegalStateException("property must have a name");
        }
        this.owner().append(JSONEncoder.encode(name));
        this.owner().append(":");
    }

    public JSONValueBuilder endProperty() {
        if (!this.hasValue) {
            this.empty();
        }
        this.owner().popState();
        return this.owner();
    }

    public JSONValueBuilder bool(boolean value) {
        this.checkValue("bool");
        return super.bool(value);
    }

    public JSONValueBuilder empty() {
        this.checkValue("empty");
        return super.empty();
    }

    public JSONValueBuilder number(long value) {
        this.checkValue("number");
        return super.number(value);
    }

    public JSONValueBuilder string(String value) {
        this.checkValue("string");
        return super.string(value);
    }

    public JSONValueBuilder beginObject() {
        this.checkValue("beginObject");
        return super.beginObject();
    }

    public JSONValueBuilder beginArray() {
        this.checkValue("beginArray");
        return super.beginArray();
    }

    public JSONValueBuilder literal(String literal) {
        this.checkValue("literal");
        return super.literal(literal);
    }

    private void checkValue(String type) {
        if (this.hasValue) {
            throw new IllegalStateException(JSONValueBuilderStateBase.ERROR_MESSAGE_FORMAT.format(new String[]{type}));
        }
        this.hasValue = true;
    }
}

