/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.json;

import com.ibm.form.webform.json.Lexeme;
import com.ibm.form.webform.json.LexemeType;
import com.ibm.form.webform.json.Lexer;
import com.ibm.form.webform.resources.ResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class Parser {
    private Lexer lexer = null;
    private Lexeme lexeme = null;
    private Stack result = null;

    private boolean accept(LexemeType type) {
        if (this.lexeme.getType() == type) {
            this.lexeme = this.lexer.shift();
            return true;
        }
        return false;
    }

    private boolean expect(LexemeType type) {
        if (this.accept(type)) {
            return true;
        }
        throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/JSON_PARSER_ERROR_UNEXPECTED_TYPE_SEEN"), (String[])new String[]{type.toString(), Integer.toString(this.lexeme.getLine()), Integer.toString(this.lexeme.getColumn())}));
    }

    public Parser(Lexer lexer) {
        this.lexer = lexer;
        this.result = new Stack();
    }

    public Object parse() {
        this.lexeme = this.lexer.shift();
        this.value();
        this.expect(LexemeType.EOF);
        if (this.result.capacity() == 0) {
            return null;
        }
        return this.result.pop();
    }

    private void value() {
        if (LexemeType.LBRACKET == this.lexeme.getType()) {
            this.array();
            return;
        }
        if (LexemeType.LBRACE == this.lexeme.getType()) {
            this.dictionary();
            return;
        }
        if (LexemeType.STRING == this.lexeme.getType()) {
            this.string();
            return;
        }
        if (LexemeType.NUMBER == this.lexeme.getType()) {
            this.number();
            return;
        }
        if (LexemeType.IDENTIFIER == this.lexeme.getType()) {
            this.identifier();
            return;
        }
        this.result.push(null);
    }

    private void array() {
        if (this.accept(LexemeType.LBRACKET)) {
            this.result.push(new ArrayList());
            if (LexemeType.RBRACKET != this.lexeme.getType()) {
                this.list();
            }
            this.expect(LexemeType.RBRACKET);
        }
    }

    private void list() {
        Object value = null;
        do {
            this.value();
            value = this.result.pop();
            ((List)this.result.peek()).add(value);
        } while (this.accept(LexemeType.COMMA));
    }

    private void dictionary() {
        if (this.accept(LexemeType.LBRACE)) {
            this.result.push(new HashMap());
            if (LexemeType.RBRACE != this.lexeme.getType()) {
                this.elements();
            }
            this.expect(LexemeType.RBRACE);
        }
    }

    private void elements() {
        do {
            this.element();
        } while (this.accept(LexemeType.COMMA));
    }

    private void element() {
        this.identifier();
        this.expect(LexemeType.COLON);
        this.value();
        Object value = this.result.pop();
        Object key = this.result.pop();
        ((Map)this.result.peek()).put(key, value);
    }

    private void string() {
        this.result.push(this.lexeme.getValue());
        this.accept(LexemeType.STRING);
    }

    private void number() {
        if (this.lexeme.getValue().indexOf(46) > -1) {
            this.result.push(new Double(this.lexeme.getValue()));
        } else {
            this.result.push(new Long(this.lexeme.getValue()));
        }
        this.accept(LexemeType.NUMBER);
    }

    private void identifier() {
        if ("null".equals(this.lexeme.getValue())) {
            this.result.push(null);
        } else if ("true".equals(this.lexeme.getValue())) {
            this.result.push(Boolean.TRUE);
        } else if ("false".equals(this.lexeme.getValue())) {
            this.result.push(Boolean.FALSE);
        } else {
            this.result.push(this.lexeme.getValue());
        }
        this.accept(LexemeType.IDENTIFIER);
    }
}

