/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.json;

import com.ibm.form.webform.json.Lexeme;
import com.ibm.form.webform.json.LexemeType;
import com.ibm.form.webform.json.Scanner;
import com.ibm.form.webform.json.TokenType;
import com.ibm.form.webform.resources.ResourceManager;

class Lexer {
    private Scanner scanner = null;

    Lexer(Scanner scanner) {
        this.scanner = scanner;
    }

    public synchronized Lexeme shift() {
        return this.read();
    }

    private Lexeme read() {
        Lexeme lexeme = null;
        if (this.scanner.getCurrent() == null) {
            this.scanner.shift();
        }
        while (this.scanner.getCurrent().getType() == TokenType.WHITESPACE) {
            this.scanner.shift();
        }
        if (this.scanner.getCurrent().getType() == TokenType.EOF) {
            return this.createLexeme(LexemeType.EOF);
        }
        if ('\"' == this.scanner.getCurrent().getChar() || '\'' == this.scanner.getCurrent().getChar()) {
            char startingQuote = this.scanner.getCurrent().getChar();
            lexeme = this.createLexeme(LexemeType.STRING);
            this.scanner.shift();
            while (this.scanner.getCurrent().getType() != TokenType.EOF && startingQuote != this.scanner.getCurrent().getChar()) {
                if ('\\' == this.scanner.getCurrent().getChar()) {
                    char escapedC;
                    char c = this.scanner.shift().getChar();
                    switch (c) {
                        case 'n': {
                            escapedC = '\n';
                            break;
                        }
                        case 'r': {
                            escapedC = '\r';
                            break;
                        }
                        case 't': {
                            escapedC = '\t';
                            break;
                        }
                        default: {
                            escapedC = c;
                        }
                    }
                    lexeme.append(escapedC);
                } else {
                    lexeme.append(this.scanner.getCurrent().getChar());
                }
                this.scanner.shift();
            }
            if (this.scanner.getCurrent().getChar() != startingQuote) {
                throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_UNTERMINATED_STRING_CONSTANT"), (String[])new String[]{Integer.toString(this.scanner.getLine()), Integer.toString(this.scanner.getColumn())}));
            }
            this.scanner.shift();
        } else if (TokenType.DIGIT == this.scanner.getCurrent().getType()) {
            lexeme = this.createLexeme(LexemeType.NUMBER, this.scanner.getCurrent().getChar());
            this.scanner.shift();
            while (this.scanner.getCurrent().getType() != TokenType.EOF && this.scanner.getCurrent().getType() == TokenType.DIGIT || this.scanner.getCurrent().getType() == TokenType.SYMBOL && this.scanner.getCurrent().getChar() == '.') {
                lexeme.append(this.scanner.getCurrent().getChar());
                this.scanner.shift();
            }
        } else if (TokenType.ALPHA == this.scanner.getCurrent().getType()) {
            lexeme = this.createLexeme(LexemeType.IDENTIFIER, this.scanner.getCurrent().getChar());
            this.scanner.shift();
            while (this.scanner.getCurrent().getType() != TokenType.EOF && (this.scanner.getCurrent().getType() == TokenType.ALPHA || this.scanner.getCurrent().getType() == TokenType.DIGIT || this.scanner.getCurrent().getType() == TokenType.SYMBOL && this.scanner.getCurrent().getChar() == '_')) {
                lexeme.append(this.scanner.getCurrent().getChar());
                this.scanner.shift();
            }
        } else if (':' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.COLON, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if (',' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.COMMA, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if ('[' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.LBRACKET, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if (']' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.RBRACKET, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if ('{' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.LBRACE, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if ('}' == this.scanner.getCurrent().getChar()) {
            lexeme = this.createLexeme(LexemeType.RBRACE, this.scanner.getCurrent().getChar());
            this.scanner.shift();
        } else if (TokenType.UNRECOGNIZED == this.scanner.getCurrent().getType()) {
            throw new IllegalStateException(ResourceManager.getFormattedMessage((String)ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ERROR_ILLEGAL_CHARACTER"), (String[])new String[]{Integer.toString(this.scanner.getLine()), Integer.toString(this.scanner.getColumn())}));
        }
        return lexeme;
    }

    private Lexeme createLexeme(LexemeType type) {
        return new Lexeme(type, this.scanner.getLine(), this.scanner.getColumn());
    }

    private Lexeme createLexeme(LexemeType type, char ch) {
        return new Lexeme(type, ch, this.scanner.getLine(), this.scanner.getColumn());
    }
}

