/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.json;

import com.ibm.form.webform.marshall.json.JSONMarshallingDirector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JSONEncoder {
    public static String encode(Object object) throws IllegalArgumentException, IllegalStateException {
        if (object instanceof Map) {
            return JSONEncoder.encode((Map)object);
        }
        if (object instanceof List) {
            return JSONEncoder.encode((List)object);
        }
        if (object instanceof String) {
            return JSONEncoder.encode((String)object);
        }
        if (object instanceof Number) {
            return JSONEncoder.encode((Number)object);
        }
        if (object instanceof Boolean) {
            return JSONEncoder.encode((Boolean)object);
        }
        throw new IllegalArgumentException("Object type " + object.getClass().getName() + " cannot be encoded as JSON .");
    }

    public static String encode(Map map) throws IllegalArgumentException, IllegalStateException {
        try {
            return JSONMarshallingDirector.getInstance().marshall(map);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String encode(List list) throws IllegalArgumentException {
        try {
            return JSONMarshallingDirector.getInstance().marshall(list);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String encode(String string) throws IllegalArgumentException {
        try {
            return JSONMarshallingDirector.getInstance().marshall(string);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String encode(int i) {
        return Integer.toString(i);
    }

    public static String encode(long l) {
        return Long.toString(l);
    }

    public static String encode(double d) {
        return Double.toString(d);
    }

    public static String encode(float f) {
        return Float.toString(f);
    }

    public static String encode(Number n) throws IllegalArgumentException {
        try {
            return JSONMarshallingDirector.getInstance().marshall(n);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String encode(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static String encode(Boolean b) throws IllegalArgumentException {
        try {
            return JSONMarshallingDirector.getInstance().marshall(b);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

