/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class JDBCDataSource
implements DataSource {
    public String alias;
    public String server;
    public int portNumber = 0;
    public String userId;
    public String password;
    public Connection con = null;
    private int loginTimeout_s;
    private PrintWriter logWriter;

    public JDBCDataSource(String[] argv) throws Exception {
        if (argv.length > 5 || argv.length == 1 && (argv[0].equals("?") || argv[0].equals("-?") || argv[0].equals("/?") || argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("/h") || argv[0].equalsIgnoreCase("-help") || argv[0].equalsIgnoreCase("/help"))) {
            throw new Exception("Usage: prog_name [dbAlias] [userId passwd] (use legacy JDBC type 2 driver)\n       prog_name -u2 [dbAlias] [userId passwd] (use universal JDBC type 2 driver)\n       prog_name [dbAlias] server portNum userId passwd (use universal JDBC type 4 driver)");
        }
        switch (argv.length) {
            case 0: {
                this.alias = "sample";
                this.userId = "";
                this.password = "";
                break;
            }
            case 1: {
                if (argv[0].equalsIgnoreCase("-u2")) {
                    this.alias = "sample";
                    this.portNumber = -1;
                } else {
                    this.alias = argv[0];
                }
                this.userId = "";
                this.password = "";
                break;
            }
            case 2: {
                if (argv[0].equalsIgnoreCase("-u2")) {
                    this.alias = argv[1];
                    this.userId = "";
                    this.password = "";
                    this.portNumber = -1;
                    break;
                }
                this.alias = "sample";
                this.userId = argv[0];
                this.password = argv[1];
                break;
            }
            case 3: {
                if (argv[0].equalsIgnoreCase("-u2")) {
                    this.alias = "sample";
                    this.userId = argv[1];
                    this.password = argv[2];
                    this.portNumber = -1;
                    break;
                }
                this.alias = argv[0];
                this.userId = argv[1];
                this.password = argv[2];
                break;
            }
            case 4: {
                if (argv[0].equalsIgnoreCase("-u2")) {
                    this.alias = argv[1];
                    this.userId = argv[2];
                    this.password = argv[3];
                    this.portNumber = -1;
                    break;
                }
                this.alias = "sample";
                this.server = argv[0];
                this.portNumber = Integer.valueOf(argv[1]);
                this.userId = argv[2];
                this.password = argv[3];
                break;
            }
            case 5: {
                if (argv[0].equalsIgnoreCase("-u2")) break;
                this.alias = argv[0];
                this.server = argv[1];
                this.portNumber = Integer.valueOf(argv[2]);
                this.userId = argv[3];
                this.password = argv[4];
            }
        }
    }

    public Connection getConnection() throws SQLException {
        String url = null;
        String nodeNumber = "0";
        Properties props = new Properties();
        try {
            if (this.portNumber < 0) {
                url = "jdbc:db2:" + this.alias;
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
            } else if (this.portNumber == 0) {
                url = "jdbc:db2:" + this.alias;
                Class.forName("COM.ibm.db2.jdbc.app.DB2Driver").newInstance();
            } else {
                url = "jdbc:db2://" + this.server + ":" + this.portNumber + "/" + this.alias;
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
            }
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
        if (null != this.userId) {
            props.setProperty("user", this.userId);
            props.setProperty("password", this.password);
        }
        props.setProperty("CONNECTNODE", nodeNumber);
        return DriverManager.getConnection(url, props);
    }

    public void disconnect() throws Exception {
        this.con.commit();
        this.con.close();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout_s;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public void setLoginTimeout(int loginTimeout_s) throws SQLException {
        this.loginTimeout_s = loginTimeout_s;
    }
}

