/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.webform.concurrency;

import com.ibm.form.webform.concurrency.RWLock;
import com.ibm.form.webform.resources.ResourceManager;
import java.util.ArrayList;
import java.util.List;

public class RWLockImpl
implements RWLock {
    static final int READER = 0;
    static final int WRITER = 1;
    private List waiters = new ArrayList();
    int nWriters = 0;

    public synchronized void acquireReadLock() {
        Waiter me = this.findMe();
        if (me == null) {
            me = new Waiter(0);
            this.waiters.add(me);
            int firstWriterIndex = this.getFirstWriterIndex();
            while (firstWriterIndex != Integer.MAX_VALUE && this.getMyIndex() > firstWriterIndex) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                firstWriterIndex = this.getFirstWriterIndex();
            }
        }
        me.incrementNAcquisitions();
    }

    public synchronized void acquireWriteLock() {
        Waiter me = this.findMe();
        if (me == null) {
            me = new Waiter(1);
            this.waiters.add(me);
            ++this.nWriters;
            Waiter firstWaiter = (Waiter)this.waiters.get(0);
            while (!firstWaiter.getWaitingThread().equals(me.getWaitingThread())) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                firstWaiter = (Waiter)this.waiters.get(0);
            }
        } else if (me.getWaiterType() == 0) {
            throw new IllegalStateException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ILLEGAL_STATE_EXCEPTION"));
        }
        me.incrementNAcquisitions();
    }

    public synchronized void releaseLock() {
        int myIndex = this.getMyIndex();
        if (myIndex == -1 || myIndex > this.getFirstWriterIndex()) {
            throw new IllegalStateException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ILLEGAL_STATE_EXCEPTION"));
        }
        Waiter me = (Waiter)this.waiters.get(myIndex);
        me.decrementNAcquisitions();
        if (me.getNAcquisitions() == 0) {
            this.waiters.remove(myIndex);
            if (me.getWaiterType() == 1) {
                --this.nWriters;
            }
            this.notifyAll();
        }
    }

    synchronized void validateState() {
        int firstWriterIndex = this.getFirstWriterIndex();
        if (firstWriterIndex != Integer.MAX_VALUE) {
            for (int i = firstWriterIndex + 1; i < this.waiters.size(); ++i) {
                Waiter w = (Waiter)this.waiters.get(i);
                if (w.getNAcquisitions() <= 0) continue;
                throw new IllegalStateException(ResourceManager.getErrorMessage((String)"com.ibm.form.webform.resources/STRING/ILLEGAL_STATE_EXCEPTION"));
            }
        }
    }

    private int getFirstWriterIndex() {
        if (this.nWriters > 0) {
            for (int i = 0; i < this.waiters.size(); ++i) {
                Waiter w = (Waiter)this.waiters.get(i);
                if (w.getWaiterType() != 1) continue;
                return i;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int getMyIndex() {
        Thread me = Thread.currentThread();
        for (int i = 0; i < this.waiters.size(); ++i) {
            Waiter w = (Waiter)this.waiters.get(i);
            if (!w.getWaitingThread().equals(me)) continue;
            return i;
        }
        return -1;
    }

    private Waiter findMe() {
        int myIndex = this.getMyIndex();
        if (myIndex >= 0) {
            return (Waiter)this.waiters.get(myIndex);
        }
        return null;
    }

    private class Waiter {
        private final Thread waitingThread = Thread.currentThread();
        private final int waiterType;
        private int nAcquisitions;

        public Waiter(int waiterType) {
            this.waiterType = waiterType;
            this.nAcquisitions = 0;
        }

        public int getWaiterType() {
            return this.waiterType;
        }

        public Thread getWaitingThread() {
            return this.waitingThread;
        }

        public int getNAcquisitions() {
            return this.nAcquisitions;
        }

        public void incrementNAcquisitions() {
            ++this.nAcquisitions;
        }

        public void decrementNAcquisitions() {
            --this.nAcquisitions;
        }
    }
}

