/*
 * Decompiled with CFR 0.152.
 */
package org.jsmtpd.clamav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmtpd.clamav.ClamAVScanner;
import org.jsmtpd.clamav.ScannerException;

public class NetworkScanner
implements ClamAVScanner {
    private int connectionTimeout = 90;
    private String clamdHost;
    private int clamdPort;
    private static Log log = LogFactory.getLog(NetworkScanner.class);
    private Socket protocolSocket = null;
    private Socket dataSocket = null;
    private String message = "";
    int dataPort = -1;
    private static final byte[] INIT_COMMAND = new byte[]{83, 84, 82, 69, 65, 77, 10};

    public boolean performScan(InputStream inputStream) throws ScannerException {
        try {
            this.openProtocolChannel();
            this.requestScan(inputStream);
            if (this.message == null) {
                throw new ScannerException("Clamd responded with an empty message ...");
            }
            if (this.message.equals("stream: OK")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (ScannerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw e;
        }
        finally {
            this.closeChannels();
        }
    }

    private void closeChannels() {
        block7: {
            block6: {
                if (this.protocolSocket != null) {
                    try {
                        this.protocolSocket.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debug((Object)"Error closing protocol channel", (Throwable)e);
                    }
                }
            }
            if (this.dataSocket != null) {
                try {
                    this.dataSocket.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Error closing data channel", (Throwable)e);
                }
            }
        }
    }

    private void requestScan(InputStream inputStream) throws ScannerException {
        byte[] received = new byte[1];
        this.dataSocket = new Socket();
        InetSocketAddress sockaddrData = new InetSocketAddress(this.clamdHost, this.dataPort);
        try {
            this.dataSocket.setSoTimeout(this.connectionTimeout * 1000);
        }
        catch (SocketException e) {
            throw new ScannerException("Could not set timeout parameter to dataSocket", e);
        }
        try {
            this.dataSocket.connect(sockaddrData);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.dataSocket.getOutputStream());
            this.dataSocket.close();
            inputStream.close();
        }
        catch (IOException e) {
            throw new ScannerException("Error while initializing clamd data channel", e);
        }
        while (true) {
            try {
                this.protocolSocket.getInputStream().read(received);
            }
            catch (IOException e) {
                throw new ScannerException("Error while waiting for clamd response", e);
            }
            if (received[0] == 10) break;
            this.message = this.message + new String(received);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("response: " + this.message));
        }
    }

    private void openProtocolChannel() throws ScannerException {
        String serverResponse = "";
        this.protocolSocket = new Socket();
        InetSocketAddress sockaddr = new InetSocketAddress(this.clamdHost, this.clamdPort);
        try {
            this.protocolSocket.setSoTimeout(this.connectionTimeout * 1000);
        }
        catch (SocketException e) {
            throw new ScannerException("Could not set timeout parameter to configurationSocket", e);
        }
        try {
            this.protocolSocket.connect(sockaddr);
            this.protocolSocket.getOutputStream().write(INIT_COMMAND);
            byte[] received = new byte[1];
            while (true) {
                this.protocolSocket.getInputStream().read(received);
                if (received[0] == 10) break;
                serverResponse = serverResponse + new String(received);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Channel request response: " + serverResponse));
            }
            if (!serverResponse.contains(" ")) {
                throw new ScannerException("Could not find data port, server's response is " + serverResponse);
            }
            this.dataPort = Integer.parseInt(serverResponse.split(" ")[1]);
        }
        catch (NumberFormatException e) {
            throw new ScannerException("Could not understaind the server port to connect to in response: " + serverResponse);
        }
        catch (IOException e) {
            throw new ScannerException("Error while requesting protocol channel", e);
        }
    }

    public void reset() {
        this.protocolSocket = null;
        this.dataSocket = null;
        this.dataPort = -1;
        this.message = "";
    }

    public String getMessage() {
        return this.message;
    }

    public void setClamdHost(String clamdHost) {
        this.clamdHost = clamdHost;
    }

    public void setClamdPort(int clamdPort) {
        this.clamdPort = clamdPort;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

