<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- 
$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/domino/index-xml-to-html.xsl 1     23.06.03 15:17 Kbg $
Copyright (C) 2002 GoPro Development.  All rights reserved
-->
	<xsl:output method="html"/>
	<xsl:template match="/">
 		<html>
		<head>
		<title>
		<xsl:value-of select="//info/databasetitle"/>
		</title>
		<xsl:comment>$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/domino/index-xml-to-html.xsl 1     23.06.03 15:17 Kbg $</xsl:comment>
		</head>
 		<body>
		<h1>
		<xsl:value-of select="//info/databasetitle"/>
		</h1>
		<hr/>
		<xsl:apply-templates select="//info"/>
		<hr/>
 		<xsl:apply-templates select="//documents"/>
		<hr/>
		<h2>XML</h2>
		<ul>
		<li>
			<a>
			<xsl:attribute name="href">
			<xsl:text>./index.xml</xsl:text>
			</xsl:attribute>
			<xsl:text>This document as XML</xsl:text>
			</a>
		</li>
		</ul>
		<hr/>
	 	</body>
	 	</html>
	</xsl:template>
 
	<xsl:template match="//info">
		<h2>Info</h2>
		<ul>
    	<xsl:for-each select = "//info/*" > 
			<li>
        	<strong><xsl:value-of select = "name()" /> </strong>
			<xsl:text> </xsl:text>
            <xsl:value-of select = "." /> 
			</li>
		</xsl:for-each>
		</ul>
	</xsl:template>		 

	<xsl:template match="documents">
		<h2>Documents</h2>
		<ul>
		<xsl:apply-templates select="document" />
		</ul>
	</xsl:template>		 

	<xsl:template match="document">
		<li>
		<a>
		<xsl:attribute name="name">
		<xsl:value-of select="@xmlbasename"/>
		</xsl:attribute>
		<a>
		<xsl:attribute name="href">
		<xsl:text>html/</xsl:text>
		<xsl:value-of select="@xmlbasename"/>
		<xsl:text>.html</xsl:text>
		</xsl:attribute>
		<xsl:value-of select="@subject"/>
		</a>
		</a>
	 	<xsl:apply-templates />
		</li>
	</xsl:template>		 

	<xsl:template match="children">
		<ul>
	 	<xsl:apply-templates select="document" />
		</ul>
	</xsl:template>		 
</xsl:stylesheet>
